/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.PriorityQueue;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ForkJoinWorkerThread;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkUnloader;
import pregenerator.common.generator.GeneratorQueue;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.collections.FIFOQueue;
import pregenerator.common.utils.misc.Area;
import pregenerator.common.utils.misc.IntCounter;

public class ChunkProcessor
implements IProcess<ChunkProcess, ITask> {
    public static Logger LOGGER = LogManager.getLogger((String)"Pregen");
    IntCounter gen_speed = new IntCounter(20000);
    IntCounter light_speed = new IntCounter(20000);
    IntCounter timeout = new IntCounter(2400);
    IProcess.PrepareProgress progress = null;
    ITask task;
    String taskName;
    ChunkProcess process = null;
    GeneratorQueue mainQueue = new GeneratorQueue(1000, 1, true, this::onMainPassFinished);
    GeneratorQueue lightQueue = new GeneratorQueue(750, 3, false, this::onLightPassFinished);
    ChunkUnloader unloader = new ChunkUnloader();
    FIFOQueue<ChunkEntry> chunksToLight = new FIFOQueue();
    Instant start;
    Duration terrainFinish = null;
    boolean multithreaded = false;
    boolean wasFull = false;
    long normalDone = 0L;
    long lightDone = 0L;
    long toLight = 0L;
    int ticker = 0;
    boolean unpaused = true;
    boolean prepaire = false;

    @Override
    public void prepaireTask(IProcess.PrepareProgress progress, String taskName) {
        this.progress = progress;
        this.taskName = taskName;
        this.prepaire = true;
    }

    @Override
    public boolean startTask(ITask task, ChunkProcess process) {
        if (process == null || task == null || !this.prepaire || this.progress != null && !this.progress.isAlive()) {
            return false;
        }
        this.gen_speed.clear();
        this.light_speed.clear();
        this.chunksToLight.clear();
        this.timeout.clear();
        this.normalDone = 0L;
        this.lightDone = 0L;
        this.toLight = 0L;
        this.ticker = 0;
        this.task = task;
        this.process = process;
        this.start = Instant.now();
        this.unpaused = true;
        this.prepaire = false;
        this.wasFull = false;
        this.progress = null;
        this.multithreaded = PregenConfig.INSTANCE.threadScheduler.get();
        this.lightQueue.setActiveFiles(this.multithreaded ? 3 : 1);
        return true;
    }

    @Override
    public boolean isMultithreaded() {
        return this.multithreaded;
    }

    @Override
    public boolean isBlockingRetrogen() {
        return true;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    public ITask getTask() {
        return this.task;
    }

    @Override
    public UUID getTaskId() {
        return this.task == null ? null : this.task.getTaskId();
    }

    @Override
    public boolean isRunning() {
        return this.unpaused;
    }

    @Override
    public void pauseTask() {
        if (this.process == null || !this.unpaused) {
            return;
        }
        if (this.task != null) {
            this.task.addActiveTime(Duration.between(this.start, Instant.now()).toMillis());
        }
        this.unpaused = false;
    }

    @Override
    public void resumeTask() {
        if (this.process == null || this.unpaused) {
            return;
        }
        this.unpaused = true;
        this.timeout.clear();
        this.start = Instant.now();
    }

    @Override
    public void stopTask() {
        this.prepaire = false;
        if (this.process == null) {
            return;
        }
        if (this.multithreaded) {
            this.process.clearTasks();
            this.chunksToLight.clear();
            return;
        }
        TaskStorage.getGenStorage().stopTask(this.getTaskName());
        this.process.interrupt();
        this.mainQueue.interrupt();
        this.lightQueue.interrupt();
        this.unloader.forceFinish(this.process);
        this.chunksToLight.clear();
        this.process = null;
        if (this.task != null) {
            this.task.addActiveTime(Duration.between(this.start, Instant.now()).toMillis());
            this.task = null;
        }
        if (this.progress != null) {
            this.progress.interruptTask();
            this.progress = null;
        }
    }

    @Override
    public void onTickStart() {
        if (this.progress != null && this.ticker++ % 20 == 0) {
            if (!this.progress.isAlive()) {
                this.stopTask();
                return;
            }
            long value = this.progress.getValue();
            long max = this.progress.getMax();
            double progress = (double)value / (double)max * 100.0;
            ServerManager.INSTANCE.listen((Component)TextUtil.translate("process.chunk_pregen.prepare", NUMBERS.format(value), NUMBERS.format(max), IProcess.FLOATING_NUMBERS.format(progress)).m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    public void onTickStop(boolean paused) {
        if (this.process == null || paused) {
            return;
        }
        this.toLight += this.unloader.process((PriorityQueue<ChunkEntry>)this.chunksToLight);
        this.process.onTick();
        if (this.unpaused) {
            if (this.multithreaded || !this.process.getTaskType().hasSubTask()) {
                this.process.drainIntoQueue(this.mainQueue);
                while (!this.chunksToLight.isEmpty() && this.lightQueue.enqueue((ChunkEntry)this.chunksToLight.first())) {
                    this.toLight -= (long)((ChunkEntry)this.chunksToLight.dequeue()).getTotalSize();
                }
            } else {
                this.process.drainIntoQueue(this.lightQueue);
            }
        }
        this.mainQueue.tick();
        this.lightQueue.tick();
        this.gen_speed.setNewValue(this.normalDone + (long)this.mainQueue.getSubProgress());
        if (this.lightDone > 0L || this.lightQueue.getSubProgress() > 0) {
            this.light_speed.setNewValue(this.lightDone + (long)this.lightQueue.getSubProgress());
        }
        if (this.ticker++ % 20 == 0 && this.unpaused) {
            MutableComponent text = TextUtil.translate("process.chunk_pregen.logger_split").m_6879_();
            List<ChunkLogger> logger = PregenConfig.INSTANCE.loggerOrder.get();
            int m = logger.size();
            for (int i = 0; i < m; ++i) {
                ChunkLogger log = logger.get(i);
                log.append(text, this);
                if (i == m - 1) continue;
                text.m_7220_((Component)TextUtil.translate("process.chunk_pregen.logger_split"));
            }
            ServerManager.INSTANCE.listen((Component)text);
            if (!this.mainQueue.isNotWorking() && this.timeout.isFull() && this.timeout.getTotalValue() <= 0.0f) {
                this.printThreadPool();
                this.mainQueue.attemptUnstucking();
                this.timeout.clear();
            }
        }
        if (this.task != null) {
            if (this.wasFull != this.light_speed.isFull()) {
                boolean wasntFull = !this.wasFull;
                this.wasFull = this.light_speed.isFull();
                if (wasntFull) {
                    PregenConfig.INSTANCE.storeSpeed(this.task.getDimension(), this.light_speed.getTotalValue());
                }
            } else if (this.wasFull && this.ticker % 24000 == 0) {
                PregenConfig.INSTANCE.storeSpeed(this.task.getDimension(), this.light_speed.getTotalValue());
            }
        }
        this.process.getProvider().m_7827_().m_9409_();
        if (this.process.isDone() && this.mainQueue.isNotWorking() && this.lightQueue.isNotWorking() && this.unloader.isFinished() && this.unpaused) {
            this.onTaskFinished();
        }
    }

    public void printThreadPool() {
        MutableComponent component = TextUtil.translate("process.chunk_pregen.stuck.start");
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread thread = entry.getKey();
            if (!(thread instanceof ForkJoinWorkerThread) || ((ForkJoinWorkerThread)thread).getPool() != Util.m_183991_()) continue;
            MutableComponent threadData = TextUtil.translate("process.chunk_pregen.stuck.thread", thread.getName());
            for (StackTraceElement element : entry.getValue()) {
                threadData.m_130946_(element.toString()).m_7220_((Component)TextUtil.translate("process.chunk_pregen.stuck.split"));
            }
            component.m_7220_((Component)threadData);
        }
        ChunkPregenerator.LOGGER.info(component.getString());
    }

    protected void onTaskFinished() {
        ServerManager.INSTANCE.listen((Component)TextUtil.translate("process.chunk_pregen.finish.cleanup"));
        this.process.getProvider().m_8419_(false);
        ServerManager.INSTANCE.listen((Component)TextUtil.translate("process.chunk_pregen.finish", this.getTime(), this.process.getTotalChunks()));
        Duration time = this.getWorkTime();
        long total = this.process.getTotalChunks();
        this.process.onTaskFinished();
        this.process = null;
        this.task.onCompletion(this.terrainFinish == null ? time : this.terrainFinish, time, total);
        TaskStorage.getGenStorage().removeTask(this.task.getName());
        ServerManager.INSTANCE.onTaskFinished(this.task.getDimension());
        this.task = null;
    }

    protected void onMainPassFinished(ChunkEntry file) {
        this.normalDone += (long)file.getTotalSize();
        if (this.process.isDone() && this.mainQueue.isNotWorking()) {
            this.terrainFinish = this.getWorkTime();
        }
        if (file.isUnloaded()) {
            this.lightDone += (long)file.getTotalSize();
            return;
        }
        if (this.unpaused && file.hasSubTask() && !file.isTaskFinished() && this.lightQueue.isNotWorking() && this.lightQueue.enqueue(file)) {
            return;
        }
        if (file.isSkipped()) {
            file.removeSkip();
            if (file.hasSubTask()) {
                this.chunksToLight.enqueue(file);
                this.toLight += (long)file.getTotalSize();
            }
            return;
        }
        this.unloader.enqueue(file);
    }

    protected void onLightPassFinished(ChunkEntry file) {
        this.lightDone += (long)file.getTotalSize();
        this.unloader.enqueue(file);
    }

    protected Duration getWorkTime() {
        Duration duration = Duration.between(Instant.now(), this.start).abs();
        return this.task == null ? duration : duration.plusMillis(this.task.getActiveTime());
    }

    protected String getTime() {
        return DurationFormatUtils.formatDuration((long)this.getWorkTime().toMillis(), (String)"HH:mm:ss");
    }

    public long getTotal() {
        return this.process != null ? this.process.getTotalChunks() : 0L;
    }

    public long getGenDone() {
        return this.multithreaded ? this.gen_speed.getLastValue() : this.light_speed.getLastValue();
    }

    public long getLightDone() {
        return this.light_speed.getLastValue();
    }

    public float getActiveSpeed() {
        return this.light_speed.getTotalValue();
    }

    @Override
    public long getExpectedTime() {
        if (this.process == null) {
            return 0L;
        }
        float value = this.light_speed.getTotalValue();
        if (value <= 0.0f) {
            return 0L;
        }
        return (long)((float)(this.process.getTotalChunks() - this.lightDone) / value) * 50L;
    }

    @Override
    public byte getClientDataId() {
        return 1;
    }

    @Override
    public void sendClientData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.prepaire || this.task == null || this.process == null);
        buffer.m_130070_(this.taskName);
        buffer.writeByte(this.task != null ? this.task.getGenType() : -1);
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        if (this.prepaire || this.task == null || this.process == null) {
            buffer.writeLong(this.progress == null ? 0L : this.progress.getValue());
            buffer.writeLong(this.progress == null ? 0L : this.progress.getMax());
            return;
        }
        buffer.writeBoolean(this.unpaused);
        if (this.process.isValidating()) {
            buffer.writeBoolean(true);
            long[] progress = this.process.getValidationProgress();
            buffer.writeLong(progress[0]);
            buffer.writeLong(progress[1]);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.multithreaded);
        buffer.writeLong(this.getWorkTime().toMillis());
        buffer.writeLong(this.process.getTotalChunks());
        buffer.writeLong(this.multithreaded || !this.process.getTaskType().hasSubTask() ? this.gen_speed.getLastValue() : this.light_speed.getLastValue());
        buffer.writeFloat(this.multithreaded || !this.process.getTaskType().hasSubTask() ? this.gen_speed.getTotalValue() : this.light_speed.getTotalValue());
        buffer.writeLong(this.light_speed.getLastValue());
        buffer.writeFloat(this.light_speed.getTotalValue());
        buffer.writeInt(this.process.getPointsOfInterest());
        buffer.writeInt(this.process.getLoadedChunks());
        buffer.writeLong(this.toLight);
        buffer.writeInt(this.unloader.getChunksToUnload());
        Area area = this.lightQueue.getWorkingArea();
        buffer.writeBoolean(area != null);
        if (area != null) {
            area.write(buffer);
        }
        buffer.m_130077_(this.task.getTaskId());
    }
}

