/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.base.api.TextUtil;
import pregenerator.base.mixins.common.storage.RegionSectionCacheMixin;
import pregenerator.common.base.GenTaskStorage;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.commands.BenchmarkCommand;
import pregenerator.common.commands.DeletionCommand;
import pregenerator.common.commands.GenCommand;
import pregenerator.common.commands.InfoCommand;
import pregenerator.common.commands.RetrogenCommand;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.minitasks.AgeScan;
import pregenerator.common.generator.minitasks.CorruptionScan;
import pregenerator.common.generator.minitasks.ScanSize;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.DimensionManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class PregenCommand {
    public static PregenCommand INSTANCE = new PregenCommand();

    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher, boolean advArgs) {
        CommandBuilder source = new CommandBuilder(((LiteralArgumentBuilder)Commands.m_82127_((String)"pregen").executes(CommandBuilder.action(PregenCommand::commandDocumentation))).requires(T -> T.m_6761_(3)));
        CommandBuilder builder = new CommandBuilder("start");
        builder.merge(GenCommand.INSTANCE.createGenStart(advArgs)).popTop();
        builder.merge(DeletionCommand.createDeletionCommand(advArgs)).popTop();
        builder.merge(BenchmarkCommand.createBenchmark(advArgs)).popTop();
        source.merge(builder).popTop();
        source.merge(RetrogenCommand.createRetogenCommand()).popTop();
        source.merge(InfoCommand.createInfoCommand()).popTop();
        source.merge(PregenCommand.createScanTasks()).popTop();
        PregenCommand.createControlTasks(source).popTop();
        source.merge(INSTANCE.createSimpleTasks(new CommandBuilder("utils"))).popTop();
        dispatcher.getRoot().addChild(source.build());
        dispatcher.getRoot().addChild((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pregen_info").requires(T -> !T.m_6761_(3))).executes(CommandBuilder.action(PregenCommand::permissionInfo))).build());
    }

    static CommandBuilder createScanTasks() {
        CommandBuilder builder = new CommandBuilder("scan");
        builder.literal("worldsize").arg("dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), PregenCommand::scanSize).pop(2);
        builder.literal("worldage").arg("dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), PregenCommand::scanAge).pop(2);
        builder.literal("worldcorruption").arg("dimension", (ArgumentType<?>)DimensionArgument.m_88805_(), PregenCommand::scanCorruption);
        return builder;
    }

    static CommandBuilder createControlTasks(CommandBuilder source) {
        source.literal("taskList").literal("gen", PregenCommand::listGenTasks).pop();
        source.literal("deletion", PregenCommand::listDeletionTasks).popTop();
        Consumer<CommandWrapper> cmd = T -> ServerManager.INSTANCE.pauseTask(T.getOrDefault("Task Name", String.class, null), T::sendFeedBackMessage);
        source.literal("pause", cmd).arg("Task Name", (ArgumentType<?>)StringArgumentType.word(), cmd).popTop();
        cmd = T -> ServerManager.INSTANCE.resumeTask(T.getOrDefault("Task Name", String.class, null), T::sendFeedBackMessage);
        source.literal("resume", cmd).arg("Task Name", (ArgumentType<?>)StringArgumentType.word(), cmd).popTop();
        source.literal("continue", PregenCommand::continueAny);
        source.arg("Task Name", (ArgumentType<?>)StringArgumentType.word(), CommandBuilder.suggestions(TaskStorage::getTasks), PregenCommand::continueTask).popTop();
        source.literal("stop", PregenCommand::stopAll);
        source.arg("Task Name", (ArgumentType<?>)StringArgumentType.word(), CommandBuilder.suggestions(TaskStorage::getActiveTasks), PregenCommand::stopTask);
        source.arg("Delete Task", (ArgumentType<?>)BoolArgumentType.bool(), PregenCommand::stopTask).popTop();
        source.literal("clear", PregenCommand::clearTask);
        source.arg("Task Name", (ArgumentType<?>)StringArgumentType.word(), CommandBuilder.suggestions(TaskStorage::getTasks), PregenCommand::clearTask).popTop();
        source.literal("processors", PregenCommand::processorCount).popTop();
        return source;
    }

    protected CommandBuilder createSimpleTasks(CommandBuilder source) {
        source.literal("dimensions").literal("info", PregenCommand::infoDimensions).pop();
        source.literal("disable").arg("dim", (ArgumentType<?>)DimensionArgument.m_88805_(), PregenCommand::disableDimension).pop(2);
        source.literal("enable").arg("dim", (ArgumentType<?>)DimensionArgument.m_88805_(), CommandBuilder.resourceSuggestions(DimensionManager.DimensionRegistry::getDims), PregenCommand::enableDimension).popTop();
        source.literal("cleanpois").arg("dim", (ArgumentType<?>)DimensionArgument.m_88805_(), PregenCommand::cleanPois).popTop();
        return source;
    }

    private static void scanAge(CommandWrapper wrapper) {
        ResourceKey<Level> dimension = wrapper.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().m_129880_(dimension) == null) {
            wrapper.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startMiniTask(UUID.randomUUID(), new AgeScan(dimension, wrapper.getSenderId()));
        ServerManager.INSTANCE.updateListeners(wrapper.getSenderId(), true);
    }

    private static void scanCorruption(CommandWrapper wrapper) {
        ResourceKey<Level> dimension = wrapper.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().m_129880_(dimension) == null) {
            wrapper.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startMiniTask(UUID.randomUUID(), new CorruptionScan(dimension, wrapper.getSenderId()));
        ServerManager.INSTANCE.updateListeners(wrapper.getSenderId(), true);
    }

    private static void scanSize(CommandWrapper wrapper) {
        ResourceKey<Level> dimension = wrapper.getDimension("Dimension");
        if (ServerLifecycleHooks.getCurrentServer().m_129880_(dimension) == null) {
            wrapper.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        ServerManager.INSTANCE.startMiniTask(UUID.randomUUID(), new ScanSize(dimension, wrapper.getSenderId()));
        ServerManager.INSTANCE.updateListeners(wrapper.getSenderId(), true);
    }

    private static void cleanPois(CommandWrapper wrapper) {
        ResourceKey<Level> dimension = wrapper.getDimension("dim");
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(dimension);
        if (level == null) {
            wrapper.sendErrorMessage((Component)TextUtil.dimensionMissing());
            return;
        }
        wrapper.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.pois.cleaning.start"));
        ServerChunkCache cache = level.m_7726_();
        cache.m_8419_(true);
        wrapper.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.pois.cleaning.saved"));
        Long2ObjectMap map = ((RegionSectionCacheMixin)cache.m_8484_()).getStorage();
        int deleted = map.size();
        map.keySet().removeIf(T -> ChunkProcess.getHolder(cache, ChunkPos.m_45589_((int)SectionPos.m_123213_((long)T), (int)SectionPos.m_123230_((long)T))) == null);
        wrapper.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.pois.cleaning.deleted", TextUtil.NUMBERS.format(deleted -= map.size())));
    }

    private static void commandDocumentation(CommandWrapper source) {
        Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/TinyModularThings/Chunk-Pregenerator-Issue-Tracker/wiki")).m_131140_(ChatFormatting.BLUE);
        source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.info.documentation", TextUtil.translate("command.chunk_pregen.info.documentation.click_me").m_6879_().m_130948_(style)).m_130940_(ChatFormatting.RED));
    }

    private static void permissionInfo(CommandWrapper source) {
        source.sendErrorMessage((Component)TextUtil.translate("command.chunk_pregen.error.missing_permission"));
    }

    private static void disableDimension(CommandWrapper source) {
        DimensionManager.INSTANCE.disableDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)source.get("dim", ResourceLocation.class)), source::sendFeedBackMessage);
    }

    private static void enableDimension(CommandWrapper source) {
        DimensionManager.INSTANCE.enableDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)source.get("dim", ResourceLocation.class)), source::sendFeedBackMessage);
    }

    private static void infoDimensions(CommandWrapper source) {
        source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.dimension.info"));
    }

    private static void processorCount(CommandWrapper source) {
        source.sendFeedBackMessage((Component)TextUtil.translate("command.chunk_pregen.misc.cpu", Runtime.getRuntime().availableProcessors(), ServerManager.INSTANCE.getProcessors()));
    }

    private static void continueTask(CommandWrapper source) {
        ServerManager.INSTANCE.continueTask(source.getOrDefault("Task Name", String.class, null), source.getSenderId(), source);
    }

    private static void continueAny(CommandWrapper source) {
        ServerManager.INSTANCE.continueTask(source::sendFeedBackMessage);
    }

    private static void clearTask(CommandWrapper source) {
        ServerManager.INSTANCE.removeTask(source.getOrDefault("Task Name", String.class, null), source);
    }

    private static void stopTask(CommandWrapper source) {
        if (source.getOrDefault("Delete Task", Boolean.class, false).booleanValue()) {
            ServerManager.INSTANCE.removeTask(source.get("Task Name", String.class), source);
            return;
        }
        ServerManager.INSTANCE.stopTask(source.get("Task Name", String.class), source, false);
    }

    private static void stopAll(CommandWrapper source) {
        ServerManager.INSTANCE.stopTask(null, source::sendFeedBackMessage, false);
    }

    private static void listGenTasks(CommandWrapper source) {
        GenTaskStorage storage = TaskStorage.getGenStorage();
        boolean empty = true;
        for (String s : storage.getTasks()) {
            empty = false;
            ITask task = (ITask)storage.getTask(s);
            MutableComponent desc = task.getTaskDescription();
            if (storage.isTaskActive(s)) {
                desc.m_7220_((Component)TextUtil.translate("task.chunk_pregen.active_task"));
            }
            source.sendFeedBackMessage((Component)desc);
        }
        if (empty) {
            source.sendErrorMessage((Component)TextUtil.translate("task.chunk_pregen.no_tasks").m_6879_().m_130940_(ChatFormatting.RED));
        }
    }

    private static void listDeletionTasks(CommandWrapper source) {
        SimpleTaskStorage<IDeletionTask> storage = TaskStorage.getDeletionStorage();
        boolean empty = true;
        for (String s : storage.getTasks()) {
            empty = false;
            IDeletionTask task = storage.getTask(s);
            MutableComponent desc = task.getTaskDescription();
            if (storage.isTaskActive(s)) {
                desc.m_7220_((Component)TextUtil.translate("task.chunk_pregen.active_task"));
            }
            source.sendFeedBackMessage((Component)desc);
        }
        if (empty) {
            source.sendErrorMessage((Component)TextUtil.translate("task.chunk_pregen.no_tasks").m_6879_().m_130940_(ChatFormatting.RED));
        }
    }
}

