/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.client.info.IRenderObj;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.TaskPacket;

public class DeletionProcessorInfo
implements IProcessorInfo {
    List<IRenderObj> objects = new ObjectArrayList();
    boolean minimized = false;
    float height;
    ResourceKey<Level> dimension;

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        String taskName = buffer.m_130277_();
        boolean preparing = buffer.readBoolean();
        long totalMemory = buffer.readLong();
        long maxMemory = buffer.readLong();
        long freeMemory = buffer.readLong();
        long prepValue = 0L;
        long prepMax = 0L;
        boolean running = false;
        long duration = 0L;
        long totalChunks = 0L;
        long chunksDone = 0L;
        long chunksFailed = 0L;
        if (preparing) {
            prepValue = buffer.readLong();
            prepMax = buffer.readLong();
        } else {
            running = buffer.readBoolean();
            duration = buffer.readLong();
            totalChunks = buffer.readLong();
            chunksDone = buffer.readLong();
            chunksFailed = buffer.readLong();
        }
        this.objects.clear();
        this.objects.add(new HeaderMenu(taskName));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.header", Align.CENTER));
        this.objects.add(IRenderObj.padding(1.0f));
        this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.name", taskName));
        if (this.minimized) {
            if (preparing) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.prep"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.prep.progress", NUMBERS.format(prepValue), NUMBERS.format(prepMax), (float)prepValue / (float)prepMax));
            } else if (!running) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.paused"));
            } else {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.running_time", DurationFormatUtils.formatDuration((long)duration, (String)"HH:mm:ss")));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(chunksDone), NUMBERS.format(totalChunks), Math.min(1.0f, (float)chunksDone / (float)totalChunks)));
            }
        } else {
            this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.dimension", this.dimension == null ? TextUtil.translate("ui.chunk_pregen.deleter.dimension.unknown") : TextUtil.dimension(this.dimension)));
            if (preparing) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.prep"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.prep.progress", NUMBERS.format(prepValue), NUMBERS.format(prepMax), (float)prepValue / (float)prepMax));
                this.objects.add(IRenderObj.padding(1.0f));
            } else if (!running) {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.paused"));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.padding(1.0f));
            } else {
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.running_time", DurationFormatUtils.formatDuration((long)duration, (String)"HH:mm:ss")));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.tracker.ram", NUMBERS.format(totalMemory - freeMemory >> 20), NUMBERS.format(maxMemory >> 20), maxMemory <= 0L ? 0.0f : (float)(totalMemory - freeMemory) / (float)maxMemory));
                this.objects.add(IRenderObj.padding(3.0f));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.progress.header", Align.CENTER));
                this.objects.add(IRenderObj.padding(0.5f));
                this.objects.add(IRenderObj.bar("ui.chunk_pregen.deleter.progress", NUMBERS.format(chunksDone), NUMBERS.format(totalChunks), Math.min(1.0f, (float)chunksDone / (float)totalChunks)));
                this.objects.add(IRenderObj.padding(1.5f));
                this.objects.add(IRenderObj.text("ui.chunk_pregen.deleter.failed", NUMBERS.format(chunksFailed)));
            }
        }
        this.objects.add(new FooterMenu(running, taskName));
        this.height = IRenderObj.height(this.objects);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper helper, int x, int y, float scale) {
        helper.setupCanvasSize(100.0f);
        helper.drawArea(x, y, 100.0f, this.height - 2.0f);
        float yOffset = 3.0f;
        for (IRenderObj obj : this.objects) {
            obj.render(helper, x + 4, (float)y + yOffset, 100.0f, scale);
            yOffset += obj.height();
        }
    }

    @Override
    public boolean onClick(int mouseX, int mouseY) {
        for (IRenderObj obj : this.objects) {
            if (!obj.onClick(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getID() {
        return 2;
    }

    @Override
    public int getWidth() {
        return 109;
    }

    @Override
    public int getHeight() {
        return (int)this.height + 6;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class HeaderMenu
    extends IRenderObj.Interactable {
        PregenButton close = this.addChild(new PregenButton(0, 0, 12, 12, (Component)TextUtil.literal("X"), this::onClose));
        PregenButton minimize = this.addChild(new PregenButton(0, 0, 12, 12, (Component)TextUtil.literal("_"), this::onMinimize));
        String taskId;

        public HeaderMenu(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public float height() {
            return 0.0f;
        }

        private void onClose(Button button) {
            PregenConfig.INSTANCE.pregenOverlay.setEnabled(false);
            PregenConfig.INSTANCE.save();
        }

        private void onMinimize(Button button) {
            DeletionProcessorInfo.this.minimized = !DeletionProcessorInfo.this.minimized;
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.close.m_252865_((int)((x + width - 2.0f) * posScale) - (int)((float)this.close.m_5711_() * 0.5f * scale));
            this.close.m_253211_((int)((y - 1.0f) * posScale));
            this.minimize.m_252865_((int)((x + width - 8.0f) * posScale) - (int)((float)this.minimize.m_5711_() * 0.5f * scale));
            this.minimize.m_253211_((int)((y - 1.0f) * posScale));
        }
    }

    public static class FooterMenu
    extends IRenderObj.Interactable {
        PregenButton remove = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("ui.chunk_pregen.deleter.remove"), this::onRemove));
        PregenButton stop = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate("ui.chunk_pregen.deleter.stop"), this::onStop));
        PregenButton pause;
        boolean paused;
        String taskId;

        public FooterMenu(boolean paused, String taskId) {
            this.paused = paused;
            this.taskId = taskId;
            this.pause = this.addChild(new PregenButton(0, 0, 50, 14, (Component)TextUtil.translate(paused ? "ui.chunk_pregen.deleter.pause" : "ui.chunk_pregen.deleter.resume"), this::onPause));
        }

        @Override
        public float height() {
            return 7.0f;
        }

        private void onRemove(Button button) {
            NetworkManager.INSTANCE.sendToServer(new TaskPacket.Action(4, this.taskId));
        }

        private void onStop(Button button) {
            NetworkManager.INSTANCE.sendToServer(new TaskPacket.Action(2, this.taskId));
        }

        private void onPause(Button button) {
            NetworkManager.INSTANCE.sendToServer(new TaskPacket.Action(this.paused ? 0 : 1, this.taskId));
        }

        @Override
        public void setupInteractables(float x, float y, float width, float scale, float posScale) {
            this.remove.m_252865_((int)(x * posScale));
            this.remove.m_253211_((int)(y * posScale));
            this.stop.m_252865_((int)(x * posScale) + (int)(25.0f * posScale));
            this.stop.m_253211_((int)(y * posScale));
            this.pause.m_252865_((int)(x * posScale) + (int)(50.0f * posScale));
            this.pause.m_253211_((int)(y * posScale));
        }
    }
}

