/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui.commands;

import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.CycleButton;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenText;
import pregenerator.common.deleter.tasks.DeletionExcess;
import pregenerator.common.deleter.tasks.DeletionTimeOut;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.common.networking.packets.MemoryPacket;
import pregenerator.common.utils.misc.GenShape;
import pregenerator.common.utils.misc.LongEaser;

public class DeleteCommandScreen
extends BasePregenScreen
implements MemoryPacket.IMemoryReceiver {
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 20L, 24000L, 1728000L};
    Screen parent;
    protected int xOff = 0;
    protected CycleButton.CycleState<Integer> type = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getTypeName, 0, 1, 2, 3, 4);
    protected CycleButton.CycleState<GenShape> shape = new CycleButton.CycleState<GenShape>(GenShape.SQUARE, GenShape::getName, GenShape.values());
    protected PregenText.TextState startX = new PregenText.TextState("0", this.number(false));
    protected CycleButton.CycleState<Boolean> startXType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> startXRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected PregenText.TextState startZ = new PregenText.TextState("0", this.number(false));
    protected CycleButton.CycleState<Boolean> startZType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> startZRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected PregenText.TextState endX = new PregenText.TextState("100", this.number(true));
    protected CycleButton.CycleState<Boolean> endXType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> endXRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected PregenText.TextState endZ = new PregenText.TextState("200", this.number(true));
    protected CycleButton.CycleState<Boolean> endZType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> endZRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected CycleButton.CycleState<Integer> time = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getTimeName, 0, 1, 2, 3);
    protected CycleButton.CycleState<ResourceKey<Level>> dimension = new CycleButton.CycleState<ResourceKey<Level>>(Level.f_46428_, TextUtil::dimension, this.dimensions());
    protected PregenText.TextState taskName = new PregenText.TextState("", T -> !T.contains(" "), "ExampleTask");
    protected PregenButton startGen;
    protected PregenButton cancel;
    long expectedChunks = 0L;
    long mb = 0L;
    long used = -1L;
    LongEaser progress = new LongEaser(0L);

    public DeleteCommandScreen(Screen parent) {
        super((Component)TextUtil.guiConstructor());
        this.parent = parent;
        this.sendToServer(new MemoryPacket.RequestUsed((ResourceKey<Level>)Level.f_46428_));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.cycleButton(-90 + this.xOff, -82, 80, 12, Align.CENTER, Align.CENTER, this.type, (CycleButton<T> T) -> this.updateTaskMode()).setTooltip(this::getTypeValue);
        this.cycleButton(0 + this.xOff, -82, 80, 12, Align.CENTER, Align.CENTER, this.shape, this.emptyAction());
        this.text(-90 + this.xOff, -49, 55, 12, Align.CENTER, Align.CENTER, this.startX);
        this.cycleButton(-33 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startXType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(-20 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startXRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.text(-1 + this.xOff, -49, 55, 12, Align.CENTER, Align.CENTER, this.startZ);
        this.cycleButton(56 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startZType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(69 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startZRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.text(-90 + this.xOff, -24, 55, 12, Align.CENTER, Align.CENTER, this.endX);
        this.cycleButton(-33 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endXType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(-20 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endXRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.text(-1 + this.xOff, -24, 55, 12, Align.CENTER, Align.CENTER, this.endZ);
        this.cycleButton(56 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endZType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(69 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endZRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.cycleButton(56 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.time, this.emptyAction()).setTooltip(this::getTimeValue);
        this.cycleButton(-90 + this.xOff, 4, 170, 12, Align.CENTER, Align.CENTER, this.dimension, (CycleButton<T> T) -> this.sendToServer(new MemoryPacket.RequestUsed((ResourceKey<Level>)((ResourceKey)T.getValue())))).withSelectScreen().setTooltip(this::getDimensionTooltip);
        this.text(-90 + this.xOff, 28, 80, 12, Align.CENTER, Align.CENTER, this.taskName);
        this.startGen = this.button(-90 + this.xOff, 93, 80, 12, Align.CENTER, Align.CENTER, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.start"), this::startTask).setTooltip(this::getValdiationScan);
        this.cancel = this.button(0 + this.xOff, 93, 80, 12, Align.CENTER, Align.CENTER, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.cancel"), T -> this.m_7379_());
        this.updateTaskMode();
    }

    private void startTask(Button button) {
        IDeletionTask task = this.createTask();
        if (task == null) {
            return;
        }
        NetworkManager.INSTANCE.sendToServer(new CommandPacket.DeletionTask(task));
        this.setScreen(null);
    }

    public void m_7379_() {
        this.setScreen(this.parent);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        IDeletionTask task = this.createTask();
        if (task == null) {
            this.expectedChunks = 0L;
            this.mb = 0L;
            this.updateProgress();
            return;
        }
        if (task instanceof DeletionExcess || task instanceof DeletionTimeOut) {
            long chunks;
            this.expectedChunks = chunks = GenShape.SQUARE.calculateRadius(task.getMaxRadius());
            this.mb = Math.max(0L, this.used - TextUtil.getWorldSize(chunks, this.dimension.getValue()));
            this.updateProgress();
            return;
        }
        this.expectedChunks = task.getTaskSize();
        this.mb = TextUtil.getWorldSize(this.expectedChunks, this.dimension.getValue());
        this.updateProgress();
    }

    private void updateProgress() {
        if (this.used == -1L) {
            return;
        }
        if (this.used == 0L) {
            this.progress.set(0L);
            return;
        }
        if (this.mb < 0L) {
            this.progress.set(Long.MAX_VALUE);
            return;
        }
        this.progress.set((long)((double)this.mb / (double)this.used * 1000000.0));
    }

    @Override
    public void receivedMemory(ResourceKey<Level> dimension, long value, boolean free) {
        if (!free) {
            this.used = value;
            this.updateProgress();
        }
    }

    protected void renderFrame(GuiGraphics graphics) {
        this.drawSimpleRect(graphics, this.centerX - 100, this.centerY - 105, this.centerX + 90, this.centerY + 110, -3750202, false);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.progress.tick(partialTicks);
        this.startGen.f_93623_ = this.updateValidity();
        this.m_280273_(graphics);
        this.renderFrame(graphics);
        this.drawSimpleRect(graphics, this.centerX - 93 + this.xOff, this.centerY - 59, this.centerX + 83 + this.xOff, this.centerY - 9, -3750202, true);
        this.drawSimpleRect(graphics, this.centerX - 93 + this.xOff, this.centerY + 44, this.centerX + 83 + this.xOff, this.centerY + 56, -7631989, true);
        if (this.used == -1L) {
            return;
        }
        double value = Math.max(Math.min((double)this.progress.get() / 1000000.0, 1.0), 0.0);
        graphics.m_280509_(this.centerX - 93 + this.xOff, this.centerY + 44, this.centerX + 83 - (int)(176.0 - 176.0 * value) + this.xOff, this.centerY + 56, -16731648);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawText(graphics, (Component)TextUtil.translate("Deletion Task Creator"), 0.0f, -102.0f, Align.CENTER, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.task_type"), -90 + this.xOff, -91.0f, Align.START, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.shape"), this.xOff, -91.0f, Align.START, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.positioning"), -93 + this.xOff, -68.0f, Align.START, 0x404040);
        if (this.type.getValue() == 2) {
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.from_x"), -90 + this.xOff, -58.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.from_z"), -1 + this.xOff, -58.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.to_x"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.to_z"), -1 + this.xOff, -33.0f, Align.START, 0x404040);
        } else {
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.center_x"), -90 + this.xOff, -58.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.center_z"), -1 + this.xOff, -58.0f, Align.START, 0x404040);
            if (this.type.getValue() == 1) {
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.min_radius"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.max_radius"), -1 + this.xOff, -33.0f, Align.START, 0x404040);
            } else if (this.type.getValue() == 0) {
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.radius"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
            } else {
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.min_radius"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
                if (this.type.getValue() == 4) {
                    this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.max_time"), -1 + this.xOff, -33.0f, Align.START, 0x404040);
                }
            }
        }
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.dimension"), -90 + this.xOff, -5.0f, Align.START, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.task_name"), -90 + this.xOff, 19.0f, Align.START, 0x404040);
        String key = this.used == -1L ? "gui.chunk_pregen.taskgenerator.disk_usage.fetching" : "gui.chunk_pregen.taskgenerator.disk_reduction";
        this.drawText(graphics, (Component)TextUtil.translate(key, TextUtil.findBestMemory(Math.min(this.mb, this.used)), TextUtil.findBestMemory(this.used)), -5 + this.xOff, 46.0f, Align.CENTER, 0x404040);
    }

    private void updateTaskMode() {
        boolean value = this.type.getValue() < 2;
        this.endZ.getOwner().f_93624_ = this.type.getValue() == 1 || this.type.getValue() == 2 || this.type.getValue() == 4;
        this.endZType.getOwner().f_93624_ = this.type.getValue() == 1 || this.type.getValue() == 2;
        this.endZRelation.getOwner().f_93624_ = this.type.getValue() == 2;
        this.endXRelation.getOwner().f_93624_ = this.type.getValue() == 2;
        this.time.getOwner().f_93624_ = this.type.getValue() == 4;
        this.endX.setFilter(this.number(value), value ? "100" : "0");
        this.endZ.setFilter(this.number(value), value ? "200" : "0");
    }

    protected boolean updateValidity() {
        boolean valid = true;
        valid &= !this.taskName.getValue().isEmpty();
        switch (this.type.getValue()) {
            case 0: {
                valid &= this.getValue(this.endX, this.endXType, this.endXRelation, false, true) >= 0;
                break;
            }
            case 1: {
                valid &= this.getValue(this.endX, this.endXType, this.endXRelation, false, true) < this.getValue(this.endZ, this.endZType, this.endZRelation, false, false);
                break;
            }
            case 2: {
                valid &= this.getValue(this.startX, this.startXType, this.startXRelation, true, true) < this.getValue(this.endX, this.endXType, this.endXRelation, true, true) && this.getValue(this.startZ, this.startZType, this.startZRelation, true, false) < this.getValue(this.endZ, this.endZType, this.endZRelation, true, false);
            }
        }
        return valid;
    }

    public int getValue(PregenText.TextState state, CycleButton.CycleState<Boolean> chunks, CycleButton.CycleState<Integer> relative, boolean isPosition, boolean x) {
        int value = this.parseNumber(state.getValue());
        if (!chunks.getValue().booleanValue()) {
            value >>= 4;
        }
        return value + (!isPosition ? 0 : this.getRelativeLocation(relative, x));
    }

    public long getTime(PregenText.TextState state, CycleButton.CycleState<Integer> time) {
        long value = this.parseNumber(state.getValue());
        return value * TIME_MULTIPLIERS[time.getValue()];
    }

    private int getRelativeLocation(CycleButton.CycleState<Integer> relative, boolean x) {
        switch (relative.getValue()) {
            case 1: {
                return x ? this.f_96541_.f_91074_.m_20183_().m_123341_() >> 4 : this.f_96541_.f_91074_.m_20183_().m_123343_() >> 4;
            }
            case 2: {
                return x ? this.f_96541_.f_91073_.m_220360_().m_123341_() >> 4 : this.f_96541_.f_91073_.m_220360_().m_123343_() >> 4;
            }
        }
        return 0;
    }

    private int parseNumber(String value) {
        if (value.isEmpty() || "-".equals(value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public IDeletionTask createTask() {
        switch (this.type.getValue()) {
            case 0: {
                int x = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int z = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int radius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                return this.shape.getValue().createRadiusDeleteTask(this.taskName.getValue(), x, z, radius, this.dimension.getValue());
            }
            case 1: {
                int x = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int z = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int minRadius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                int maxRadius = this.getValue(this.endZ, this.endZType, this.endZRelation, false, false);
                return this.shape.getValue().createExpansionDeleteTask(this.taskName.getValue(), x, z, Math.min(minRadius, maxRadius), Math.max(minRadius, maxRadius), this.dimension.getValue());
            }
            case 2: {
                int minX = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int minZ = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int maxX = this.getValue(this.endX, this.endXType, this.endXRelation, true, true);
                int maxZ = this.getValue(this.endZ, this.endZType, this.endZRelation, true, false);
                return this.shape.getValue().createAreaDeleteTask(this.taskName.getValue(), new ChunkPos(Math.min(minX, maxX), Math.min(minZ, maxZ)), new ChunkPos(Math.max(minX, maxX), Math.max(minZ, maxZ)), this.dimension.getValue());
            }
            case 3: {
                int x = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int z = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int radius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                return new DeletionExcess(this.taskName.getValue(), this.dimension.getValue(), new ChunkPos(x, z), radius);
            }
            case 4: {
                int x = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int z = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int radius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                long time = this.getValue(this.endX, this.endXType, this.endXRelation, false, false);
                return new DeletionTimeOut(this.taskName.getValue(), this.dimension.getValue(), new ChunkPos(x, z), radius, time);
            }
        }
        return null;
    }

    private Component getValdiationScan(PregenButton button) {
        MutableComponent comp = TextUtil.empty();
        if (this.taskName.getValue().isEmpty()) {
            comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.task_name"));
        }
        switch (this.type.getValue()) {
            case 0: {
                int radius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                if (radius > 0) break;
                if (!comp.m_7360_().isEmpty()) {
                    comp.m_130946_("\n");
                }
                comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.radius_to_small"));
                break;
            }
            case 1: {
                int minRadius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                int maxRadius = this.getValue(this.endZ, this.endZType, this.endZRelation, false, false);
                if (minRadius < maxRadius) break;
                if (!comp.m_7360_().isEmpty()) {
                    comp.m_130946_("\n");
                }
                comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.min_bigger_max"));
                break;
            }
            case 2: {
                int minX = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int minZ = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int maxX = this.getValue(this.endX, this.endXType, this.endXRelation, true, true);
                int maxZ = this.getValue(this.endZ, this.endZType, this.endZRelation, true, false);
                if (minX >= maxX) {
                    if (!comp.m_7360_().isEmpty()) {
                        comp.m_130946_("\n");
                    }
                    comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.min_x_bigger_max"));
                }
                if (minZ < maxZ) break;
                if (!comp.m_7360_().isEmpty()) {
                    comp.m_130946_("\n");
                }
                comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.min_z_bigger_max"));
                break;
            }
        }
        return comp.m_7360_().isEmpty() ? null : comp;
    }

    private Component getPositionValue(CycleButton<Boolean> value) {
        return TextUtil.translate(value.getValue() != false ? "gui.chunk_pregen.taskgenerator.tooltip.count_chunks" : "gui.chunk_pregen.taskgenerator.tooltip.count_blocks");
    }

    private Component getRelationValue(CycleButton<Integer> value) {
        return TextUtil.translate(value.getValue() == 0 ? "gui.chunk_pregen.taskgenerator.tooltip.value_literal" : (value.getValue() == 1 ? "gui.chunk_pregen.taskgenerator.tooltip.value_player" : "gui.chunk_pregen.taskgenerator.tooltip.value_spawn"));
    }

    private Component getTimeValue(CycleButton<Integer> value) {
        switch (value.getValue()) {
            case 1: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.time.seconds");
            }
            case 2: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.time.days");
            }
            case 3: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.time.irl_days");
            }
        }
        return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.time.ticks");
    }

    private Component getTypeValue(CycleButton<Integer> value) {
        if (value.getValue() == 3) {
            return TextUtil.literal("Deletes all chunks outside of the Minimum Radius");
        }
        if (value.getValue() == 4) {
            return TextUtil.literal("Deletes all chunks outside of the Minimum Radius that haven't existed longer then the desired time");
        }
        return null;
    }

    private Predicate<String> number(boolean positive) {
        return T -> {
            if (T.isEmpty() || !positive && "-".equals(T)) {
                return true;
            }
            try {
                int value = Integer.parseInt(T);
                return !positive || value >= 0;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    private Component getDimensionTooltip(CycleButton<ResourceKey<Level>> button) {
        MutableComponent base = TextUtil.empty();
        base.m_7220_((Component)TextUtil.translateStyled("gui.chunk_pregen.taskgenerator.tooltip.dimension", ChatFormatting.GOLD)).m_130946_("\n");
        base.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.mod", TextUtil.getModName(button.getValue().m_135782_().m_135827_())).m_130940_(ChatFormatting.GRAY));
        return base;
    }

    private Component getNumberName(boolean value) {
        return TextUtil.literal(value ? "C" : "B");
    }

    private Component getRelationName(int value) {
        return TextUtil.literal(value == 0 ? "L" : (value == 1 ? "P" : "S"));
    }

    private Component getTimeName(int value) {
        return TextUtil.literal(value == 0 ? "T" : (value == 1 ? "S" : (value == 2 ? "D" : "R")));
    }

    private Component getTypeName(int value) {
        switch (value) {
            case 1: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.expansion");
            }
            case 2: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.area");
            }
            case 3: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.trim_excess");
            }
            case 4: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.trim_timed");
            }
        }
        return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.radius");
    }
}

