/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButton;

public class PregenSlider
extends PregenButton {
    SliderState state;

    public PregenSlider(int xPos, int yPos, int width, int height, SliderState state) {
        super(xPos, yPos, width, height, state.getCurrentDisplayText(), null);
        state.owner = this;
        this.state = state;
    }

    protected void onValueChanged() {
        if (this.state.listener != null) {
            this.state.listener.accept(this);
        }
    }

    public void updateMessage() {
        this.m_93666_(this.state.getCurrentDisplayText());
    }

    public SliderState getState() {
        return this.state;
    }

    public int get() {
        return this.state.get();
    }

    public double getProgress() {
        return (double)(this.state.get() - this.state.getMin()) / (double)this.state.getRange();
    }

    protected void setFromMouse(double mouseX) {
        double progress = Math.max(0.0, Math.min(1.0, (mouseX - ((double)this.m_252754_() + 4.0)) / ((double)this.f_93618_ - 8.0)));
        this.state.set((int)((double)this.state.getMin() + (double)this.state.getRange() * progress));
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setFromMouse(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.setFromMouse(mouseX);
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.state.stepSize != 0 && this.f_93623_ && this.f_93624_) {
            this.state.set(this.get() + (int)((double)this.state.stepSize * scroll * (double)(Screen.m_96638_() ? 10 : 1) * (double)(Screen.m_96637_() ? 100 : 1)));
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.state.stepSize != 0 && this.f_93623_ && this.f_93624_ && (keyCode == 263 || keyCode == 262)) {
            this.state.set(this.get() + this.state.stepSize * ((keyCode == 263 ? -1 : 0) + (keyCode == 262 ? 1 : 0)) * (Screen.m_96638_() ? 10 : 1) * (Screen.m_96637_() ? 100 : 1));
            return true;
        }
        return false;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_93617_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.m_274382_() ? 2 : 1) * 20;
        double range = this.getProgress();
        graphics.blitWithBorder(f_93617_, this.m_252754_() + (int)(range * (double)(this.f_93618_ - 8)), this.m_252907_(), 0, 46 + i, 8, this.f_93619_, 200, 20, 2, 3, 2, 2);
    }

    @Override
    protected int getYOffset() {
        return 0;
    }

    public static class SliderState {
        int minValue;
        int maxValue;
        int value;
        int stepSize = 1;
        IntFunction<Component> displayText = T -> TextUtil.literal(BasePregenScreen.NUMBERS.format(T));
        Component prefix = TextUtil.empty();
        Component suffix = TextUtil.empty();
        Consumer<PregenSlider> listener;
        PregenSlider owner;

        public SliderState(int value, int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
        }

        public SliderState(int value, int minValue, int maxValue, IntFunction<Component> displayText) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.displayText = Objects.requireNonNull(displayText);
        }

        public SliderState(int value, int minValue, int maxValue, Component prefix, Component suffix) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.prefix = Objects.requireNonNull(prefix);
            this.suffix = Objects.requireNonNull(suffix);
        }

        public SliderState(int value, int minValue, int maxValue, IntFunction<Component> displayText, Component prefix, Component suffix) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.displayText = Objects.requireNonNull(displayText);
            this.prefix = Objects.requireNonNull(prefix);
            this.suffix = Objects.requireNonNull(suffix);
        }

        public SliderState setListener(Consumer<PregenSlider> listener) {
            this.listener = listener;
            return this;
        }

        public SliderState setStepSize(int value) {
            this.stepSize = value;
            return this;
        }

        public SliderState setMaxValue(int maxValue) {
            if (maxValue < this.minValue) {
                return this;
            }
            this.maxValue = maxValue;
            int oldValue = this.value;
            this.value = Math.min(maxValue, this.value);
            if (this.owner != null) {
                if (oldValue != this.value) {
                    this.owner.onValueChanged();
                }
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState setMinValue(int minValue) {
            if (this.maxValue < minValue) {
                return this;
            }
            this.minValue = minValue;
            int oldValue = this.value;
            this.value = Math.max(minValue, this.value);
            if (this.owner != null) {
                if (oldValue != this.value) {
                    this.owner.onValueChanged();
                }
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState set(int value) {
            int newValue = Math.max(this.minValue, Math.min(this.maxValue, value));
            if (this.value != newValue) {
                this.value = newValue;
                if (this.owner != null) {
                    this.owner.onValueChanged();
                }
            }
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState increaseOnce() {
            return this.set(this.value + 1);
        }

        public SliderState decreaseOnce() {
            return this.set(this.value - 1);
        }

        public SliderState setPrefix(Component prefix) {
            this.prefix = Objects.requireNonNull(prefix);
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState setSuffix(Component suffix) {
            this.suffix = Objects.requireNonNull(suffix);
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public Component getCurrentDisplayText() {
            return TextUtil.empty().m_7220_(this.prefix).m_7220_(this.displayText.apply(this.value)).m_7220_(this.suffix);
        }

        public int getMin() {
            return this.minValue;
        }

        public int getMax() {
            return this.maxValue;
        }

        public int getRange() {
            return this.maxValue - this.minValue;
        }

        public int get() {
            return this.value;
        }

        public PregenSlider getOwner() {
            return this.owner;
        }
    }
}

