/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.PregenButton;

public class PregenCheckBox
extends PregenButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("chunkpregen", "textures/gui/checkbox.png");
    CheckboxState state;

    public PregenCheckBox(int x, int y, int width, int height, Component text, boolean isChecked, Button.OnPress handler) {
        this(x, y, width, height, new CheckboxState(false, isChecked, text, arg_0 -> ((Button.OnPress)handler).m_93750_(arg_0)));
    }

    public PregenCheckBox(int x, int y, int width, int height, CheckboxState state) {
        super(x, y, width, height, state.getLabel(), null);
        this.state = state;
        this.state.setOwner(this);
    }

    @Override
    public void m_5691_() {
        this.state.toggle();
    }

    public boolean isChecked() {
        return this.state.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.state.setChecked(isChecked);
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.blitWithBorder(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_198029_() ? 20 : 0, this.state.isChecked ? 20 : 0, this.f_93618_, this.f_93619_, 20, 20, 1, 1, 1, 1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        BasePregenScreen.drawTextureRegion(graphics, this.m_252754_() + 1, this.m_252907_() + 1, this.m_198029_() ? 21.0f : 1.0f, this.state.isChecked ? 21.0f : 1.0f, this.f_93618_ - 2, this.f_93619_ - 2, 18.0f, 18.0f, 256.0f, 256.0f);
        if (this.state.showLabel) {
            Font font = Minecraft.m_91087_().f_91062_;
            float xPos = this.state.horizontal.align(this.m_252754_(), this.f_93618_ + 2, font.m_92852_((FormattedText)this.m_6035_()));
            Align align = this.state.vertical;
            float f = this.m_252907_();
            float f2 = this.f_93619_ + 2;
            Objects.requireNonNull(font);
            float yPos = align.align(f, f2, 9.0f);
            graphics.m_280430_(font, this.m_6035_(), (int)xPos, (int)yPos, 0xE0E0E0 | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }
    }

    public static class CheckboxState {
        boolean showLabel;
        boolean isChecked;
        Component label = TextUtil.empty();
        PregenCheckBox owner;
        Consumer<PregenCheckBox> listener;
        Align vertical = Align.CENTER;
        Align horizontal = Align.END;

        public CheckboxState() {
        }

        public CheckboxState(boolean isChecked) {
            this.isChecked = isChecked;
        }

        public CheckboxState(boolean showLabel, boolean isChecked) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
        }

        public CheckboxState(boolean showLabel, boolean isChecked, Component label) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
            this.label = label;
        }

        public CheckboxState(boolean showLabel, boolean isChecked, Component label, Consumer<PregenCheckBox> listener) {
            this.showLabel = showLabel;
            this.isChecked = isChecked;
            this.label = label;
            this.listener = listener;
        }

        public CheckboxState withLabel(boolean value) {
            this.showLabel = value;
            return this;
        }

        public CheckboxState setChecked(boolean checked) {
            this.isChecked = checked;
            return this;
        }

        public CheckboxState withListener(Consumer<PregenCheckBox> listener) {
            this.listener = listener;
            return this;
        }

        public CheckboxState withStateListener(Consumer<Boolean> listener) {
            this.listener = T -> listener.accept(T.isChecked());
            return this;
        }

        public CheckboxState vAlign(Align align) {
            this.vertical = align;
            return this;
        }

        public CheckboxState hAlign(Align align) {
            this.horizontal = align;
            return this;
        }

        public CheckboxState setLabel(Component label) {
            this.label = label;
            if (this.owner != null) {
                this.owner.m_93666_(label);
            }
            return this;
        }

        void setOwner(PregenCheckBox owner) {
            this.owner = owner;
        }

        public PregenCheckBox getOwner() {
            return this.owner;
        }

        public Component getLabel() {
            return this.label;
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public boolean showLabel() {
            return this.showLabel;
        }

        public void toggle() {
            boolean bl = this.isChecked = !this.isChecked;
            if (this.listener != null && this.owner != null) {
                this.listener.accept(this.owner);
            }
        }
    }
}

