/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.comp.CycleButton;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenCheckBox;
import pregenerator.base.impl.comp.PregenList;
import pregenerator.base.impl.comp.PregenSlider;
import pregenerator.base.impl.comp.PregenText;
import pregenerator.base.impl.comp.PregenTreeList;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public abstract class BasePregenScreen
extends Screen {
    public static final DecimalFormat NUMBERS = TextUtil.NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS = TextUtil.FLOATING_NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS_EXTENDED = TextUtil.FLOATING_NUMBERS_EXTENDED;
    private static final ScissorsStack STACK = new ScissorsStack();
    protected int centerX;
    protected int centerY;
    protected int tick;
    int lastMouseX = 0;
    int lastMouseY = 0;
    long lastCheck = 0L;
    int lastDrawnToolTipAmount = 0;
    boolean renderTooltip = false;

    protected BasePregenScreen(Component titleIn) {
        super(titleIn);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.m_169413_();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.tick;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderWidgets(graphics, mouseX, mouseY, partialTicks);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable widget : this.f_169369_) {
            widget.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void collectTooltips(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Consumer<Component> tooltips) {
    }

    public void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ObjectArrayList tooltips = new ObjectArrayList();
        if (mouseX != Integer.MAX_VALUE && mouseY != Integer.MAX_VALUE) {
            for (GuiEventListener listener : this.m_6702_()) {
                if (!(listener instanceof ITooltipProvider)) continue;
                ((ITooltipProvider)listener).provideTooltips(arg_0 -> this.lambda$renderTooltips$0((List)tooltips, mouseX, arg_0));
            }
            this.collectTooltips(graphics, mouseX, mouseY, partialTicks, arg_0 -> this.lambda$renderTooltips$1((List)tooltips, mouseX, arg_0));
        }
        if (!this.renderTooltip && (this.lastMouseX != mouseX || this.lastMouseY != mouseY) || tooltips.isEmpty()) {
            this.lastCheck = System.currentTimeMillis();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastDrawnToolTipAmount = 0;
            if (tooltips.isEmpty()) {
                this.renderTooltip = false;
            }
            return;
        }
        if (System.currentTimeMillis() - this.lastCheck < (long)PregenConfig.INSTANCE.tooltipDelay.get()) {
            this.lastDrawnToolTipAmount = 0;
            return;
        }
        this.renderTooltip = true;
        this.lastDrawnToolTipAmount = 0;
        graphics.m_280245_(this.f_96547_, (List)tooltips, mouseX, mouseY);
        this.lastDrawnToolTipAmount = tooltips.size();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public PregenButton button(int x, int y, int width, int height, Component text, Button.OnPress press) {
        return (PregenButton)this.m_142416_((GuiEventListener)new PregenButton(x, y, width, height, text, press));
    }

    public PregenButton button(int x, int y, int width, int height, Align horizontal, Align vertical, Component text, Button.OnPress press) {
        return (PregenButton)this.m_142416_((GuiEventListener)new PregenButton(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, text, press));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, List<T> values, T initial, Function<T, Component> displayFunction, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.m_142416_((GuiEventListener)new CycleButton<T>(x, y, width, height, values, initial, displayFunction, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, Align horizontal, Align vertical, List<T> values, T initial, Function<T, Component> displayFunction, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.m_142416_((GuiEventListener)new CycleButton<T>(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, values, initial, displayFunction, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, CycleButton.CycleState<T> state, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.m_142416_((GuiEventListener)new CycleButton<T>(x, y, width, height, state, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, Align horizontal, Align vertical, CycleButton.CycleState<T> state, Consumer<CycleButton<T>> result) {
        return (CycleButton)this.m_142416_((GuiEventListener)new CycleButton<T>(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state, result));
    }

    public <T extends PregenTreeList.TreeEntry<T>> PregenTreeList<T> tree(int width, int height, int startY, int endY, PregenTreeList.TreeState<T> state) {
        return (PregenTreeList)this.m_142416_((GuiEventListener)new PregenTreeList<T>(this, width, height, startY, endY, state));
    }

    public <T extends PregenTreeList.TreeEntry<T>> PregenTreeList<T> tree(PregenTreeList.TreeState<T> state) {
        return (PregenTreeList)this.m_142416_((GuiEventListener)new PregenTreeList<T>(this, state));
    }

    public <T extends PregenList.ListEntry<T>> PregenList<T> list(int width, int height, int startY, int endY, PregenList.ListState<T> state) {
        return (PregenList)this.m_142416_((GuiEventListener)new PregenList<T>(this, width, height, startY, endY, state));
    }

    public <T extends PregenList.ListEntry<T>> PregenList<T> list(PregenList.ListState<T> state) {
        return (PregenList)this.m_142416_((GuiEventListener)new PregenList<T>(this, state));
    }

    public PregenCheckBox checkbox(int x, int y, int width, int height, PregenCheckBox.CheckboxState state) {
        return (PregenCheckBox)this.m_142416_((GuiEventListener)new PregenCheckBox(x, y, width, height, state));
    }

    public PregenCheckBox checkbox(int x, int y, int width, int height, Align horizontal, Align vertical, PregenCheckBox.CheckboxState state) {
        return (PregenCheckBox)this.m_142416_((GuiEventListener)new PregenCheckBox(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public PregenText text(int x, int y, int width, int height, PregenText.TextState state) {
        return (PregenText)this.m_142416_((GuiEventListener)new PregenText(this.f_96547_, x, y, width, height, state));
    }

    public PregenText text(int x, int y, int width, int height, Align horizontal, Align vertical, PregenText.TextState state) {
        return (PregenText)this.m_142416_((GuiEventListener)new PregenText(this.f_96547_, this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public PregenSlider slider(int x, int y, int width, int height, PregenSlider.SliderState state) {
        return (PregenSlider)this.m_142416_((GuiEventListener)new PregenSlider(x, y, width, height, state));
    }

    public PregenSlider slider(int x, int y, int width, int height, Align horizontal, Align vertical, PregenSlider.SliderState state) {
        return (PregenSlider)this.m_142416_((GuiEventListener)new PregenSlider(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public Screen createChoice(Component mainline, Component description, BooleanConsumer result) {
        return new ConfirmScreen(result, mainline, description);
    }

    public Screen createChoice(Component mainline, Component description, Component yesButton, Component noButton, BooleanConsumer result) {
        return new ConfirmScreen(result, mainline, description, yesButton, noButton);
    }

    protected Button.OnPress emptyClick() {
        return T -> {};
    }

    protected <T> Consumer<T> emptyAction() {
        return T -> {};
    }

    protected List<ResourceKey<Level>> dimensions() {
        return new ObjectArrayList((Collection)Minecraft.m_91087_().f_91074_.f_108617_.m_105151_());
    }

    protected ResourceKey<Level> defaultDimension() {
        return Minecraft.m_91087_().f_91073_.m_46472_();
    }

    protected void setScreen(Screen screen) {
        Minecraft.m_91087_().m_91152_(screen);
    }

    protected int getAlignedX(Align align) {
        switch (align) {
            case CENTER: {
                return this.centerX;
            }
            case END: {
                return this.f_96543_;
            }
            case START: {
                return 0;
            }
        }
        return 0;
    }

    protected int getAlignedY(Align align) {
        switch (align) {
            case CENTER: {
                return this.centerY;
            }
            case END: {
                return this.f_96544_;
            }
            case START: {
                return 0;
            }
        }
        return 0;
    }

    public void drawText(GuiGraphics graphics, Component text, float x, float y, Align align, int color) {
        float offset = align.align(this.f_96547_.m_92852_((FormattedText)text));
        this.f_96547_.m_272077_(text, (float)this.centerX + x + offset, (float)this.centerY + y, color, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.m_280262_();
    }

    public void drawSplitText(GuiGraphics graphics, Component text, float x, float y, Align align, int color, int maxLength) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        MultiBufferSource.BufferSource buffer = graphics.m_280091_();
        for (FormattedCharSequence line : this.f_96547_.m_92923_((FormattedText)text, maxLength)) {
            float offset = align.align(this.f_96547_.m_92724_(line));
            this.f_96547_.m_272191_(line, (float)this.centerX + x + offset, (float)this.centerY + y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            Objects.requireNonNull(this.f_96547_);
            y += 9.0f;
        }
        graphics.m_280262_();
    }

    public void drawUnalignedText(GuiGraphics graphics, Component text, float x, float y, Align align, int color) {
        float offset = align.align(this.f_96547_.m_92852_((FormattedText)text));
        this.f_96547_.m_272077_(text, x + offset, y, color, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.m_280262_();
    }

    public void drawScrollText(GuiGraphics graphics, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        BasePregenScreen.drawScrollingString(graphics, this.f_96547_, text, x + (float)this.centerX, y + (float)this.centerY, width, height, align, color, seed);
    }

    public void drawUnalignedScrollText(GuiGraphics graphics, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        BasePregenScreen.drawScrollingString(graphics, this.f_96547_, text, x, y, width, height, align, color, seed);
    }

    public static void drawScrollingString(GuiGraphics graphics, Font font, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        int textWidth = font.m_92852_((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.m_137550_() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            BasePregenScreen.pushScissors((int)x, (int)y, (int)width, (int)height);
            float f = x - align.align(width) + align.align(textWidth) + (float)Mth.m_14139_((double)offset, (double)0.0, (double)diff);
            float f2 = y + height / 2.0f;
            Objects.requireNonNull(font);
            font.m_272077_(text, f, f2 - (float)(9 / 3), color, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            graphics.m_280262_();
            BasePregenScreen.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        float f = x - align.align(width) + offset;
        float f3 = y + height / 2.0f;
        Objects.requireNonNull(font);
        font.m_272077_(text, f, f3 - (float)(9 / 3), color, false, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.m_280262_();
    }

    public static void drawScrollingShadowString(GuiGraphics graphics, Font font, Component text, float x, float y, float width, float height, Align align, int color, int seed) {
        int textWidth = font.m_92852_((FormattedText)text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(Util.m_137550_() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            BasePregenScreen.pushScissors((int)x, (int)y, (int)width, (int)height);
            float f = x - align.align(width) + align.align(textWidth) + (float)Mth.m_14139_((double)offset, (double)0.0, (double)diff);
            float f2 = y + height / 2.0f;
            Objects.requireNonNull(font);
            font.m_272077_(text, f, f2 - (float)(9 / 3), color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            graphics.m_280262_();
            BasePregenScreen.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        float f = x - align.align(width) + offset;
        float f3 = y + height / 2.0f;
        Objects.requireNonNull(font);
        font.m_272077_(text, f, f3 - (float)(9 / 3), color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.m_280262_();
    }

    public static void pushScissors(float x, float y, float width, float height) {
        BasePregenScreen.pushScissors(new Rect(x, y, width, height));
    }

    public static void pushScissors(Rect rect) {
        STACK.push(rect);
        BasePregenScreen.applyScissors(rect);
    }

    public static void popScissors() {
        BasePregenScreen.applyScissors(STACK.pop());
    }

    private static void applyScissors(Rect rect) {
        if (rect == null) {
            RenderSystem.disableScissor();
            return;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        float bottom = rect.maxY;
        double scaledHeight = (double)window.m_85442_() / (double)window.m_85446_();
        double scaledWidth = (double)window.m_85441_() / (double)window.m_85445_();
        RenderSystem.enableScissor((int)((int)((double)rect.getX() * scaledWidth)), (int)((int)((double)window.m_85442_() - (double)bottom * scaledHeight)), (int)((int)((double)rect.getWidth() * scaledWidth)), (int)((int)((double)rect.getHeigth() * scaledHeight)));
    }

    public static void renderEntityInGui(Entity entity, GuiGraphics graphics, int xPos, int yPos, float scale, float rotation) {
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(xPos + 8), (float)(yPos + 26), 50.0f);
        matrixStack.m_85841_(-scale, scale, scale);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        if (rotation != 0.0f) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        }
        Lighting.m_84930_();
        if (!(entity instanceof Player)) {
            entity.m_146926_(0.0f);
            entity.f_19860_ = 0.0f;
            entity.m_146922_(0.0f);
            entity.f_19859_ = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_20884_ = 0.0f;
                living.f_20883_ = 0.0f;
                living.f_20885_ = 0.0f;
                living.f_20886_ = 0.0f;
            }
        }
        matrixStack.m_252880_(0.0f, (entity.m_20202_() == null ? 0.0f : (float)entity.m_6049_()) + (entity instanceof HangingEntity ? 0.5f : 0.0f), 0.0f);
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        boolean prev = dispatcher.m_114377_();
        try {
            float value = 1.0f;
            float yOff = 0.5f;
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                value = -((float)item.m_32059_() + item.f_31983_ * 10.0f) - 25.0f;
                yOff = 0.25f;
            }
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            dispatcher.m_114468_(false);
            dispatcher.m_114473_(false);
            dispatcher.m_114384_(entity, 0.0, (double)yOff, 0.0, 0.0f, value, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
            buffer.m_109911_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dispatcher.m_114468_(true);
        dispatcher.m_114473_(prev);
        matrixStack.m_85849_();
    }

    public void renderTextureWithOffset(GuiGraphics graphics, float x, float y, float width, float height) {
        this.renderTexture(graphics, x + (float)this.centerX, y + (float)this.centerY, width, height);
    }

    public void renderTexture(GuiGraphics graphics, float x, float y, float width, float height, TextureAtlasSprite texture, BufferBuilder builder) {
        if (texture == null) {
            return;
        }
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        builder.m_252986_(matrix, x, y + height, 0.0f).m_7421_(texture.m_118409_(), texture.m_118412_()).m_5752_();
        builder.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(texture.m_118410_(), texture.m_118412_()).m_5752_();
        builder.m_252986_(matrix, x + width, y, 0.0f).m_7421_(texture.m_118410_(), texture.m_118411_()).m_5752_();
        builder.m_252986_(matrix, x, y, 0.0f).m_7421_(texture.m_118409_(), texture.m_118411_()).m_5752_();
    }

    public static void drawTextureRegion(GuiGraphics graphics, float x, float y, float texX, float texY, float width, float height, float texWidth, float texHeight, float textureWidth, float textureHeight) {
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        float maxX = x + width;
        float maxY = y + height;
        float t_minX = texX / textureWidth;
        float t_minY = texY / textureHeight;
        float t_maxX = (texX + texWidth) / textureWidth;
        float t_maxY = (texY + texHeight) / textureHeight;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, maxY, 0.0f).m_7421_(t_minX, t_maxY).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, maxY, 0.0f).m_7421_(t_maxX, t_maxY).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, y, 0.0f).m_7421_(t_maxX, t_minY).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(t_minX, t_minY).m_5752_();
        tessellator.m_85914_();
    }

    public void renderTexture(GuiGraphics graphics, float x, float y, float width, float height) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x, y + height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + width, y + height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x + width, y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix, x, y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
    }

    public static void drawFrame(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        BasePregenScreen.drawQuadArea(graphics, minX, minY, maxX, minY + 1.0f, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(graphics, minX, maxY, maxX, maxY + 1.0f, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(graphics, minX, minY, minX + 1.0f, maxY, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(graphics, maxX, minY, maxX + 1.0f, maxY, bufferbuilder, color);
        GlStateManager._enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tessellator.m_85914_();
        GlStateManager._disableBlend();
    }

    public void drawSimpleRect(GuiGraphics graphics, int minX, int minY, int maxX, int maxY, int color, boolean drop) {
        if (drop) {
            graphics.m_280509_(minX - 1, minY - 1, maxX, maxY, -13158601);
            graphics.m_280509_(minX, minY, maxX + 1, maxY + 1, -1);
        } else {
            graphics.m_280509_(minX, minY, maxX + 1, maxY + 1, -13158601);
            graphics.m_280509_(minX - 1, minY - 1, maxX, maxY, -1);
        }
        graphics.m_280509_(minX, minY, maxX, maxY, color);
    }

    public void drawRectangle(GuiGraphics graphics, int xSize, int ySize, int xOffset, int yOffset, int color, boolean drop) {
        int minX = this.centerX - xSize + xOffset;
        int minY = this.centerY - ySize + yOffset;
        int maxX = this.centerX + xSize + xOffset;
        int maxY = this.centerY + ySize + yOffset;
        if (drop) {
            graphics.m_280509_(minX - 1, minY - 1, maxX, maxY, -13158601);
            graphics.m_280509_(minX, minY, maxX + 1, maxY + 1, -1);
        } else {
            graphics.m_280509_(minX, minY, maxX + 1, maxY + 1, -13158601);
            graphics.m_280509_(minX - 1, minY - 1, maxX, maxY, -1);
        }
        graphics.m_280509_(minX, minY, maxX, maxY, color);
    }

    public boolean isInsideBox(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= this.centerX + minX && mouseX < this.centerX + maxX && mouseY >= this.centerY + minY && mouseY <= this.centerY + maxY;
    }

    public void drawColorRegion(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        GlStateManager._enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_252986_(matrix, minX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, maxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, maxX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(matrix, minX, minY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        tessellator.m_85914_();
        GlStateManager._disableBlend();
    }

    public static void drawQuadArea(GuiGraphics graphics, float left, float top, float right, float bottom, BufferBuilder builder, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        Matrix4f stack = graphics.m_280168_().m_85850_().m_252922_();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        builder.m_252986_(stack, left, bottom, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        builder.m_252986_(stack, right, bottom, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        builder.m_252986_(stack, right, top, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        builder.m_252986_(stack, left, top, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
    }

    public void sendToServer(IPregenPacket packet) {
        NetworkManager.INSTANCE.sendToServer(packet);
    }

    public static String convertText(Component component) {
        StringConsumer consumer = new StringConsumer();
        component.m_7532_().m_13731_((FormattedCharSink)consumer);
        return consumer.getBuilder().toString();
    }

    private /* synthetic */ void lambda$renderTooltips$1(List tooltips, int mouseX, Component T) {
        tooltips.addAll(this.f_96547_.m_92923_((FormattedText)T, Math.max(mouseX, this.f_96543_ - mouseX) - 20));
    }

    private /* synthetic */ void lambda$renderTooltips$0(List tooltips, int mouseX, Component T) {
        tooltips.addAll(this.f_96547_.m_92923_((FormattedText)T, Math.max(mouseX, this.f_96543_ - mouseX) - 20));
    }

    public static interface ITooltipProvider {
        public void provideTooltips(Consumer<Component> var1);
    }

    public static class Rect {
        float minX;
        float minY;
        float maxX;
        float maxY;

        public Rect(float x, float y, float width, float heigth) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + width;
            this.maxY = y + heigth;
        }

        public void limit(Rect rect) {
            this.minX = Math.max(0.0f, Math.max(rect.minX, this.minX));
            this.minY = Math.max(0.0f, Math.max(rect.minY, this.minY));
            this.maxX = Math.max(this.minX, Math.min(rect.maxX, this.maxX));
            this.maxY = Math.max(this.minY, Math.min(rect.maxY, this.maxY));
        }

        public float getX() {
            return this.minX;
        }

        public float getY() {
            return this.minY;
        }

        public float getWidth() {
            return this.maxX - this.minX;
        }

        public float getHeigth() {
            return this.maxY - this.minY;
        }
    }

    public static class ScissorsStack {
        Deque<Rect> stack = new ArrayDeque<Rect>();

        public void push(Rect owner) {
            if (this.stack.isEmpty()) {
                this.stack.push(owner);
                return;
            }
            owner.limit(this.stack.peek());
            this.stack.push(owner);
        }

        public Rect pop() {
            this.stack.pop();
            return this.stack.peek();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StringConsumer
    implements FormattedCharSink {
        StringBuilder builder = new StringBuilder();
        ChatFormatting formatting = ChatFormatting.RESET;

        public boolean m_6411_(int index, Style style, int character) {
            ChatFormatting format = this.getFormat(style);
            if (format != this.formatting) {
                this.formatting = format;
                this.builder.append(format.toString());
            }
            this.builder.append((char)character);
            return true;
        }

        protected ChatFormatting getFormat(Style style) {
            ChatFormatting format = style.m_131135_() == null ? null : ChatFormatting.m_126657_((String)style.m_131135_().m_131274_());
            return format == null ? ChatFormatting.RESET : format;
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }
    }
}

