/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.PregenConfig;
import pregenerator.base.mixins.common.server.DedicatedServerMixin;
import pregenerator.base.mixins.common.server.ServerPropertiesMixin;
import pregenerator.client.ClientHandler;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.commands.PregenCommand;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.DimensionManager;
import pregenerator.common.manager.SeedManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.structures.StructureManager;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.utils.config.config.ConfigHandler;
import pregenerator.common.utils.config.config.FileSystemWatcher;
import pregenerator.common.utils.config.impl.PerWorldProxy;
import pregenerator.common.utils.config.impl.internal.ConfigLogger;
import pregenerator.common.utils.config.impl.internal.EventHandler;
import pregenerator.common.utils.config.internal.PermissionRule;
import pregenerator.common.utils.misc.PregenAction;
import pregenerator.common.utils.plugins.PluginLoader;

@Mod(value="chunkpregen")
public class ChunkPregenerator {
    public static ChunkPregenerator INSTANCE;
    public static Logger LOGGER;
    public static final ExecutorService CHUNK_PROCESS_QUEUE;
    public static final String DOCKER_WARNING = "It was detected that the JVM can only see a single Core on this Server. This can have serious Performance implications.\nIf you are running this server in a Docker Container please make sure you enable multithreading in it.\nWhich you can by setting the \"--cpuset-cpus=0,1,2\" argument in your Docker Container. Each Number defines which core specific core should be used, though \"--cpuset-cpus=0-3\" can be used for ranges.\nMore info can be found here: https://docs.docker.com/config/containers/resource_constraints/#configure-the-default-cfs-scheduler";
    public static final FileSystemWatcher FILE_WATCHER;
    public static final PluginLoader PLUGINS;

    public ChunkPregenerator() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        PregenConfig.INSTANCE.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::load);
        MinecraftForge.EVENT_BUS.addListener(this::unload);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)StructureManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ClientHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandLoad);
        MinecraftForge.EVENT_BUS.addListener(DimensionManager.INSTANCE::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(SeedManager.INSTANCE::onServerStopping);
        ITask.init();
        IDeletionTask.init();
        IProcessorInfo.init();
        NetworkManager.INSTANCE.init();
        ServerTracker.INSTANCE.init();
        if (FMLEnvironment.dist.isClient()) {
            ClientHandler.INSTANCE.addFunctions(bus);
            bus.addListener(this::onClientLoad);
        }
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    public static List<PregenAction> getValidActions(Player player) {
        if (player.m_20310_(4)) {
            return ObjectArrayList.wrap((Object[])PregenAction.values());
        }
        PermissionRule rule = PregenConfig.INSTANCE.permissionRules.get(player.m_20148_());
        return rule == null ? ObjectLists.emptyList() : new ObjectArrayList(rule.getActions());
    }

    public static boolean canDoAction(Player player, PregenAction action) {
        if (player.m_20310_(4)) {
            return true;
        }
        PermissionRule rule = PregenConfig.INSTANCE.permissionRules.get(player.m_20148_());
        return rule != null && rule.hasAction(action);
    }

    @SubscribeEvent
    public void onLoaded(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.COMMAND_ARGUMENT_TYPES) && (FMLEnvironment.dist.isClient() || PregenConfig.INSTANCE.advancedArguments.get())) {
            event.getForgeRegistry().register("pregen_coord", (Object)ArgumentTypeInfos.registerByClass(CenterArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(CenterArgument::center)));
            event.getForgeRegistry().register("pregen_radius", (Object)ArgumentTypeInfos.registerByClass(RadiusArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(RadiusArgument::integer)));
        }
    }

    @SubscribeEvent
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ServerManager.INSTANCE.init();
    }

    public void onServerStart(ServerStartingEvent event) {
        DedicatedServerSettings provider;
        if (!PregenConfig.INSTANCE.disableWatchDogOverride.get() && event.getServer().m_6982_() && event.getServer() instanceof DedicatedServer && (provider = ((DedicatedServerMixin)event.getServer()).getSettingsProvider()) != null && provider.m_139777_().f_139712_ < 600000L) {
            provider.m_139778_(T -> {
                Properties props = Settings.m_139839_((Path)Paths.get("server.properties", new String[0]));
                props.put("max-tick-time", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
                return new DedicatedServerProperties(props);
            });
            LOGGER.info("Upgraded Server Watchdog time from 1 Minute to 10 Minutes to ensure Heavy ModPacks do not crash due to lag");
        }
        if (event.getServer() instanceof DedicatedServer && Runtime.getRuntime().availableProcessors() <= 1 && PregenConfig.INSTANCE.showDockerWarning.get()) {
            LOGGER.error(DOCKER_WARNING);
        }
        if (PregenConfig.INSTANCE.disableDiskProtection.get()) {
            return;
        }
        if (event.getServer() instanceof DedicatedServer) {
            ((ServerPropertiesMixin)((DedicatedServerMixin)event.getServer()).getSettingsProvider().m_139777_()).setSyncChunkWrites(false);
        } else if (event.getServer() instanceof IntegratedServer) {
            this.fixClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fixClient() {
        Minecraft.m_91087_().f_91066_.f_92076_ = false;
    }

    public void onCommandLoad(RegisterCommandsEvent event) {
        PregenCommand.registerCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), PregenConfig.INSTANCE.advancedArguments.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientLoad(FMLClientSetupEvent event) {
        EventHandler.INSTANCE.onConfigsLoaded();
    }

    public void load(ServerAboutToStartEvent event) {
        for (ConfigHandler handler : FILE_WATCHER.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    public void unload(ServerStoppingEvent event) {
        for (ConfigHandler handler : FILE_WATCHER.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.unload();
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)"Chunk Pregenerator");
        CHUNK_PROCESS_QUEUE = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        FILE_WATCHER = new FileSystemWatcher(new ConfigLogger(LOGGER), FMLPaths.CONFIGDIR.get(), EventHandler.INSTANCE);
        PLUGINS = new PluginLoader();
    }
}

