/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.resource;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import snownee.kiwi.Kiwi;
import snownee.kiwi.util.Util;
import snownee.kiwi.util.codec.JavaOps;
import snownee.kiwi.util.resource.AlternativesFileToIdConverter;

public class OneTimeLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public static <T> Map<ResourceLocation, T> load(ResourceManager resourceManager, String directory, Codec<T> codec) {
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson(directory);
        HashMap results = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, Resource> entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            DataResult<T> result = OneTimeLoader.parseFile(entry.getKey(), entry.getValue(), codec);
            if (result.error().isPresent()) {
                Kiwi.LOGGER.error("Failed to parse " + entry.getKey() + ": " + result.error().get());
                continue;
            }
            ResourceLocation id = fileToIdConverter.fileToId(entry.getKey());
            results.put(id, result.result().orElseThrow());
        }
        return results;
    }

    public static <T> T loadFile(ResourceManager resourceManager, String directory, ResourceLocation id, Codec<T> codec) {
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson(directory);
        ResourceLocation file = fileToIdConverter.idToFile(id);
        Optional resource = resourceManager.m_213713_(file);
        if (resource.isEmpty()) {
            return null;
        }
        DataResult<T> result = OneTimeLoader.parseFile(file, (Resource)resource.get(), codec);
        if (result.error().isPresent()) {
            Kiwi.LOGGER.error("Failed to parse " + file + ": " + result.error().get());
            return null;
        }
        return result.result().orElseThrow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> DataResult<T> parseFile(ResourceLocation file, Resource resource, Codec<T> codec) {
        String ext = file.m_135815_().substring(file.m_135815_().length() - 5);
        try (BufferedReader reader = resource.m_215508_();){
            DataResult result;
            if (ext.equals(".json")) {
                result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class)));
            } else {
                if (!ext.equals(".yaml")) {
                    DataResult dataResult2 = DataResult.error(() -> "Unknown extension: " + ext);
                    return dataResult2;
                }
                result = codec.parse((DynamicOps)JavaOps.INSTANCE, Util.loadYaml(reader, Object.class));
            }
            DataResult dataResult = result;
            return dataResult;
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to load " + file + ": " + e);
        }
    }
}

