/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record HorizontalShape(VoxelShape[] shapes) implements ShapeGenerator
{
    public static ShapeGenerator create(ShapeGenerator northGenerator) {
        VoxelShape north = ShapeGenerator.Unit.unboxOrThrow(northGenerator);
        if (VoxelUtil.isIsotropicHorizontally(north)) {
            return northGenerator;
        }
        VoxelShape[] shapes = new VoxelShape[4];
        shapes[Direction.NORTH.m_122416_()] = north;
        return new HorizontalShape(shapes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VoxelShape getShape(BlockState blockState, CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        int index = direction.m_122416_();
        VoxelShape shape = this.shapes[index];
        if (shape != null) return shape;
        VoxelShape[] voxelShapeArray = this.shapes;
        synchronized (this.shapes) {
            shape = this.shapes[index];
            if (shape != null) return shape;
            this.shapes[index] = shape = VoxelUtil.rotateHorizontal(this.shapes[Direction.NORTH.m_122416_()], direction);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return shape;
        }
    }

    public record Unbaked(UnbakedShape wrapped) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("north").forGetter(Unbaked::wrapped)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return HorizontalShape.create(this.wrapped.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.wrapped);
        }
    }
}

