/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ChoicesShape;
import snownee.kiwi.customization.shape.HorizontalShape;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;

public class FrontAndTopShape {
    public static ShapeGenerator create(ShapeGenerator floor, ShapeGenerator ceiling, ShapeGenerator wall) {
        return ChoicesShape.chooseOneProperty(BlockStateProperties.f_61376_, Map.of(AttachFace.FLOOR, HorizontalShape.create(floor), AttachFace.CEILING, HorizontalShape.create(ceiling), AttachFace.WALL, HorizontalShape.create(wall)));
    }

    public record Unbaked(UnbakedShape floor, UnbakedShape ceiling, UnbakedShape wall) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("floor").forGetter(Unbaked::floor), (App)parentCodec.fieldOf("ceiling").forGetter(Unbaked::ceiling), (App)parentCodec.fieldOf("wall").forGetter(Unbaked::wall)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return FrontAndTopShape.create(this.floor.bake(context), this.ceiling.bake(context), this.wall.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.floor, this.ceiling, this.wall);
        }
    }
}

