/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket(value="convert_item", dir=KiwiPacket.Direction.PLAY_TO_SERVER)
public class CConvertItemPacket
extends PacketHandler {
    public static final int MAX_STEPS = 4;
    public static CConvertItemPacket I;

    public static void send(boolean inContainer, int slot, Entry entry, Item from, boolean convertOne) {
        I.sendToServer(buf -> {
            buf.writeBoolean(inContainer);
            buf.writeBoolean(convertOne);
            buf.m_130130_(slot);
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)from);
            buf.m_130130_(entry.steps().size());
            for (Pair<KHolder<BlockFamily>, Item> step : entry.steps()) {
                buf.m_130085_(((KHolder)step.getFirst()).key());
                buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)((Item)step.getSecond()));
            }
        });
    }

    @Override
    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> function, FriendlyByteBuf buf, @Nullable ServerPlayer player) {
        boolean inContainer = buf.readBoolean();
        boolean convertOne = buf.readBoolean();
        int slotIndex = buf.m_130242_();
        Item from = (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_);
        if (from == null) {
            return null;
        }
        int size = buf.m_130242_();
        ArrayList steps = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation familyId = buf.m_130281_();
            Item item = (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            if (item == null) {
                return null;
            }
            steps.add(Pair.of((Object)familyId, (Object)item));
        }
        if (steps.isEmpty() || steps.size() > 4) {
            return null;
        }
        Item to = (Item)((Pair)steps.get(steps.size() - 1)).getSecond();
        if (from == to) {
            return null;
        }
        return function.apply(() -> {
            ItemStack newItem;
            ItemStack sourceItem;
            Objects.requireNonNull(player);
            Item item = from;
            int index = 0;
            float ratio = 1.0f;
            for (Pair step : steps) {
                BlockFamily family = BlockFamilies.get((ResourceLocation)step.getFirst());
                if (!(family != null && family.switchAttrs().enabled() && family.contains(item) && family.contains((Item)step.getSecond()))) {
                    return;
                }
                if (!family.switchAttrs().cascading() && index == steps.size() - 1) {
                    return;
                }
                if (!player.m_7500_()) {
                    ratio *= BlockFamilies.getConvertRatio(item) / BlockFamilies.getConvertRatio((Item)step.getSecond());
                }
                item = (Item)step.getSecond();
                ++index;
            }
            Slot slot = null;
            Inventory playerInventory = player.m_150109_();
            try {
                if (slotIndex == -500) {
                    if (!player.m_7500_()) return;
                    sourceItem = from.m_7968_();
                } else if (inContainer) {
                    slot = (Slot)player.f_36096_.f_38839_.get(slotIndex);
                    if (!slot.m_150651_((Player)player)) {
                        return;
                    }
                    sourceItem = slot.m_7993_();
                } else {
                    sourceItem = playerInventory.m_8020_(slotIndex);
                }
            }
            catch (Exception e) {
                return;
            }
            if (!sourceItem.m_150930_(from)) {
                return;
            }
            boolean skipSettingSlot = false;
            int inventorySwap = Integer.MIN_VALUE;
            if (ratio >= 1.0f) {
                newItem = to.m_7968_();
            } else {
                if (convertOne) {
                    return;
                }
                for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                    ItemStack stack = playerInventory.m_8020_(i);
                    if (!stack.m_150930_(to)) continue;
                    inventorySwap = i;
                    break;
                }
                if (inventorySwap == Integer.MIN_VALUE) {
                    return;
                }
                newItem = playerInventory.m_8020_(inventorySwap);
            }
            newItem.m_41754_(5);
            int ratioInt = Mth.m_14143_((float)ratio);
            if (convertOne) {
                if (!player.m_7500_()) {
                    sourceItem.m_41774_(1);
                    newItem.m_41764_(ratioInt);
                }
                if (!sourceItem.m_41619_()) {
                    this.addToPlayer(player, newItem, !inContainer);
                    skipSettingSlot = true;
                }
            } else if (inventorySwap == Integer.MIN_VALUE) {
                int maxSize = newItem.m_41741_();
                int count = Math.min(sourceItem.m_41613_(), maxSize / ratioInt);
                newItem.m_41764_(count * ratioInt);
                if (!player.m_7500_()) {
                    sourceItem.m_41774_(count);
                }
            }
            if (slotIndex != -500 && !skipSettingSlot) {
                try {
                    if (inContainer) {
                        if (!slot.m_5857_(newItem)) {
                            return;
                        }
                        slot.m_269060_(newItem);
                    } else {
                        playerInventory.m_6836_(slotIndex, newItem);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
            if (inventorySwap != Integer.MIN_VALUE) {
                playerInventory.m_6836_(inventorySwap, sourceItem);
            } else if (!skipSettingSlot && !player.m_7500_()) {
                this.addToPlayer(player, sourceItem.m_41777_(), !inContainer);
            }
            CConvertItemPacket.playPickupSound((Player)player);
            player.f_36096_.m_38946_();
        });
    }

    private void addToPlayer(ServerPlayer player, ItemStack itemStack, boolean nextToSelected) {
        int slot;
        Inventory inventory = player.m_150109_();
        IntStream intStream = IntStream.range(0, 9);
        if (nextToSelected) {
            IntStream leftAndRight = IntStream.of(inventory.f_35977_ + 1, inventory.f_35977_ - 1);
            intStream = IntStream.concat(leftAndRight, intStream);
        }
        if (!inventory.m_36040_(slot = intStream.filter(Inventory::m_36045_).filter(i -> {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) {
                return true;
            }
            return stack.m_41613_() < stack.m_41741_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack);
        }).findFirst().orElse(-1), itemStack) && !player.m_7500_()) {
            player.m_36176_(itemStack, true);
        }
    }

    public static void playPickupSound(Player player) {
        player.m_9236_().m_6263_((Player)(player.m_7578_() ? player : null), player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }

    public record Entry(float ratio, List<Pair<KHolder<BlockFamily>, Item>> steps) {
        public Entry(float ratio) {
            this(ratio, Lists.newArrayList());
        }

        public Item item() {
            return (Item)this.steps.get(this.steps.size() - 1).getSecond();
        }
    }

    public record Group(LinkedHashSet<Entry> entries) {
        public Group() {
            this(Sets.newLinkedHashSet());
        }
    }
}

