/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.command;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.command.ReloadSlotsCommand;

public class ReloadBlockSettingsCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"block_settings").executes(ctx -> ReloadBlockSettingsCommand.reload((CommandSourceStack)ctx.getSource())));
    }

    private static int reload(CommandSourceStack source) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        BlockFundamentals fundamentals = BlockFundamentals.reload(CustomizationHooks.collectKiwiPacks(), false);
        long parseTime = stopwatch.elapsed().toMillis();
        stopwatch.reset().start();
        HashSet set = Sets.newHashSet();
        BuiltInRegistries.f_256975_.m_203611_().forEach(holder -> {
            KBlockDefinition definition = fundamentals.blocks().get(holder.m_205785_().m_135782_());
            if (definition == null || !set.add((Block)holder.m_203334_())) {
                return;
            }
            KBlockSettings.Builder builder = definition.createSettings(holder.m_205785_().m_135782_(), fundamentals.shapes());
            ((Block)holder.m_203334_()).f_60439_ = builder.get();
            KBlockDefinition.setConfiguringShape((Block)holder.m_203334_());
        });
        Blocks.m_50758_();
        ReloadSlotsCommand.reload(fundamentals);
        long attachTime = stopwatch.elapsed().toMillis();
        Kiwi.LOGGER.info("Parse time %dms + Attach time %dms = %dms".formatted(parseTime, attachTime, parseTime + attachTime));
        source.m_288197_(() -> Component.m_237113_((String)"%d Block settings reloaded".formatted(set.size())), false);
        return 1;
    }
}

