/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.InjectedBlockPropertiesCodec;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.block.loader.KBlockTemplates;
import snownee.kiwi.customization.block.loader.KMaterial;

public final class BuiltInBlockTemplate
extends KBlockTemplate {
    private final Optional<ResourceLocation> key;
    private MapCodec<Block> codec;

    public BuiltInBlockTemplate(Optional<BlockDefinitionProperties> properties, Optional<ResourceLocation> key) {
        super(properties);
        this.key = key;
    }

    public static Codec<BuiltInBlockTemplate> directCodec(MapCodec<Optional<KMaterial>> materialCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)BlockDefinitionProperties.mapCodecField(materialCodec).forGetter(KBlockTemplate::properties), (App)ResourceLocation.f_135803_.optionalFieldOf("codec").forGetter(BuiltInBlockTemplate::key)).apply((Applicative)instance, BuiltInBlockTemplate::new));
    }

    @Override
    public KBlockTemplate.Type<?> type() {
        return KBlockTemplates.BUILT_IN.getOrCreate();
    }

    @Override
    public void resolve(ResourceLocation key) {
        this.codec = BlockCodecs.get(this.key.orElse(key));
    }

    @Override
    public Block createBlock(ResourceLocation id, BlockBehaviour.Properties properties, JsonObject json) {
        if (!json.has("properties")) {
            json.add("properties", (JsonElement)new JsonObject());
        }
        InjectedBlockPropertiesCodec.INJECTED.set(properties);
        DataResult result = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap((JsonElement)json).result().orElseThrow());
        if (result.error().isPresent()) {
            throw new IllegalStateException(((DataResult.PartialResult)result.error().get()).message());
        }
        return (Block)result.result().orElseThrow();
    }

    public Optional<ResourceLocation> key() {
        return this.key;
    }

    public String toString() {
        return "BuiltInBlockTemplate[properties=" + this.properties + ", key=" + this.key + ", codec=" + this.codec + "]";
    }
}

