/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KHolder;

public class BlockFamilyInferrer {
    public static final TagKey<Block> IGNORE = AbstractModule.blockTag("kswitch", "ignore");
    private final List<KHolder<BlockFamily>> families = Lists.newArrayList();
    private final Set<Block> capturedBlocks = Sets.newHashSet();
    private final List<String> colorPrefixed = Lists.newArrayList();
    private final List<String> colorSuffixed = Lists.newArrayList();
    private final List<String> logs = List.of("%s_log", "%s_wood", "stripped_%s_log", "stripped_%s_wood");
    private final List<String> netherLogs = List.of("%s_stem", "%s_hyphae", "stripped_%s_stem", "stripped_%s_hyphae");
    private final List<String> general = List.of("%s", "%s_stairs", "%s_slab", "%s_wall", "%s_fence", "%s_fence_gate", "%s_door", "%s_trapdoor", "%s_button", "%s_pressure_plate");
    private final List<String> variants = List.of("%s", "chiseled_%s", "polished_%s", "cut_%s", "smooth_%s", "cracked_%s", "%s_bricks", "%s_pillar");

    public BlockFamilyInferrer() {
        for (DyeColor color : DyeColor.values()) {
            this.colorPrefixed.add(color.m_41065_() + "_%s");
            this.colorSuffixed.add("%s_" + color.m_41065_());
        }
    }

    public Collection<KHolder<BlockFamily>> generate() {
        ArrayList sorted = Lists.newArrayList();
        for (Holder holder : BuiltInRegistries.f_256975_.m_206115_()) {
            String path = ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_().m_135815_();
            if (!path.startsWith("pink_") && !path.endsWith("_pink") && !path.endsWith("_log") && !path.endsWith("_stem") && !path.endsWith("_stairs") && !path.endsWith("_slab") && !path.startsWith("smooth_") || holder.m_203656_(IGNORE)) continue;
            sorted.add(holder);
        }
        sorted.sort((a, b) -> {
            String aPath = ((ResourceKey)a.m_203543_().orElseThrow()).m_135782_().m_135815_();
            String bPath = ((ResourceKey)b.m_203543_().orElseThrow()).m_135782_().m_135815_();
            boolean aIsStairs = aPath.endsWith("_stairs");
            boolean bIsStairs = bPath.endsWith("_stairs");
            return Boolean.compare(bIsStairs, aIsStairs);
        });
        for (Holder holder : sorted) {
            ResourceLocation id;
            Block block = (Block)holder.m_203334_();
            if (this.capturedBlocks.contains(block) || !BlockFamilies.findQuickSwitch(block.m_5456_(), true).isEmpty()) continue;
            ResourceLocation key = ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_();
            String string = key.m_135815_();
            boolean captured = false;
            if (string.startsWith("pink_")) {
                id = key.m_247449_(string.substring(5));
                this.generateColored(id, this.colorPrefixed);
                captured = true;
            } else if (string.endsWith("_pink")) {
                id = key.m_247449_(string.substring(0, string.length() - 5));
                this.generateColored(id, this.colorSuffixed);
                captured = true;
            }
            if (string.endsWith("_log")) {
                if (!holder.m_203656_(BlockTags.f_13106_)) continue;
                id = key.m_247449_(string.substring(0, string.length() - 4));
                this.fromTemplates(id, "logs", this.logs, true);
                continue;
            }
            if (string.endsWith("_stem")) {
                if (!holder.m_203656_(BlockTags.f_13106_)) continue;
                id = key.m_247449_(string.substring(0, string.length() - 5));
                this.fromTemplates(id, "logs", this.netherLogs, true);
                continue;
            }
            if (string.endsWith("_stairs")) {
                if (!(block instanceof StairBlock)) continue;
                StairBlock stairBlock = (StairBlock)block;
                if (stairBlock.f_56859_.m_60795_()) continue;
                ResourceLocation id2 = key.m_247449_(string.substring(0, string.length() - 7));
                List<Holder.Reference<Block>> blocks = this.collectBlocks(id2, this.general);
                Holder.Reference baseHolder = stairBlock.f_56859_.m_60734_().m_204297_();
                id2 = baseHolder.m_205785_().m_135782_();
                blocks.add(0, (Holder.Reference<Block>)baseHolder);
                blocks.addAll(this.collectBlocks(id2, this.variants));
                if (id2.m_135815_().endsWith("_block")) {
                    ResourceLocation altId = id2.m_247449_(id2.m_135815_().substring(0, id2.m_135815_().length() - 6));
                    blocks.addAll(this.collectBlocks(altId, this.variants));
                }
                this.family(id2, "variants", blocks.stream().distinct().toList(), true);
                continue;
            }
            if (string.endsWith("_slab")) {
                id = key.m_247449_(string.substring(0, string.length() - 5));
                this.fromTemplates(id, "general", this.general, true);
                captured = true;
            } else if (string.startsWith("smooth_")) {
                id = key.m_247449_(string.substring(7));
                this.fromTemplates(id, "variants", this.variants, true);
                captured = true;
            }
            if (captured) continue;
            throw new IllegalStateException("Unrecognized block: " + holder.m_203334_());
        }
        List<String> normalCopperTemplate = List.of("%s_block", "cut_%s", "chiseled_%s", "%s_grate");
        List<String> otherCopperTemplate = List.of("%s", "cut_%s", "chiseled_%s", "%s_grate");
        ResourceLocation copperId = new ResourceLocation("copper");
        for (String string : List.of("", "waxed_")) {
            for (String variant : List.of("", "exposed_", "weathered_", "oxidized_")) {
                List<String> template = variant.isEmpty() ? normalCopperTemplate : otherCopperTemplate;
                template = template.stream().map($ -> waxed + variant + $).toList();
                this.fromTemplates(copperId, string + variant + "copper", template, true);
            }
        }
        if (!Platform.isProduction()) {
            for (KHolder kHolder : this.families) {
                Kiwi.LOGGER.info(kHolder.key().toString() + ":");
                for (Holder.Reference<Block> holder : ((BlockFamily)kHolder.value()).blockHolders()) {
                    Kiwi.LOGGER.info("  - " + ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_());
                }
            }
        }
        return this.families;
    }

    private List<Holder.Reference<Block>> collectBlocks(ResourceLocation id, List<String> templates) {
        ArrayList blocks = Lists.newArrayList();
        for (String template : templates) {
            ResourceLocation blockId = id.m_247449_(String.format(template, id.m_135815_()));
            Optional holder = BuiltInRegistries.f_256975_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)blockId));
            holder.ifPresent(blocks::add);
        }
        return blocks;
    }

    private void fromTemplates(ResourceLocation id, String desc, List<String> templates, boolean cascading) {
        List<Holder.Reference<Block>> blocks = this.collectBlocks(id, templates);
        if (blocks.size() < 2) {
            return;
        }
        this.family(id, desc, blocks, cascading);
    }

    private void generateColored(ResourceLocation id, List<String> templates) {
        List<Holder.Reference<Block>> blocks = this.collectBlocks(id, templates);
        if (blocks.size() != templates.size()) {
            return;
        }
        this.family(id, "colored", blocks, false);
    }

    private void family(ResourceLocation id, String desc, List<Holder.Reference<Block>> blocks, boolean cascading) {
        List<ResourceKey<Block>> blockKeys = blocks.stream().filter($ -> !$.m_203656_(IGNORE)).map(Holder.Reference::m_205785_).toList();
        KHolder<BlockFamily> family = new KHolder<BlockFamily>(id.m_246208_("auto/%s/".formatted(desc)), new BlockFamily(false, blockKeys, List.of(), List.of(), false, Optional.empty(), 1, BlockFamily.SwitchAttrs.create(true, cascading, false)));
        this.families.add(family);
        family.value().blocks().forEach(this.capturedBlocks::add);
    }
}

