/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.behavior.SitManager;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.customization.builder.BuildersButton;
import snownee.kiwi.customization.builder.ConvertScreen;
import snownee.kiwi.customization.command.ExportBlocksCommand;
import snownee.kiwi.customization.command.ExportCreativeTabsCommand;
import snownee.kiwi.customization.command.ExportShapesCommand;
import snownee.kiwi.customization.command.ReloadBlockSettingsCommand;
import snownee.kiwi.customization.command.ReloadFamiliesAndRulesCommand;
import snownee.kiwi.customization.command.ReloadSlotsCommand;
import snownee.kiwi.customization.item.loader.KItemDefinition;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.ColorProviderUtil;
import snownee.kiwi.util.SmartKey;

public final class CustomizationClient {
    @Nullable
    public static SmartKey buildersButtonKey;

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(event -> {
            if (!CustomizationHooks.kswitch && BlockFamilies.all().isEmpty() && BuilderRules.all().isEmpty()) {
                return;
            }
            buildersButtonKey = new SmartKey.Builder("key.kiwi.builders_button", "key.categories.gameplay").key(InputConstants.m_84851_((String)"key.mouse.4")).onLongPress(BuildersButton::onLongPress).onShortPress(BuildersButton::onShortPress).build();
            event.register((KeyMapping)buildersButtonKey);
            ClientProxy.afterRegisterSmartKey(buildersButtonKey);
        });
        forgeEventBus.addListener(event -> {
            if (event.phase == TickEvent.Phase.END) {
                ConvertScreen.tickLingering();
            }
        });
        forgeEventBus.addListener(event -> {
            LiteralArgumentBuilder kiwi = Commands.m_82127_((String)"kiwi");
            LiteralArgumentBuilder customization = (LiteralArgumentBuilder)Commands.m_82127_((String)"customization").requires(source -> source.m_6761_(2));
            LiteralArgumentBuilder export = Commands.m_82127_((String)"export");
            ExportBlocksCommand.register((LiteralArgumentBuilder<CommandSourceStack>)export);
            ExportShapesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)export);
            ExportCreativeTabsCommand.register((LiteralArgumentBuilder<CommandSourceStack>)export);
            LiteralArgumentBuilder reload = Commands.m_82127_((String)"reload");
            ReloadSlotsCommand.register((LiteralArgumentBuilder<CommandSourceStack>)reload);
            ReloadBlockSettingsCommand.register((LiteralArgumentBuilder<CommandSourceStack>)reload);
            ReloadFamiliesAndRulesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)reload);
            event.getDispatcher().register((LiteralArgumentBuilder)kiwi.then(((LiteralArgumentBuilder)customization.then((ArgumentBuilder)export)).then((ArgumentBuilder)reload)));
        });
        forgeEventBus.addListener(event -> BuildersButton.renderDebugText(event.getLeft(), event.getRight()));
        forgeEventBus.addListener(event -> {
            if (BuildersButton.cancelRenderHighlight()) {
                event.setCanceled(true);
            }
        });
        forgeEventBus.addListener(event -> {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && SitManager.isSeatEntity(player.m_20202_())) {
                SitManager.clampRotation((Player)player, player.m_20202_());
            }
        });
    }

    public static void afterRegister(Map<ResourceLocation, KItemDefinition> items, Map<ResourceLocation, KBlockDefinition> blocks, ClientProxy.Context context) {
        HashMap blockColors = Maps.newHashMap();
        HashMap itemColors = Maps.newHashMap();
        ArrayList blocksToAdd = Lists.newArrayList();
        ArrayList itemsToAdd = Lists.newArrayList();
        HashSet addedItems = Sets.newHashSet();
        for (Map.Entry<ResourceLocation, KItemDefinition> entry : items.entrySet()) {
            KItemDefinition definition = entry.getValue();
            if (definition.properties().colorProvider().isEmpty()) continue;
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(entry.getKey());
            Item providerItem = (Item)BuiltInRegistries.f_257033_.m_7745_(definition.properties().colorProvider().get());
            if (providerItem == Items.f_41852_) {
                Kiwi.LOGGER.warn("Cannot find color provider item %s for item %s".formatted(definition.properties().colorProvider().get(), entry.getKey()));
                continue;
            }
            itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, ColorProviderUtil::delegate)));
            addedItems.add(item);
        }
        for (Map.Entry<ResourceLocation, Record> entry : blocks.entrySet()) {
            Item item;
            BlockDefinitionProperties properties = ((KBlockDefinition)entry.getValue()).properties();
            if (context.loading()) {
                KiwiModule.RenderLayer.Layer renderType = properties.renderType().orElse(null);
                if (renderType == null) {
                    renderType = properties.glassType().map(GlassType::renderType).orElse(null);
                }
                if (renderType != null) {
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(entry.getKey());
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)((RenderType)renderType.value));
                }
            }
            if (properties.colorProvider().isEmpty()) continue;
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(entry.getKey());
            Block providerBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(properties.colorProvider().get());
            if (providerBlock == Blocks.f_50016_) {
                Kiwi.LOGGER.warn("Cannot find color provider block %s for block %s".formatted(properties.colorProvider().get(), entry.getKey()));
            } else {
                blocksToAdd.add(Pair.of((Object)block, (Object)blockColors.computeIfAbsent(providerBlock, ColorProviderUtil::delegate)));
            }
            if ((item = block.m_5456_()) == Items.f_41852_ || addedItems.contains(item)) continue;
            addedItems.add(item);
            Item providerItem = providerBlock.m_5456_();
            if (providerItem != Items.f_41852_) {
                itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, ColorProviderUtil::delegate)));
                continue;
            }
            if (providerBlock == Blocks.f_49990_) {
                itemsToAdd.add(Pair.of((Object)item, (stack, i) -> 4159204));
                continue;
            }
            itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, $ -> ColorProviderUtil.delegateItemFallback(providerBlock))));
        }
        ClientProxy.registerColors(context, blocksToAdd, itemsToAdd);
    }
}

