/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.util.emissive;

import com.foozey.gems.Gems;
import com.foozey.gems.tag.ModItemLists;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EmissiveHumanoidArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    public EmissiveHumanoidArmorLayer(RenderLayerParent<T, M> renderer, A innerModel, A outerModel, ModelManager modelManager) {
        super(renderer, innerModel, outerModel, modelManager);
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderEmissive(poseStack, buffer, livingEntity, EquipmentSlot.HEAD);
        this.renderEmissive(poseStack, buffer, livingEntity, EquipmentSlot.CHEST);
        this.renderEmissive(poseStack, buffer, livingEntity, EquipmentSlot.LEGS);
        this.renderEmissive(poseStack, buffer, livingEntity, EquipmentSlot.FEET);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        String item = Gems.getPath(stack.m_41720_());
        String material = item.split("_")[0];
        if (ModItemLists.EMISSIVE_ITEMS.contains(stack.m_41720_()) && (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.FEET)) {
            return Gems.rl("textures/models/armor/" + material + "_layer_1_overlay.png");
        }
        if (ModItemLists.EMISSIVE_ITEMS.contains(stack.m_41720_()) && slot == EquipmentSlot.LEGS) {
            return Gems.rl("textures/models/armor/" + material + "_layer_2_overlay.png");
        }
        return new ResourceLocation("");
    }

    private void renderEmissive(PoseStack poseStack, MultiBufferSource buffer, T livingEntity, EquipmentSlot slot) {
        if (ModItemLists.EMISSIVE_ITEMS.contains(livingEntity.m_6844_(slot).m_41720_())) {
            this.m_117118_(poseStack, buffer, (LivingEntity)livingEntity, slot, 0xF000F0, this.m_117078_(slot));
        }
    }
}

