/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddItemLootModifier
extends LootModifier {
    private final Item item;
    private final int minItems;
    private final int maxItems;
    private final float probability;
    public static final Supplier<Codec<AddItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.INT.fieldOf("minItems").forGetter(m -> m.minItems), (App)Codec.INT.fieldOf("maxItems").forGetter(m -> m.maxItems), (App)Codec.FLOAT.fieldOf("probability").forGetter(m -> Float.valueOf(m.probability)))).apply((Applicative)inst, AddItemLootModifier::new)));

    public AddItemLootModifier(LootItemCondition[] conditionsIn, Item item, int minItems, int maxItems, float probability) {
        super(conditionsIn);
        this.item = item;
        this.minItems = minItems;
        this.maxItems = maxItems;
        this.probability = probability;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int randomCount = context.m_230907_().m_188503_(this.maxItems - this.minItems + 1) + this.minItems;
        if (context.m_230907_().m_188501_() <= this.probability) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item, randomCount));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

