/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.item.tiers;

import com.foozey.gems.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ModArmorMaterials implements ArmorMaterial
{
    TOPAZ("gems:topaz", 37, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11679_, 3.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOPAZ.get()})),
    SAPPHIRE("gems:sapphire", 37, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11679_, 3.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SAPPHIRE.get()})),
    RUBY("gems:ruby", 37, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11679_, 3.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RUBY.get()})),
    DRAGONYX("gems:dragonyx", 37, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11679_, 3.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DRAGONYX_INGOT.get()})),
    EMERALD("gems:emerald", 15, new int[]{2, 5, 6, 2}, 30, SoundEvents.f_11677_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42616_.m_5456_()}));

    private final String name;
    private static final int[] durabilityBase;
    private final int durabilityMultiplier;
    private final int[] armorVal;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Ingredient repairIngredient;

    private ModArmorMaterials(String name, int durabilityMultiplier, int[] armorVal, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.armorVal = armorVal;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public int m_266425_(ArmorItem.Type type) {
        return durabilityBase[type.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.armorVal[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient;
    }

    static {
        durabilityBase = new int[]{13, 15, 16, 11};
    }
}

