/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.item.attributes;

import com.foozey.gems.Gems;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public record AttributeBuilder(Attribute attribute, String name, double amount, AttributeModifier.Operation operation) {
    public static Function<UUID, Multimap<Attribute, AttributeModifier>> addModifiers(List<AttributeBuilder> attributeBuilders) {
        return uuid -> {
            LinkedHashMultimap modifiers = LinkedHashMultimap.create();
            for (AttributeBuilder holder : attributeBuilders) {
                modifiers.put((Object)holder.attribute, (Object)new AttributeModifier(uuid, holder.name, holder.amount, holder.operation));
            }
            return modifiers;
        };
    }

    public static UUID uuid(EquipmentSlot slot, ItemStack stack) {
        String string = slot.m_20751_() + "_" + Gems.getPath(stack.m_41720_());
        return UUID.nameUUIDFromBytes(string.getBytes());
    }
}

