/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.item;

import com.foozey.gems.item.attributes.AttributeBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModCrossbowItem
extends CrossbowItem {
    private final Item repairItem;
    private final int enchantability;
    private final Function<UUID, Multimap<Attribute, AttributeModifier>> attributes;

    public ModCrossbowItem(Item repairItem, int enchantability, Function<UUID, Multimap<Attribute, AttributeModifier>> attributes, Item.Properties properties) {
        super(properties);
        this.repairItem = repairItem;
        this.enchantability = enchantability;
        this.attributes = attributes;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repairWith) {
        return repairWith.m_41720_() == this.repairItem || super.m_6832_(toRepair, repairWith);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.enchantability;
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            builder.putAll(map);
            if (this.attributes != null) {
                builder.putAll(this.attributes.apply(AttributeBuilder.uuid(slot, stack)));
            }
        }
        return builder.build();
    }
}

