/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.event;

import com.foozey.gems.data.ModAdvancementProvider;
import com.foozey.gems.data.ModBlockStateProvider;
import com.foozey.gems.data.ModBlockTagsProvider;
import com.foozey.gems.data.ModItemModelProvider;
import com.foozey.gems.data.ModItemTagsProvider;
import com.foozey.gems.data.ModLanguageProvider;
import com.foozey.gems.data.ModLootModifierProvider;
import com.foozey.gems.data.ModLootTableProvider;
import com.foozey.gems.data.ModRecipeProvider;
import com.foozey.gems.data.ModRegistrySetProvider;
import com.foozey.gems.data.ModSpriteSourceProvider;
import com.foozey.gems.registry.ModAttributes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gems", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonEventsMod {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModSpriteSourceProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(output));
        ModBlockTagsProvider modBlockTagsProvider = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, lookupProvider, modBlockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootModifierProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRegistrySetProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(output, lookupProvider, existingFileHelper));
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
        for (EntityType type : event.getTypes()) {
            event.add(type, (Attribute)ModAttributes.ARROW_DAMAGE.get());
            event.add(type, (Attribute)ModAttributes.BLOCK_STRENGTH.get());
            event.add(type, (Attribute)ModAttributes.BONUS_XP.get());
            event.add(type, (Attribute)ModAttributes.LIFESTEAL.get());
            event.add(type, (Attribute)ModAttributes.HARVEST_AREA.get());
        }
    }
}

