/*
 * Decompiled with CFR 0.152.
 */
package com.foozey.gems.event;

import com.foozey.gems.Gems;
import com.foozey.gems.registry.ModAttributes;
import com.foozey.gems.registry.ModItems;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(modid="gems", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventsForge {
    @SubscribeEvent
    public static void arrowDamage(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity2).m_19749_()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            arrow.m_36781_(arrow.m_36789_() * shooter.m_21133_((Attribute)ModAttributes.ARROW_DAMAGE.get()));
        }
    }

    @SubscribeEvent
    public static void blockStrength(ShieldBlockEvent event) {
        Item item = event.getEntity().m_21211_().m_41720_();
        if (item == Items.f_42740_ || Gems.isModid(item) && item instanceof ShieldItem) {
            event.setBlockedDamage((float)event.getEntity().m_21133_((Attribute)ModAttributes.BLOCK_STRENGTH.get()) + 3.0f);
        }
    }

    @SubscribeEvent
    public static void miningBonusXP(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player.m_21133_((Attribute)ModAttributes.BONUS_XP.get()) > 0.0) {
            event.setExpToDrop((int)((double)event.getExpToDrop() * player.m_21133_((Attribute)ModAttributes.BONUS_XP.get())));
        }
    }

    @SubscribeEvent
    public static void mobBonusXP(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null && player.m_21133_((Attribute)ModAttributes.BONUS_XP.get()) > 0.0) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * player.m_21133_((Attribute)ModAttributes.BONUS_XP.get())));
        }
    }

    @SubscribeEvent
    public static void lifesteal(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5634_((float)player.m_21133_((Attribute)ModAttributes.LIFESTEAL.get()));
        }
    }

    @SubscribeEvent
    public static void harvestArea(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21120_(player.m_7655_());
        if ((stack.m_41720_() instanceof PickaxeItem || stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof ShovelItem || stack.m_41720_() instanceof HoeItem) && player.m_21133_((Attribute)ModAttributes.HARVEST_AREA.get()) > 1.0) {
            HitResult result = player.m_19907_(5.0, 0.0f, false);
            Direction facing = Direction.UP;
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                UseOnContext context = new UseOnContext(player, player.m_7655_(), (BlockHitResult)result);
                BlockHitResult res = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
                facing = res.m_82434_();
            }
            int zMin = 0;
            int zMax = 0;
            int xMin = 0;
            int xMax = 0;
            int yMin = 0;
            int yMax = 0;
            int lvl = (int)player.m_21133_((Attribute)ModAttributes.HARVEST_AREA.get()) - 1;
            if (player.m_6069_() || !player.m_20096_()) {
                if (facing.equals((Object)Direction.DOWN) || facing.equals((Object)Direction.UP)) {
                    zMin = -lvl;
                    zMax = lvl;
                    xMin = -lvl;
                    xMax = lvl;
                } else if (facing.equals((Object)Direction.WEST) || facing.equals((Object)Direction.EAST)) {
                    zMin = -lvl;
                    zMax = lvl;
                    yMin = -lvl;
                    yMax = lvl;
                } else if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
                    xMin = -lvl;
                    xMax = lvl;
                    yMin = -lvl;
                    yMax = lvl;
                }
            } else if (facing.equals((Object)Direction.DOWN) || facing.equals((Object)Direction.UP)) {
                zMin = -lvl;
                zMax = lvl;
                xMin = -lvl;
                xMax = lvl;
            } else if (facing.equals((Object)Direction.WEST) || facing.equals((Object)Direction.EAST)) {
                zMin = -lvl;
                zMax = lvl;
                yMin = -1;
                yMax = 2 * lvl - 1;
            } else if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
                xMin = -lvl;
                xMax = lvl;
                yMin = -1;
                yMax = 2 * lvl - 1;
            }
            BlockPos pos = event.getPos();
            ArrayList<BlockPos> workQueue = new ArrayList<BlockPos>();
            for (int z = zMin; z <= zMax; ++z) {
                for (int x = xMin; x <= xMax; ++x) {
                    for (int y = yMin; y <= yMax; ++y) {
                        workQueue.add(pos.m_7918_(x, y, z));
                    }
                }
            }
            if (player.m_6047_()) {
                return;
            }
            for (BlockPos blockPos : workQueue) {
                int damDone;
                int maxDur;
                BlockState blockToBreak;
                Level world = player.m_20193_();
                if (world.m_7702_(blockPos) != null || !ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)(blockToBreak = world.m_8055_(blockPos)), (boolean)true) || blockToBreak.m_60795_() || blockToBreak.m_60734_() instanceof IFluidBlock || blockToBreak.m_60734_() instanceof LiquidBlock || blockToBreak.m_60800_((BlockGetter)world, blockPos) == -1.0f || Math.subtractExact(maxDur = stack.m_41776_(), damDone = stack.m_41773_()) < 0) continue;
                player.m_21120_(player.m_7655_()).m_41622_(1, (LivingEntity)player, playerEntity -> {});
                if (!blockToBreak.canHarvestBlock((BlockGetter)world, pos, player)) continue;
                blockToBreak.m_60734_().m_6240_(world, player, blockPos, blockToBreak, null, player.m_21205_());
                blockToBreak.m_60734_().m_5707_(world, blockPos, blockToBreak, player);
                int expDrop = blockToBreak.m_60734_().getExpDrop(blockToBreak, (LevelReader)world, RandomSource.m_216327_(), blockPos, EnchantmentHelper.m_44831_((ItemStack)player.m_21205_()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44987_, (LivingEntity)player) : 0, EnchantmentHelper.m_44831_((ItemStack)player.m_21205_()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)player) : 0);
                if (expDrop > 0) {
                    blockToBreak.m_60734_().m_49805_((ServerLevel)world, player.m_20183_().m_7918_(0, 1, 0), expDrop);
                }
                world.m_7471_(blockPos, false);
            }
        }
    }

    @SubscribeEvent
    public static void dragonyxArmorBonus(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getSource().m_276093_(DamageTypes.f_268724_) && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModItems.DRAGONYX_HELMET.get() && player.m_6844_(EquipmentSlot.CHEST).m_41720_() == ModItems.DRAGONYX_CHESTPLATE.get() && player.m_6844_(EquipmentSlot.LEGS).m_41720_() == ModItems.DRAGONYX_LEGGINGS.get() && player.m_6844_(EquipmentSlot.FEET).m_41720_() == ModItems.DRAGONYX_BOOTS.get()) {
                BlockPos position;
                event.setAmount(0.0f);
                player.f_19789_ = 0.0f;
                ServerLevel level = player.m_20194_().m_129880_(player.m_8963_());
                BlockPos blockPos = position = player.m_8961_() != null ? player.m_8961_() : level.m_220360_();
                if (level != null && position != null) {
                    player.m_8999_(level, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 1.0f, 1.0f);
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_21153_(player.m_21233_());
            }
        }
    }

    @SubscribeEvent
    public static void emeraldArmorBonus(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_6844_(EquipmentSlot.HEAD).m_41720_() == ModItems.EMERALD_HELMET.get() && player.m_6844_(EquipmentSlot.CHEST).m_41720_() == ModItems.EMERALD_CHESTPLATE.get() && player.m_6844_(EquipmentSlot.LEGS).m_41720_() == ModItems.EMERALD_LEGGINGS.get() && player.m_6844_(EquipmentSlot.FEET).m_41720_() == ModItems.EMERALD_BOOTS.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 39, 0, true, false));
        }
    }

    @SubscribeEvent
    public static void curiosDurabilityLoss(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> inventory.findCurios(stack -> Gems.isModid(stack.m_41720_())).forEach(result -> result.stack().m_41622_(1, (LivingEntity)player, player2 -> {
                CuriosApi.broadcastCurioBreakEvent((SlotContext)result.slotContext());
                player2.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
            })));
        }
    }
}

