/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import capsule.structure.CapsuleTemplate;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleTemplateManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, CapsuleTemplate> templates = Maps.newHashMap();
    private final DataFixer fixer;
    private ResourceManager resourceManager;
    private final Path pathGenerated;

    public CapsuleTemplateManager(ResourceManager resourceManager, File templateFolder, DataFixer fixerIn) {
        this.resourceManager = resourceManager;
        this.fixer = fixerIn;
        this.pathGenerated = templateFolder.toPath().normalize();
    }

    public CapsuleTemplate getOrCreateTemplate(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.m_135815_());
        CapsuleTemplate template = this.getTemplate(capsuleTemplateLocation);
        if (template == null) {
            template = new CapsuleTemplate();
            this.templates.put(capsuleTemplateLocation, template);
        }
        return template;
    }

    @Nullable
    public CapsuleTemplate getTemplate(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.m_135815_());
        return this.templates.computeIfAbsent(capsuleTemplateLocation, p_209204_1_ -> {
            CapsuleTemplate template = this.loadTemplateFile((ResourceLocation)p_209204_1_, ".schematic");
            if (template == null) {
                template = this.loadTemplateFile((ResourceLocation)p_209204_1_, ".nbt");
            }
            if (template == null) {
                template = this.loadTemplateResource((ResourceLocation)p_209204_1_, ".schematic");
            }
            if (template == null) {
                template = this.loadTemplateResource((ResourceLocation)p_209204_1_, ".nbt");
            }
            return template;
        });
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.templates.clear();
    }

    @Nullable
    private CapsuleTemplate loadTemplateResource(ResourceLocation p_209201_1_, String extension) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", p_209201_1_.m_135815_() + extension);
        Optional optionalTemplate = this.resourceManager.m_213713_(capsuleTemplateLocation);
        if (optionalTemplate.isPresent()) {
            try {
                CapsuleTemplate template = this.loadTemplate(((Resource)optionalTemplate.get()).m_215507_(), ".schematic".equals(extension), capsuleTemplateLocation.toString());
                return template;
            }
            catch (FileNotFoundException var18) {
                return null;
            }
            catch (Throwable throwable) {
                LOGGER.error("Couldn't load structure {}: {}", (Object)capsuleTemplateLocation, (Object)throwable.toString());
                return null;
            }
        }
        return null;
    }

    @Nullable
    private CapsuleTemplate loadTemplateFile(ResourceLocation locationIn, String extension) {
        CapsuleTemplate capsuleTemplate;
        if (!this.pathGenerated.toAbsolutePath().toFile().isDirectory()) {
            return null;
        }
        Path path = this.resolvePath(locationIn, extension);
        FileInputStream inputstream = new FileInputStream(path.toFile());
        try {
            CapsuleTemplate template;
            capsuleTemplate = template = this.loadTemplate(inputstream, ".schematic".equals(extension), path.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        ((InputStream)inputstream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException var18) {
                    return null;
                }
                catch (IOException ioexception) {
                    LOGGER.error("Couldn't load structure from {}", (Object)path, (Object)ioexception);
                    return null;
                }
                catch (Exception exception) {
                    LOGGER.error("Error while loading {}", (Object)path, (Object)exception);
                    return null;
                }
            }
            catch (ResourceLocationException e) {
                LOGGER.error("Couldn't resolve proper location: {}", (Object)locationIn.m_135815_(), (Object)e);
                return null;
            }
        }
        ((InputStream)inputstream).close();
        return capsuleTemplate;
    }

    private CapsuleTemplate loadTemplate(InputStream inputStreamIn, Boolean isSchematic, String location) throws Exception {
        if (isSchematic.booleanValue()) {
            return this.readTemplateFromSchematic(inputStreamIn, location);
        }
        CompoundTag compoundnbt = NbtIo.m_128939_((InputStream)inputStreamIn);
        return this.readFromNBT(compoundnbt, location);
    }

    public CapsuleTemplate readFromNBT(CompoundTag p_227458_1_, String location) {
        if (!p_227458_1_.m_128425_("DataVersion", 99)) {
            p_227458_1_.m_128405_("DataVersion", 500);
        }
        CapsuleTemplate template = new CapsuleTemplate();
        template.load(DataFixTypes.STRUCTURE.m_264218_(this.fixer, p_227458_1_, p_227458_1_.m_128451_("DataVersion")), location);
        return template;
    }

    public boolean writeToFile(ResourceLocation templateName) {
        boolean bl;
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateName.m_135815_());
        CapsuleTemplate template = this.templates.get(capsuleTemplateLocation);
        if (template == null) {
            return false;
        }
        Path path = this.resolvePath(capsuleTemplateLocation, ".nbt");
        Path path1 = path.getParent();
        if (path1 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path1, new LinkOption[0]) ? path1.toRealPath(new LinkOption[0]) : path1, new FileAttribute[0]);
        }
        catch (IOException var19) {
            LOGGER.error("Failed to create parent directory: {}", (Object)path1);
            return false;
        }
        CompoundTag compoundnbt = template.save(new CompoundTag());
        FileOutputStream outputstream = new FileOutputStream(path.toFile());
        try {
            NbtIo.m_128947_((CompoundTag)compoundnbt, (OutputStream)outputstream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputstream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable var21) {
                return false;
            }
        }
        ((OutputStream)outputstream).close();
        return bl;
    }

    private Path resolvePath(ResourceLocation locationIn, String extIn) {
        if (locationIn.m_135815_().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + locationIn);
        }
        String ext = locationIn.m_135815_().endsWith(extIn) ? "" : extIn;
        Path p = this.pathGenerated.toAbsolutePath().resolve(locationIn.m_135815_() + ext).normalize();
        if (FileUtil.m_133728_((Path)p) && FileUtil.m_133734_((Path)p)) {
            return p;
        }
        throw new ResourceLocationException("Invalid resource path: " + p);
    }

    public void remove(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.m_135815_());
        this.templates.remove(capsuleTemplateLocation);
    }

    public CapsuleTemplate readTemplateFromSchematic(InputStream inputstream, String location) throws Exception {
        CompoundTag schematicNBT = NbtIo.m_128939_((InputStream)inputstream);
        CapsuleTemplate template = new CapsuleTemplate();
        template.readSchematic(schematicNBT);
        CompoundTag compoundnbt = template.save(new CompoundTag());
        return this.readFromNBT(compoundnbt, location);
    }

    public boolean deleteTemplate(ResourceLocation templateLocation) {
        ResourceLocation capsuleTemplateLocation = new ResourceLocation("capsule", templateLocation.m_135815_());
        if (this.templates.containsKey(capsuleTemplateLocation)) {
            File file = this.resolvePath(capsuleTemplateLocation, ".nbt").toFile();
            boolean deleted = file.delete();
            if (deleted) {
                this.remove(capsuleTemplateLocation);
            }
            return deleted;
        }
        return false;
    }
}

