/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class ClearCapsuleRecipe
extends CustomRecipe {
    public ClearCapsuleRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CapsuleRecipes.CLEAR_CAPSULE_SERIALIZER.get();
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int sourceCapsule = 0;
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (this.canBeEmptyCapsule(itemstack)) {
                ++sourceCapsule;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return sourceCapsule == 1;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (!this.canBeEmptyCapsule(itemstack)) continue;
            ItemStack copy = itemstack.m_41777_();
            CapsuleItem.clearCapsule(copy);
            return copy;
        }
        return ItemStack.f_41583_;
    }

    public boolean canBeEmptyCapsule(ItemStack itemstack) {
        if (!(itemstack.m_41720_() instanceof CapsuleItem)) {
            return false;
        }
        return CapsuleItem.isLinkedStateCapsule(itemstack) || CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.DEPLOYED) && !CapsuleItem.isBlueprint(itemstack);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            nonnulllist.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
            if (!(itemstack.m_41720_() instanceof CapsuleItem) || CapsuleItem.hasState(itemstack, CapsuleItem.CapsuleState.DEPLOYED)) continue;
            ItemStack copy = itemstack.m_41777_();
            CapsuleItem.setOneUse(copy);
            nonnulllist.set(i, (Object)copy);
        }
        return nonnulllist;
    }
}

