/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleLootEntry
extends LootPoolSingletonContainer {
    public static final int DEFAULT_WEIGHT = 3;
    public static String[] COLOR_PALETTE = new String[]{"0xCCCCCC", "0x549b57", "0xe08822", "0x5e8eb7", "0x6c6c6c", "0xbd5757", "0x99c33d", "0x4a4cba", "0x7b2e89", "0x95d5e7", "0xffffff"};
    private static final Random random = new Random();
    private String templatesPath = null;

    public static LootPoolEntryContainer.Builder<?> builder(String templatePath) {
        return CapsuleLootEntry.m_79687_((p_216169_1_, p_216169_2_, p_216169_3_, p_216169_4_) -> {
            int weight = CapsuleLootEntry.findConfiguredWeight(templatePath);
            return new CapsuleLootEntry(templatePath, weight);
        });
    }

    public static int findConfiguredWeight(String path) {
        int weight = 3;
        if (Config.lootTemplatesData.containsKey(path)) {
            weight = Config.lootTemplatesData.get((Object)path).weight;
        }
        return weight;
    }

    protected CapsuleLootEntry(String templatesPath, int weightIn) {
        super(weightIn, 0, new LootItemCondition[0], new LootItemFunction[0]);
        this.templatesPath = templatesPath;
    }

    public static int getRandomColor() {
        return Integer.decode(COLOR_PALETTE[(int)(Math.random() * (double)COLOR_PALETTE.length)]);
    }

    public void m_6948_(Consumer<ItemStack> stacks, LootContext context) {
        Pair<String, CapsuleTemplate> templatePair;
        if (this.templatesPath == null) {
            return;
        }
        if (Config.lootTemplatesData.containsKey(this.templatesPath) && (templatePair = this.getRandomTemplate(context)) != null) {
            CapsuleTemplate template = (CapsuleTemplate)templatePair.getRight();
            String templatePath = (String)templatePair.getLeft();
            int size = Math.max(template.getSize().m_123341_(), Math.max(template.getSize().m_123342_(), template.getSize().m_123343_()));
            if (template.entities.isEmpty() && Config.allowBlueprintReward) {
                ItemStack capsule = Capsule.newLinkedCapsuleItemStack(templatePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, false, Capsule.labelFromPath(templatePath), 0);
                CapsuleItem.setAuthor(capsule, template.getAuthor());
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.BLUEPRINT);
                CapsuleItem.setBlueprint(capsule);
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                stacks.accept(capsule);
            } else {
                ItemStack capsule = Capsule.newRewardCapsuleItemStack(templatePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, Capsule.labelFromPath(templatePath), template.getAuthor());
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                stacks.accept(capsule);
            }
        }
    }

    @Nullable
    public Pair<String, CapsuleTemplate> getRandomTemplate(LootContext context) {
        Config.LootPathData lpd = Config.lootTemplatesData.get(this.templatesPath);
        if (lpd == null || lpd.files == null) {
            Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), Config.lootTemplatesData, context.m_78952_().m_7654_().m_177941_());
            lpd = Config.lootTemplatesData.get(this.templatesPath);
        }
        if (lpd == null || lpd.files == null || lpd.files.isEmpty()) {
            return null;
        }
        int size = lpd.files.size();
        int initRand = random.nextInt(size);
        for (int i = 0; i < lpd.files.size(); ++i) {
            int ri = (initRand + i) % lpd.files.size();
            String structureName = lpd.files.get(ri);
            CapsuleTemplate template = (CapsuleTemplate)StructureSaver.getTemplateForReward(context.m_78952_().m_7654_(), this.templatesPath + "/" + structureName).getRight();
            if (template == null) continue;
            return Pair.of((Object)(this.templatesPath + "/" + structureName), (Object)template);
        }
        return null;
    }

    public LootPoolEntryType m_6751_() {
        return LootPoolEntries.f_79621_;
    }
}

