/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.StructureSaver;
import capsule.blocks.BlockCapsuleMarker;
import capsule.helpers.Blueprint;
import capsule.helpers.MinecraftNBT;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.loot.CapsuleLootEntry;
import capsule.network.CapsuleNetwork;
import capsule.network.CapsuleUndeployNotifToClient;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Capsule {
    protected static final Logger LOGGER = LogManager.getLogger(Capsule.class);

    public static String getMirrorLabel(StructurePlaceSettings placement) {
        return switch (placement.m_74401_()) {
            case Mirror.FRONT_BACK -> ChatFormatting.STRIKETHROUGH + "[ ]";
            case Mirror.LEFT_RIGHT -> "[I]";
            default -> "[ ]";
        };
    }

    public static String getRotationLabel(StructurePlaceSettings placement) {
        return switch (placement.m_74404_()) {
            case Rotation.CLOCKWISE_90 -> "90";
            case Rotation.CLOCKWISE_180 -> "180";
            case Rotation.COUNTERCLOCKWISE_90 -> "270";
            default -> "0";
        };
    }

    public static void resentToCapsule(ItemStack capsule, ServerLevel world, @Nullable Player playerIn) {
        ResourceKey<Level> dimensionId = CapsuleItem.getDimension(capsule);
        ServerLevel capsuleWorld = world.m_7654_().m_129880_(dimensionId);
        if (capsuleWorld == null) {
            return;
        }
        if (capsule.m_41783_() == null) {
            return;
        }
        CompoundTag spawnPos = capsule.m_41783_().m_128469_("spawnPosition");
        BlockPos startPos = new BlockPos(spawnPos.m_128451_("x"), spawnPos.m_128451_("y"), spawnPos.m_128451_("z"));
        int size = CapsuleItem.getSize(capsule);
        if (CapsuleItem.isBlueprint(capsule)) {
            boolean blueprintMatch = StructureSaver.undeployBlueprint(capsuleWorld, playerIn == null ? null : playerIn.m_20148_(), capsule, startPos, size, CapsuleItem.getExcludedBlocs(capsule));
            if (blueprintMatch) {
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.BLUEPRINT);
                CapsuleItem.cleanDeploymentTags(capsule);
                if (playerIn != null) {
                    Capsule.notifyUndeploy(playerIn, startPos, size, null);
                }
            } else if (playerIn != null) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"capsule.error.blueprintDontMatch"));
            }
        } else {
            boolean storageOK;
            CapsuleTemplate template = StructureSaver.undeploy(capsuleWorld, playerIn == null ? null : playerIn.m_20148_(), capsule.m_41783_().m_128461_("structureName"), startPos, size, CapsuleItem.getExcludedBlocs(capsule), CapsuleItem.getOccupiedSourcePos(capsule));
            boolean bl = storageOK = template != null;
            if (storageOK) {
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.LINKED);
                CapsuleItem.cleanDeploymentTags(capsule);
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                CapsuleItem.setPlacement(capsule, new StructurePlaceSettings());
                if (playerIn != null) {
                    Capsule.notifyUndeploy(playerIn, startPos, size, CapsuleItem.getStructureName(capsule));
                }
            } else {
                LOGGER.error("Error occured during undeploy of capsule.");
                if (playerIn != null) {
                    playerIn.m_213846_((Component)Component.m_237115_((String)"capsule.error.technicalError"));
                }
            }
        }
    }

    private static void notifyUndeploy(Player playerIn, BlockPos startPos, int size, String templateName) {
        BlockPos center = startPos.m_7918_(size / 2, size / 2, size / 2);
        CapsuleNetwork.wrapper.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), (double)(200 + size), playerIn.m_20193_().m_46472_())), (Object)new CapsuleUndeployNotifToClient(center, playerIn.m_20183_(), size, templateName));
    }

    public static boolean deployCapsule(ItemStack capsule, BlockPos anchorBlockPos, UUID thrower, int extendLength, ServerLevel world) {
        BlockPos dest;
        boolean didSpawn = false;
        if (capsule.m_41783_() != null && capsule.m_41783_().m_128441_("deployAt")) {
            BlockPos centerDest = BlockPos.m_122022_((long)capsule.m_41783_().m_128454_("deployAt"));
            dest = centerDest.m_7918_(-extendLength, 0, -extendLength);
            capsule.m_41783_().m_128473_("deployAt");
        } else {
            dest = anchorBlockPos.m_7918_(-extendLength, 1, -extendLength);
        }
        String structureName = capsule.m_41783_().m_128461_("structureName");
        boolean result = StructureSaver.deploy(capsule, world, thrower, dest, CapsuleItem.getPlacement(capsule));
        if (result) {
            if (!CapsuleItem.isReward(capsule)) {
                CapsuleItem.saveSpawnPosition(capsule, dest, world.m_46472_().m_135782_().toString());
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.DEPLOYED);
                if (!CapsuleItem.isBlueprint(capsule)) {
                    Capsule.clearTemplate(structureName, world.m_7654_());
                }
            }
            didSpawn = true;
        } else {
            CapsuleItem.revertStateFromActivated(capsule);
        }
        return didSpawn;
    }

    public static boolean captureContentIntoCapsule(ItemStack capsule, BlockPos anchor, UUID thrower, int size, int extendLength, ServerLevel playerWorld) {
        if (anchor != null) {
            BlockPos source = anchor.m_7918_(-extendLength, 1, -extendLength);
            return Capsule.captureAtPosition(capsule, thrower, size, playerWorld, source);
        }
        CapsuleItem.revertStateFromActivated(capsule);
        Player player = playerWorld.m_46003_(thrower);
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)"capsule.error.noCaptureBase"));
        }
        return false;
    }

    public static boolean captureAtPosition(ItemStack capsule, UUID thrower, int size, ServerLevel playerWorld, BlockPos source) {
        String capsuleID;
        CapsuleTemplate template;
        boolean storageOK;
        String throwerId = "CapsuleMod";
        Player player = null;
        if (thrower != null) {
            player = playerWorld.m_46003_(thrower);
            throwerId = player.m_36316_().getName();
        }
        boolean bl = storageOK = (template = StructureSaver.undeploy(playerWorld, thrower, capsuleID = StructureSaver.getUniqueName(playerWorld, throwerId), source, size, CapsuleItem.getExcludedBlocs(capsule), null)) != null;
        if (storageOK) {
            CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.LINKED);
            CapsuleItem.setStructureName(capsule, capsuleID);
            CapsuleItem.setCanRotate(capsule, template.canRotate());
            CapsuleItem.setPlacement(capsule, new StructurePlaceSettings());
            return true;
        }
        CapsuleItem.revertStateFromActivated(capsule);
        return false;
    }

    public static void showUndeployParticules(ClientLevel world, BlockPos posFrom, BlockPos posTo, int size) {
        for (int i = 0; i < 8 * size; ++i) {
            double x = (double)posFrom.m_123341_() + 0.5 + Math.random() * (double)size - (double)size * 0.5;
            double y = (double)posFrom.m_123342_() + Math.random() * (double)size - (double)size * 0.5;
            double z = (double)posFrom.m_123343_() + 0.5 + Math.random() * (double)size - (double)size * 0.5;
            Vec3 speed = new Vec3((double)posTo.m_123341_() - x, (double)posTo.m_123342_() - y, (double)posTo.m_123343_() - z);
            double speedFactor = (double)0.1f + speed.m_82553_() * (double)0.04f;
            speed = speed.m_82541_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, speed.f_82479_ * speedFactor, speed.f_82480_ * speedFactor, speed.f_82481_ * speedFactor);
        }
    }

    public static void showDeployParticules(ServerLevel world, BlockPos blockpos, int size) {
        double d0 = (double)blockpos.m_123341_() + 0.5;
        double d1 = (double)blockpos.m_123342_() + 0.5;
        double d2 = (double)blockpos.m_123343_() + 0.5;
        world.m_8767_((ParticleOptions)ParticleTypes.f_123796_, d0, d1, d2, 8 * size, 0.5, 0.25, 0.5, 0.01 + 0.05 * (double)size);
    }

    @Nullable
    public static Map<StructureSaver.ItemStackKey, Integer> reloadBlueprint(ItemStack blueprint, ServerLevel world, Player player) {
        Map<StructureSaver.ItemStackKey, Integer> missingMaterials = Blueprint.getMaterialList(blueprint, world, player);
        if (missingMaterials == null) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237115_((String)"capsule.error.technicalError"));
            }
            return null;
        }
        IItemHandler inv = CapsuleItem.getSourceInventory(blueprint, world);
        IItemHandler inv2 = player == null ? null : (IItemHandler)player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
        Map<Integer, Integer> inv1SlotQuantityProvisions = Capsule.recordSlotQuantityProvisions(missingMaterials, inv);
        Map<Integer, Integer> inv2SlotQuantityProvisions = Capsule.recordSlotQuantityProvisions(missingMaterials, inv2);
        if (missingMaterials.size() == 0) {
            if (inv != null) {
                inv1SlotQuantityProvisions.forEach((slot, qty) -> Capsule.extractItemOrFluid(inv, slot, qty));
            }
            if (inv2 != null) {
                inv2SlotQuantityProvisions.forEach((slot, qty) -> Capsule.extractItemOrFluid(inv2, slot, qty));
            }
            CapsuleItem.setState(blueprint, CapsuleItem.CapsuleState.BLUEPRINT);
            CapsuleItem.cleanDeploymentTags(blueprint);
        } else if (player != null && player.m_7500_()) {
            CapsuleItem.setState(blueprint, CapsuleItem.CapsuleState.BLUEPRINT);
            CapsuleItem.cleanDeploymentTags(blueprint);
            missingMaterials.clear();
        }
        return missingMaterials;
    }

    public static void extractItemOrFluid(IItemHandler inv, Integer slot, Integer qty) {
        ItemStack item = inv.extractItem(slot.intValue(), qty.intValue(), false);
        ItemStack container = ForgeHooks.getCraftingRemainingItem((ItemStack)item);
        inv.insertItem(slot.intValue(), container, false);
    }

    private static Map<Integer, Integer> recordSlotQuantityProvisions(Map<StructureSaver.ItemStackKey, Integer> missingMaterials, IItemHandler inv) {
        HashMap<Integer, Integer> invSlotQuantityProvisions = new HashMap<Integer, Integer>();
        if (inv != null) {
            int size = inv.getSlots();
            for (int invSlot = 0; invSlot < size; ++invSlot) {
                ItemStack invStack = inv.getStackInSlot(invSlot);
                StructureSaver.ItemStackKey stackKey = new StructureSaver.ItemStackKey(invStack);
                Integer missing = missingMaterials.get(stackKey);
                if (missing == null || missing <= 0 || invStack.m_41613_() <= 0) continue;
                if (invStack.m_41613_() >= missing) {
                    missingMaterials.remove(stackKey);
                    invSlotQuantityProvisions.put(invSlot, missing);
                    continue;
                }
                missingMaterials.put(stackKey, missing - invStack.m_41613_());
                invSlotQuantityProvisions.put(invSlot, invStack.m_41613_());
            }
        }
        return invSlotQuantityProvisions;
    }

    public static ItemEntity throwCapsule(ItemStack capsule, Player playerIn, BlockPos destination) {
        double startPosition = playerIn.m_20186_() - 0.3 + (double)playerIn.m_20192_();
        ItemEntity ItemEntity2 = new ItemEntity(playerIn.m_20193_(), playerIn.m_20185_(), startPosition, playerIn.m_20189_(), capsule);
        ItemEntity2.m_32010_(20);
        ItemEntity2.m_32052_(playerIn.m_20148_());
        ItemEntity2.m_32064_();
        if (destination != null && capsule.m_41783_() != null) {
            capsule.m_41783_().m_128356_("deployAt", destination.m_121878_());
            Spacial.moveItemEntityToDeployPos(ItemEntity2, capsule, false);
            BlockPos playerPos = playerIn.m_20183_();
            double diffX = (double)destination.m_123341_() + 0.5 - (double)playerPos.m_123341_();
            double diffZ = (double)destination.m_123343_() + 0.5 - (double)playerPos.m_123343_();
            double flatDistance = Math.sqrt(diffX * diffX + diffZ * diffZ);
            double diffY = (double)(destination.m_123342_() - playerPos.m_123342_()) + Math.min(1.0, flatDistance / 3.0);
            double yVelocity = diffY / 10.0 - -0.19999999552965164;
            Vec3 currentMotion = ItemEntity2.m_20184_();
            ItemEntity2.m_20334_(currentMotion.f_82479_, Math.max(0.05, yVelocity), currentMotion.f_82481_);
        } else {
            float f = 0.5f;
            Vec3 playerInMotion = playerIn.m_20184_();
            ItemEntity2.m_20334_((double)(-Mth.m_14031_((float)(playerIn.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(playerIn.m_146909_() * ((float)Math.PI / 180))) * f) + playerInMotion.f_82479_, (double)(-Mth.m_14031_((float)(playerIn.m_146909_() * ((float)Math.PI / 180))) * f + 0.1f) + playerInMotion.f_82480_, (double)(Mth.m_14089_((float)(playerIn.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(playerIn.m_146909_() * ((float)Math.PI / 180))) * f) + playerInMotion.f_82481_);
        }
        playerIn.m_150109_().m_6836_(playerIn.m_150109_().f_35977_, ItemStack.f_41583_);
        playerIn.m_20193_().m_5594_(null, ItemEntity2.m_20183_(), SoundEvents.f_11687_, SoundSource.BLOCKS, 0.2f, 0.1f);
        playerIn.m_20193_().m_7967_((Entity)ItemEntity2);
        return ItemEntity2;
    }

    public static ItemStack newRewardCapsuleItemStack(String structureName, int baseColor, int materialColor, int size, @Nullable String label, @Nullable String author) {
        ItemStack capsule = Capsule.newEmptyCapsuleItemStack(baseColor, materialColor, size, false, label, null);
        CapsuleItem.setIsReward(capsule);
        CapsuleItem.setStructureName(capsule, structureName);
        CapsuleItem.setAuthor(capsule, author);
        return capsule;
    }

    public static ItemStack newLinkedCapsuleItemStack(String structureName, int baseColor, int materialColor, int size, boolean overpowered, @Nullable String label, @Nullable Integer upgraded) {
        ItemStack capsule = Capsule.newEmptyCapsuleItemStack(baseColor, materialColor, size, overpowered, label, upgraded);
        CapsuleItem.setStructureName(capsule, structureName);
        CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.LINKED);
        return capsule;
    }

    public static ItemStack newEmptyCapsuleItemStack(int baseColor, int materialColor, int size, boolean overpowered, @Nullable String label, @Nullable Integer upgraded) {
        ItemStack capsule = CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY);
        MinecraftNBT.setColor(capsule, baseColor);
        capsule.m_41700_("color", (Tag)IntTag.m_128679_((int)materialColor));
        capsule.m_41700_("size", (Tag)IntTag.m_128679_((int)size));
        if (upgraded != null) {
            capsule.m_41700_("upgraded", (Tag)IntTag.m_128679_((int)upgraded));
        }
        if (overpowered) {
            capsule.m_41700_("overpowered", (Tag)ByteTag.m_128273_((boolean)true));
        }
        if (label != null) {
            capsule.m_41700_("label", (Tag)StringTag.m_129297_((String)label));
        }
        return capsule;
    }

    public static void handleItemEntityOnGround(ItemEntity itemEntity, ItemStack capsule) {
        itemEntity.m_20334_(0.0, 0.0, 0.0);
        int size = CapsuleItem.getSize(capsule);
        int extendLength = (size - 1) / 2;
        ServerLevel itemWorld = (ServerLevel)itemEntity.m_20193_();
        if (CapsuleItem.hasStructureLink(capsule)) {
            BlockPos throwPos = Spacial.findBottomBlock(itemEntity);
            boolean deployed = Capsule.deployCapsule(capsule, throwPos, itemEntity.f_31988_, extendLength, itemWorld);
            if (deployed) {
                itemWorld.m_5594_(null, itemEntity.m_20183_(), SoundEvents.f_11687_, SoundSource.BLOCKS, 0.4f, 0.1f);
                Capsule.showDeployParticules(itemWorld, itemEntity.m_20183_(), size);
            }
            if (deployed && CapsuleItem.isOneUse(capsule)) {
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            try {
                BlockPos captureBasePosition = Spacial.findSpecificBlock(itemEntity, size + 2, BlockCapsuleMarker.class);
                BlockPos anchor = Spacial.getAnchor(captureBasePosition, itemWorld.m_8055_(captureBasePosition), size);
                boolean captured = Capsule.captureContentIntoCapsule(capsule, anchor, itemEntity.f_31988_, size, extendLength, itemWorld);
                if (captured) {
                    BlockPos center = anchor.m_7918_(0, size / 2, 0);
                    CapsuleNetwork.wrapper.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), (double)(200 + size), itemWorld.m_46472_())), (Object)new CapsuleUndeployNotifToClient(center, itemEntity.m_20183_(), size, CapsuleItem.getStructureName(capsule)));
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't capture the content into the capsule", (Throwable)e);
            }
        }
    }

    public static String labelFromPath(String path) {
        if (path.contains("/")) {
            return WordUtils.capitalize((String)path.substring(path.lastIndexOf("/") + 1).replace("_", " "));
        }
        return WordUtils.capitalize((String)path.replace("_", " "));
    }

    public static ItemStack createLinkedCapsuleFromReward(String srcStructurePath, ServerPlayer player) {
        if (player == null) {
            return ItemStack.f_41583_;
        }
        CapsuleTemplate srcTemplate = Capsule.getRewardTemplateIfExists(srcStructurePath, player.m_20194_());
        if (srcTemplate == null) {
            return ItemStack.f_41583_;
        }
        int size = Math.max(srcTemplate.getSize().m_123341_(), Math.max(srcTemplate.getSize().m_123342_(), srcTemplate.getSize().m_123343_()));
        if (size % 2 == 0) {
            ++size;
        }
        String destStructureName = StructureSaver.getUniqueName(player.m_284548_(), player.m_36316_().getName() + "-" + srcStructurePath.replace("/", "_"));
        ItemStack capsule = Capsule.newLinkedCapsuleItemStack(destStructureName, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, false, Capsule.labelFromPath(srcStructurePath), 0);
        CompoundTag srcData = new CompoundTag();
        srcTemplate.save(srcData);
        StructureSaver.duplicateTemplate(srcData, destStructureName, StructureSaver.getTemplateManager(player.m_284548_().m_7654_()), player.m_20194_());
        CapsuleItem.setCanRotate(capsule, srcTemplate.canRotate());
        return capsule;
    }

    public static CapsuleTemplate getRewardTemplateIfExists(String structurePath, MinecraftServer server) {
        CapsuleTemplateManager srcTemplatemanager = StructureSaver.getRewardManager(server.m_177941_());
        return srcTemplatemanager.getOrCreateTemplate(new ResourceLocation(structurePath));
    }

    public static boolean clearTemplate(String capsuleStructureId, MinecraftServer server) {
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(server);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return false;
        }
        CapsuleTemplate template = templatemanager.getOrCreateTemplate(new ResourceLocation(capsuleStructureId));
        if (template == null) {
            return false;
        }
        List<StructureTemplate.StructureBlockInfo> blocks = template.getPalette();
        List<StructureTemplate.StructureEntityInfo> entities = template.entities;
        blocks.clear();
        entities.clear();
        return templatemanager.writeToFile(new ResourceLocation(capsuleStructureId));
    }
}

