/*
 * Decompiled with CFR 0.152.
 */
package capsule.command;

import capsule.Config;
import capsule.StructureSaver;
import capsule.enchantments.CapsuleEnchantments;
import capsule.helpers.Capsule;
import capsule.helpers.Files;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.loot.CapsuleLootEntry;
import capsule.loot.CapsuleLootTableHook;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleCommand {
    public static List<ServerPlayer> sentUsageURL = new ArrayList<ServerPlayer>();

    public static String[] getStructuresList(ServerLevel world) {
        Path capsuleStructuresPath = world.m_7654_().m_129843_(new LevelResource("generated/capsules/structures"));
        Path minecraftStructuresPath = world.m_7654_().m_129843_(new LevelResource("generated/capsules/structures"));
        return (String[])ArrayUtils.addAll((Object[])capsuleStructuresPath.toFile().list(), (Object[])minecraftStructuresPath.toFile().list());
    }

    public static String[] getRewardsList() {
        return new File(Config.rewardTemplatesPath).list();
    }

    private static SuggestionProvider<CommandSourceStack> SUGGEST_REWARD() {
        return (__, builder) -> {
            String[] rewards = CapsuleCommand.getRewardsList();
            if (rewards == null) {
                rewards = new String[]{};
            }
            return SharedSuggestionProvider.m_82967_((String[])rewards, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSourceStack> SUGGEST_TEMPLATE() {
        return (context, builder) -> {
            String[] tpls = CapsuleCommand.getStructuresList(((CommandSourceStack)context.getSource()).m_81372_());
            if (tpls == null) {
                tpls = new String[]{};
            }
            return SharedSuggestionProvider.m_82967_((String[])tpls, (SuggestionsBuilder)builder);
        };
    }

    private static SuggestionProvider<CommandSourceStack> SUGGEST_COLORS() {
        return (context, builder) -> SharedSuggestionProvider.m_82967_((String[])CapsuleLootEntry.COLOR_PALETTE, (SuggestionsBuilder)builder);
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder capsuleCommand = Commands.m_82127_((String)"capsule");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)capsuleCommand.then(Commands.m_82127_((String)"help").executes(ctx -> {
            int count = 0;
            if (!sentUsageURL.contains(((CommandSourceStack)ctx.getSource()).m_81375_())) {
                MutableComponent msg = Component.m_237113_((String)("see Capsule commands usages at " + ChatFormatting.UNDERLINE + "https://github.com/Lythom/capsule/wiki/Commands"));
                msg.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Lythom/capsule/wiki/Commands"));
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> CapsuleCommand.lambda$register$3((Component)msg), false);
                sentUsageURL.add(((CommandSourceStack)ctx.getSource()).m_81375_());
                ++count;
            }
            Map map = dispatcher.getSmartUsage(ctx.getRootNode().getChild("capsule"), (Object)((CommandSourceStack)ctx.getSource()));
            for (String s : map.values()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("/" + s)), false);
            }
            return map.size() + count;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"giveEmpty").requires(player -> player.m_6761_(2))).executes(ctx -> CapsuleCommand.executeGiveEmpty(((CommandSourceStack)ctx.getSource()).m_81375_(), 3, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(ctx -> CapsuleCommand.executeGiveEmpty(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size"), false))).then(Commands.m_82129_((String)"overpowered", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CapsuleCommand.executeGiveEmpty(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size"), BoolArgumentType.getBool((CommandContext)ctx, (String)"overpowered"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"giveLinked").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_REWARD()).executes(ctx -> CapsuleCommand.executeGiveLinked(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"), false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CapsuleCommand.executeGiveLinked(EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"), false))).then(Commands.m_82129_((String)"withRecall", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CapsuleCommand.executeGiveLinked(EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"), BoolArgumentType.getBool((CommandContext)ctx, (String)"withRecall")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"giveBlueprint").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_REWARD()).executes(ctx -> CapsuleCommand.executeGiveBlueprint(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CapsuleCommand.executeGiveBlueprint(EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"exportHeldItem").requires(player -> player.m_6761_(2))).executes(ctx -> CapsuleCommand.executeExportHeldItem(((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"exportSeenBlock").requires(player -> player.m_6761_(2))).executes(ctx -> CapsuleCommand.executeExportSeenBlock(((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fromExistingReward").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_REWARD()).executes(ctx -> CapsuleCommand.executeFromExistingReward(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CapsuleCommand.executeFromExistingReward(EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fromStructure").requires(player -> player.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rewardTemplateName", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_TEMPLATE()).executes(ctx -> CapsuleCommand.executeFromStructure(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName")))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CapsuleCommand.executeFromStructure(EntityArgument.m_91474_((CommandContext)ctx, (String)"target"), StringArgumentType.getString((CommandContext)ctx, (String)"rewardTemplateName"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fromHeldCapsule").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"outputTemplateName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CapsuleCommand.executeFromHeldCapsule(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"outputTemplateName")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"giveRandomLoot").requires(player -> player.m_6761_(2))).executes(ctx -> CapsuleCommand.executeGiveRandomLoot(((CommandSourceStack)ctx.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CapsuleCommand.executeGiveRandomLoot(EntityArgument.m_91474_((CommandContext)ctx, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadLootList").requires(player -> player.m_6761_(2))).executes(ctx -> {
            ResourceManager resourceManager = ((CommandSourceStack)ctx.getSource()).m_81377_().m_177941_();
            Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), Config.lootTemplatesData, resourceManager);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadWhitelist").requires(player -> player.m_6761_(2))).executes(ctx -> {
            ResourceManager resourceManager = ((CommandSourceStack)ctx.getSource()).m_81377_().m_177941_();
            Files.populateAndLoadLootList(Config.getCapsuleConfigDir().toFile(), Config.lootTemplatesData, resourceManager);
            Config.starterTemplatesList = Files.populateStarters(Config.getCapsuleConfigDir().toFile(), Config.starterTemplatesPath, resourceManager);
            Config.blueprintWhitelist = Files.populateWhitelistConfig(Config.getCapsuleConfigDir().toFile(), resourceManager);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setAuthor").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"authorName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CapsuleCommand.executeSetAuthor(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"authorName")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setBaseColor").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_COLORS()).executes(ctx -> CapsuleCommand.executeSetBaseColor(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"color")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setMaterialColor").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.string()).suggests(CapsuleCommand.SUGGEST_COLORS()).executes(ctx -> CapsuleCommand.executeSetMaterialColor(((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"color")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"downloadTemplate").requires(player -> player.m_6761_(0))).executes(ctx -> CapsuleCommand.executeDownloadTemplate(((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"setYOffset").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"yOffset", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CapsuleCommand.executeSetYOffset(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"yOffset")))));
        dispatcher.register(capsuleCommand);
    }

    private static int executeDownloadTemplate(ServerPlayer getPlayerOrException) {
        return 0;
    }

    private static int executeGiveEmpty(ServerPlayer player, int size, boolean overpowered) {
        if (player != null) {
            ItemStack capsule = Capsule.newEmptyCapsuleItemStack(0xFFFFFF, 0xFFFFFF, size, overpowered, null, null);
            CapsuleCommand.giveCapsule(capsule, (Player)player);
            return 1;
        }
        return 0;
    }

    private static int executeGiveLinked(ServerPlayer player, String rewardTemplateName, boolean withRecall) {
        String templateName = rewardTemplateName.replaceAll(".nbt", "").replaceAll(".schematic", "");
        if (player != null && !StringUtil.m_14408_((String)templateName)) {
            ItemStack capsule = Capsule.createLinkedCapsuleFromReward(Config.getRewardPathFromName(templateName), player);
            if (withRecall) {
                capsule.m_41663_((Enchantment)CapsuleEnchantments.RECALL.get(), 1);
            }
            if (capsule.m_41619_()) {
                throw new CommandRuntimeException((Component)Component.m_237113_((String)("Reward Capsule " + rewardTemplateName + " not found ")));
            }
            CapsuleCommand.giveCapsule(capsule, (Player)player);
            return 1;
        }
        return 0;
    }

    private static int executeGiveBlueprint(ServerPlayer player, String rewardTemplateName) {
        String templateName = rewardTemplateName.replaceAll(".nbt", "").replaceAll(".schematic", "");
        if (player != null && !StringUtil.m_14408_((String)templateName)) {
            CapsuleTemplate srcTemplate = Capsule.getRewardTemplateIfExists(Config.getRewardPathFromName(templateName), player.m_20194_());
            if (srcTemplate != null) {
                int size = Math.max(srcTemplate.getSize().m_123341_(), Math.max(srcTemplate.getSize().m_123342_(), srcTemplate.getSize().m_123343_()));
                if (size % 2 == 0) {
                    ++size;
                }
                ItemStack capsule = Capsule.newEmptyCapsuleItemStack(3949738, 0xFFFFFF, size, false, Capsule.labelFromPath(templateName), 0);
                CapsuleItem.setState(capsule, CapsuleItem.CapsuleState.DEPLOYED);
                CapsuleItem.setBlueprint(capsule);
                String destTemplate = StructureSaver.createBlueprintTemplate(Config.getRewardPathFromName(templateName), capsule, player.m_284548_(), (Player)player);
                CapsuleItem.setStructureName(capsule, destTemplate);
                CapsuleCommand.giveCapsule(capsule, (Player)player);
            } else {
                throw new CommandRuntimeException((Component)Component.m_237113_((String)("Reward Capsule " + rewardTemplateName + " not found ")));
            }
        }
        return 0;
    }

    private static int executeGiveRandomLoot(ServerPlayer player) throws CommandRuntimeException {
        if (player != null) {
            LootParams builder = new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81412_);
            ArrayList loots = new ArrayList();
            CapsuleLootTableHook.capsulePool.m_79053_(loots::add, new LootContext.Builder(builder).m_287259_((ResourceLocation)null));
            if (loots.size() <= 0) {
                player.m_213846_((Component)Component.m_237113_((String)"No loot this time !"));
            } else {
                Iterator iterator = loots.iterator();
                if (iterator.hasNext()) {
                    ItemStack loot = (ItemStack)iterator.next();
                    CapsuleCommand.giveCapsule(loot, (Player)player);
                    return 1;
                }
            }
        }
        return 0;
    }

    private static int executeFromExistingReward(ServerPlayer player, String templateName) throws CommandRuntimeException {
        if (player != null && !StringUtil.m_14408_((String)templateName) && player.m_9236_() instanceof ServerLevel) {
            int size;
            String structurePath = Config.getRewardPathFromName(templateName);
            CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(player.m_20194_().m_177941_());
            CapsuleTemplate template = templatemanager.getOrCreateTemplate(new ResourceLocation(structurePath));
            if (template != null) {
                size = Math.max(template.getSize().m_123341_(), Math.max(template.getSize().m_123342_(), template.getSize().m_123343_()));
                if (size % 2 == 0) {
                    ++size;
                }
            } else {
                throw new CommandRuntimeException((Component)Component.m_237113_((String)("Reward Capsule \"" + templateName + "\" not found ")));
            }
            ItemStack capsule = Capsule.newRewardCapsuleItemStack(structurePath, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, Capsule.labelFromPath(templateName), template.getAuthor());
            CapsuleItem.setCanRotate(capsule, template.canRotate());
            CapsuleCommand.giveCapsule(capsule, (Player)player);
            return 1;
        }
        return 0;
    }

    private static int executeFromStructure(ServerPlayer player, String templateName) throws CommandRuntimeException {
        if (player != null && !StringUtil.m_14408_((String)templateName) && player.m_9236_() instanceof ServerLevel) {
            String path;
            CompoundTag data = new CompoundTag();
            int size = -1;
            String author = null;
            StructureTemplateManager templatemanager = player.m_284548_().m_215082_();
            Optional templateO = templatemanager.m_230407_(new ResourceLocation(path = templateName.endsWith(".nbt") ? templateName.replace(".nbt", "") : templateName));
            if (templateO.isPresent()) {
                StructureTemplate template = (StructureTemplate)templateO.get();
                size = Math.max(template.m_163801_().m_123341_(), Math.max(template.m_163801_().m_123342_(), template.m_163801_().m_123343_()));
                author = template.m_74627_();
                template.m_74618_(data);
            } else {
                CapsuleTemplateManager capsuletemplatemanager = StructureSaver.getTemplateManager(player.m_284548_().m_7654_());
                CapsuleTemplate ctemplate = capsuletemplatemanager.getOrCreateTemplate(new ResourceLocation(path));
                size = Math.max(ctemplate.getSize().m_123341_(), Math.max(ctemplate.getSize().m_123342_(), ctemplate.getSize().m_123343_()));
                author = ctemplate.getAuthor();
                ctemplate.save(data);
            }
            if (size > -1) {
                if (size % 2 == 0) {
                    ++size;
                }
                ResourceLocation destinationLocation = new ResourceLocation(Config.rewardTemplatesPath + "/" + path);
                CapsuleTemplateManager destManager = StructureSaver.getRewardManager(player.m_20194_().m_177941_());
                CapsuleTemplate destTemplate = destManager.getOrCreateTemplate(destinationLocation);
                destTemplate.load(data, destinationLocation.toString());
                destManager.writeToFile(destinationLocation);
                ItemStack capsule = Capsule.newRewardCapsuleItemStack(destinationLocation.toString(), CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, path, author);
                CapsuleItem.setCanRotate(capsule, destTemplate.canRotate());
                CapsuleCommand.giveCapsule(capsule, (Player)player);
                return 1;
            }
            throw new CommandRuntimeException((Component)Component.m_237113_((String)("Structure \"" + path + "\" not found ")));
        }
        return 0;
    }

    private static int executeFromHeldCapsule(ServerPlayer player, String templateName) throws CommandSyntaxException {
        ItemStack heldItem;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof CapsuleItem && heldItem.m_41782_()) {
            String outputName = StringUtil.m_14408_((String)templateName) ? heldItem.m_41783_().m_128461_("label") : templateName;
            if (StringUtil.m_14408_((String)outputName)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"/capsule fromHeldCapsule [outputName]. Please label the held capsule or provide an output name to be used for output template.")).create();
            }
            String destinationTemplateLocation = Config.getRewardPathFromName(outputName.toLowerCase().replace(" ", "_").replace(":", "-"));
            boolean created = StructureSaver.copyFromCapsuleTemplate(heldItem, destinationTemplateLocation, StructureSaver.getRewardManager(player.m_20194_().m_177941_()), player.m_284548_(), false, null);
            if (!created) {
                player.m_213846_((Component)Component.m_237113_((String)"Could not duplicate the capsule template. Either the source template don't exist or the destination folder dont exist."));
                return 0;
            }
            ItemStack capsule = Capsule.newRewardCapsuleItemStack(destinationTemplateLocation, CapsuleItem.getBaseColor(heldItem), CapsuleItem.getMaterialColor(heldItem), CapsuleItem.getSize(heldItem), outputName, CapsuleItem.getAuthor(heldItem));
            CapsuleItem.setCanRotate(capsule, CapsuleItem.canRotate(heldItem));
            CapsuleCommand.giveCapsule(capsule, (Player)player);
            return 1;
        }
        return 0;
    }

    private static int executeSetYOffset(ServerPlayer player, int yOffset) {
        ItemStack heldItem;
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof CapsuleItem) {
            CapsuleItem.setYOffset(heldItem, yOffset);
            return 1;
        }
        return 0;
    }

    private static int executeSetMaterialColor(ServerPlayer player, String colorAsInt) throws CommandSyntaxException {
        ItemStack heldItem;
        int color;
        try {
            color = Integer.decode(colorAsInt);
        }
        catch (NumberFormatException e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Color parameter must be a valid integer. ie. 0xCC3D2E or 123456")).create();
        }
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof CapsuleItem) {
            CapsuleItem.setMaterialColor(heldItem, color);
            return 1;
        }
        return 0;
    }

    private static int executeSetBaseColor(ServerPlayer player, String colorAsInt) throws CommandSyntaxException {
        ItemStack heldItem;
        int color = 0;
        try {
            color = Integer.decode(colorAsInt);
        }
        catch (NumberFormatException e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Color parameter must be a valid integer. ie. 0xCC3D2E or 123456")).create();
        }
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof CapsuleItem) {
            CapsuleItem.setBaseColor(heldItem, color);
            return 1;
        }
        return 0;
    }

    private static int executeSetAuthor(ServerPlayer player, String authorName) {
        ItemStack heldItem;
        if (player != null && !(heldItem = player.m_21205_()).m_41619_() && heldItem.m_41720_() instanceof CapsuleItem && heldItem.m_41782_()) {
            if (!StringUtil.m_14408_((String)authorName)) {
                heldItem.m_41783_().m_128359_("author", authorName);
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.m_284548_());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template != null && templatemanager != null) {
                    template.setAuthor(authorName);
                    templatemanager.writeToFile(new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                }
            } else {
                heldItem.m_41783_().m_128473_("author");
                Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(heldItem, player.m_284548_());
                CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
                CapsuleTemplateManager templatemanager = (CapsuleTemplateManager)templatepair.getLeft();
                if (template != null && templatemanager != null) {
                    template.setAuthor("?");
                    templatemanager.writeToFile(new ResourceLocation(CapsuleItem.getStructureName(heldItem)));
                }
            }
            return 1;
        }
        return 0;
    }

    private static int executeExportSeenBlock(ServerPlayer player) {
        if (player != null) {
            if (player.m_20194_() != null && !player.m_20194_().m_6982_()) {
                BlockHitResult rtc = Spacial.clientRayTracePreview((Player)player, Minecraft.m_91087_().m_91296_(), 50);
                if (rtc.m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos position = rtc.m_82425_();
                    BlockState state = player.m_284548_().m_8055_(position);
                    BlockEntity BlockEntity2 = player.m_284548_().m_7702_(position);
                    String BlockEntityTag = BlockEntity2 == null ? "" : "{BlockEntityTag:" + BlockEntity2.serializeNBT().toString() + "}";
                    String command = "/give @p " + ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()) + BlockEntityTag + " 1 ";
                    MutableComponent msg = Component.m_237113_((String)command);
                    player.m_213846_((Component)msg.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy to clipboard"))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, command))));
                    return 1;
                }
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"This command only works on an integrated server, not on an dedicated one"));
            }
        }
        return 0;
    }

    private static int executeExportHeldItem(ServerPlayer player) {
        ItemStack heldItem;
        if (player != null && !(heldItem = player.m_21205_()).m_41619_()) {
            String tag = heldItem.m_41782_() ? String.valueOf(heldItem.m_41783_()) : "";
            String command = "/give @p " + ForgeRegistries.ITEMS.getKey((Object)heldItem.m_41720_()) + tag + " 1 ";
            MutableComponent msg = Component.m_237113_((String)command);
            msg.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Copy/Paste from client log (click to open)")));
            msg.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, "logs/latest.log"));
            player.m_213846_((Component)msg);
            return 1;
        }
        return 0;
    }

    private static void giveCapsule(ItemStack capsule, Player player) {
        ItemEntity entity = player.m_36176_(capsule, false);
        entity.m_32061_();
        entity.m_32052_(player.m_20148_());
    }

    private static /* synthetic */ Component lambda$register$3(Component msg) {
        return msg;
    }
}

