/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import capsule.blocks.BlockCapsuleMarker;
import capsule.blocks.BlockEntityCapture;
import capsule.client.RendererUtils;
import capsule.client.render.CapsuleTemplateRenderer;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import capsule.tags.CapsuleTags;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CapsulePreviewHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, List<AABB>> currentPreview = new HashMap<String, List<AABB>>();
    public static final Map<String, CapsuleTemplate> currentFullPreview = new HashMap<String, CapsuleTemplate>();
    public static final Map<String, CapsuleTemplateRenderer> cachedFullPreview = new HashMap<String, CapsuleTemplateRenderer>();
    public static final double NS_TO_MS = 1.0E-6;
    private static int lastSize = 0;
    private static int lastColor = 0;
    private static int uncompletePreviewsCount = 0;
    private static int completePreviewsCount = 0;
    private static String uncompletePreviewsCountStructure = null;
    static double time = 0.0;
    public static ChunkRenderDispatcher dispatcher;

    @SubscribeEvent
    public static void onLevelRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.m_91087_();
            time += 1.0;
            if (mc.f_91074_ != null) {
                dispatcher = event.getLevelRenderer().m_173015_();
                CapsulePreviewHandler.tryPreviewRecall(mc.f_91074_.m_21205_(), event.getPoseStack());
                CapsulePreviewHandler.tryPreviewDeploy(mc.f_91074_, event.getPartialTick(), mc.f_91074_.m_21205_(), event.getPoseStack());
                CapsulePreviewHandler.tryPreviewLinkedInventory(mc.f_91074_, mc.f_91074_.m_21205_(), event.getPoseStack());
            }
        }
    }

    @SubscribeEvent
    public static void OnClientChatEvent(ClientChatEvent event) {
        if ("/capsule downloadTemplate".equals(event.getMessage())) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                ItemStack heldItem = mc.f_91074_.m_21205_();
                String structureName = CapsuleItem.getStructureName(heldItem);
                if (heldItem.m_41720_() instanceof CapsuleItem && structureName != null) {
                    CapsuleTemplate template = currentFullPreview.get(structureName);
                    Path path = new File("capsule_exports").toPath();
                    try {
                        Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
                    }
                    catch (IOException var19) {
                        LOGGER.error("Failed to create parent directory: {}", (Object)path);
                    }
                    try {
                        CompoundTag compoundnbt = template.save(new CompoundTag());
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
                        Path filePath = path.resolve(df.format(new Date()) + "-" + structureName + ".nbt");
                        NbtIo.m_128947_((CompoundTag)compoundnbt, (OutputStream)new DataOutputStream(new FileOutputStream(filePath.toFile())));
                        mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u2192 <minecraftInstance>/" + filePath.toString().replace("\\", "/"))));
                    }
                    catch (Throwable var21) {
                        LOGGER.error((Object)var21);
                        mc.f_91074_.m_213846_((Component)Component.m_237115_((String)"capsule.error.cantDownload"));
                    }
                } else {
                    mc.f_91074_.m_213846_((Component)Component.m_237115_((String)"capsule.error.cantDownload"));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof LocalPlayer && event.phase.equals((Object)TickEvent.Phase.START)) {
            LocalPlayer player = (LocalPlayer)event.player;
            CapsulePreviewHandler.tryPreviewCapture(player, player.m_21205_());
        }
    }

    private static boolean tryPreviewCapture(LocalPlayer player, ItemStack heldItem) {
        if (!heldItem.m_41619_()) {
            Item heldItemItem = heldItem.m_41720_();
            if (heldItemItem instanceof CapsuleItem && (CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.EMPTY) || CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.EMPTY_ACTIVATED))) {
                if (heldItem.m_41782_() && heldItem.m_41783_().m_128441_("size")) {
                    CapsulePreviewHandler.setCaptureTESizeColor(heldItem.m_41783_().m_128451_("size"), CapsuleItem.getBaseColor(heldItem), player.m_20193_());
                    return true;
                }
            } else {
                CapsulePreviewHandler.setCaptureTESizeColor(0, 0, player.m_20193_());
            }
        } else {
            CapsulePreviewHandler.setCaptureTESizeColor(0, 0, player.m_20193_());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryPreviewDeploy(LocalPlayer thePlayer, float partialTicks, ItemStack heldItemMainhand, PoseStack poseStack) {
        int size;
        BlockHitResult rtc;
        if (heldItemMainhand.m_41720_() instanceof CapsuleItem && heldItemMainhand.m_41782_() && CapsulePreviewHandler.isDeployable(heldItemMainhand) && !Strings.isNullOrEmpty((String)heldItemMainhand.m_41783_().m_128461_("structureName")) && (rtc = Spacial.clientRayTracePreview((Player)thePlayer, partialTicks, size = CapsuleItem.getSize(heldItemMainhand))) != null && rtc.m_6662_() == HitResult.Type.BLOCK) {
            int extendSize = (size - 1) / 2;
            BlockPos destOriginPos = rtc.m_82425_().m_121955_(rtc.m_82434_().m_122436_()).m_7918_(-extendSize, (int)(0.01 + (double)CapsuleItem.getYOffset(heldItemMainhand)), -extendSize);
            String structureName = heldItemMainhand.m_41783_().m_128461_("structureName");
            if (!structureName.equals(uncompletePreviewsCountStructure)) {
                uncompletePreviewsCountStructure = structureName;
                uncompletePreviewsCount = 0;
                completePreviewsCount = 0;
            }
            AABB errorBoundingBox = new AABB(0.0, 0.01, 0.0, 1.01, 1.01, 1.01);
            Map<String, List<AABB>> map = currentPreview;
            synchronized (map) {
                Map<String, CapsuleTemplate> map2 = currentFullPreview;
                synchronized (map2) {
                    boolean haveFullPreview = currentFullPreview.containsKey(structureName);
                    if (haveFullPreview && cachedFullPreview.containsKey(structureName)) {
                        CapsulePreviewHandler.DisplayFullPreview(thePlayer, heldItemMainhand, poseStack, extendSize, destOriginPos, structureName);
                    }
                    if (currentPreview.containsKey(structureName) || size == 1) {
                        CapsulePreviewHandler.DisplayWireframePreview(thePlayer, heldItemMainhand, size, rtc, extendSize, destOriginPos, structureName, errorBoundingBox, haveFullPreview, poseStack);
                    }
                }
            }
        }
    }

    private static void DisplayFullPreview(LocalPlayer thePlayer, ItemStack heldItemMainhand, PoseStack poseStack, int extendSize, BlockPos destOriginPos, String structureName) {
        CapsuleTemplate template = currentFullPreview.get(structureName);
        CapsuleTemplateRenderer renderer = cachedFullPreview.get(structureName);
        StructurePlaceSettings placement = CapsuleItem.getPlacement(heldItemMainhand);
        renderer.changeTemplateIfDirty(template, thePlayer.m_20193_(), destOriginPos, CapsuleTemplate.recenterRotation(extendSize, placement), placement, 2);
        float glitchIntensity = (float)(Math.abs(Math.cos(time * (double)0.1f)) * Math.abs(Math.cos(time * (double)0.14f)) * Math.abs(Math.cos(time * (double)0.12f))) - 0.3f;
        glitchIntensity = (float)Math.min(0.05, (double)Math.max(0.0f, glitchIntensity));
        float glitchIntensity2 = (float)(Math.cos(time * (double)0.12f) * Math.cos(time * (double)0.15f) * Math.cos(time * (double)0.14f)) * glitchIntensity;
        float glitchValue = (float)Math.min(0.12, Math.max(0.0, Math.tan(time * 0.5)));
        float glitchValuey = (float)Math.min(0.32, Math.max(0.0, Math.tan(time * 0.2)));
        float glitchValuez = (float)Math.min(0.12, Math.max(0.0, Math.tan(time * 0.8)));
        poseStack.m_85836_();
        poseStack.m_252880_(glitchIntensity2 * glitchValue, glitchIntensity * glitchValuey, glitchIntensity2 * glitchValuez);
        poseStack.m_85841_(1.0f + glitchIntensity2 * glitchValuez, 1.0f + glitchIntensity * glitchValuey, 1.0f);
        renderer.renderTemplate(poseStack, (Player)thePlayer, destOriginPos);
        poseStack.m_85849_();
    }

    public static List<RenderType> getBlockRenderTypes() {
        return ImmutableList.of((Object)RenderType.m_110466_(), (Object)RenderType.m_110463_(), (Object)RenderType.m_110457_(), (Object)RenderType.m_110451_());
    }

    private static void DisplayWireframePreview(LocalPlayer thePlayer, ItemStack heldItemMainhand, int size, BlockHitResult rtc, int extendSize, BlockPos destOriginPos, String structureName, AABB errorBoundingBox, boolean haveFullPreview, PoseStack poseStack) {
        BlockPos pos;
        List<Object> blockspos = new ArrayList();
        if (size > 1) {
            blockspos = currentPreview.get(structureName);
        } else if (CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.EMPTY)) {
            pos = rtc.m_82425_().m_121996_((Vec3i)destOriginPos);
            blockspos.add(new AABB(pos, pos));
        }
        if (blockspos.isEmpty()) {
            pos = new BlockPos(extendSize, 0, extendSize);
            blockspos.add(new AABB(pos, pos));
        }
        RendererUtils.doPositionPrologue(Minecraft.m_91087_().m_91290_().f_114358_, poseStack);
        RendererUtils.doWirePrologue();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        StructurePlaceSettings placement = CapsuleItem.getPlacement(heldItemMainhand);
        for (AABB aABB : blockspos) {
            BlockPos recenter = CapsuleTemplate.recenterRotation(extendSize, placement);
            AABB dest = CapsuleTemplate.transformedAxisAlignedBB(placement, aABB).m_82386_((double)destOriginPos.m_123341_(), (double)destOriginPos.m_123342_() + 0.01, (double)destOriginPos.m_123343_()).m_82386_((double)recenter.m_123341_(), (double)recenter.m_123342_(), (double)recenter.m_123343_()).m_82363_(1.0, 1.0, 1.0);
            int color = 0xDDDDDD;
            if (CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.EMPTY)) {
                RenderSystem.lineWidth((float)(haveFullPreview ? 2.0f : 5.0f));
                color = CapsuleItem.getBaseColor(heldItemMainhand);
            } else {
                for (double j = dest.f_82290_; j < dest.f_82293_; j += 1.0) {
                    for (double k = dest.f_82289_; k < dest.f_82292_; k += 1.0) {
                        for (double l = dest.f_82288_; l < dest.f_82291_; l += 1.0) {
                            BlockPos pos2 = BlockPos.m_274561_((double)l, (double)k, (double)j);
                            if (thePlayer.m_20193_().m_8055_(pos2).m_204336_(CapsuleTags.overridable)) continue;
                            RenderSystem.lineWidth((float)5.0f);
                            bufferBuilder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85814_);
                            RendererUtils.setColor(0xAA0000, 255);
                            RendererUtils.drawCapsuleCube(errorBoundingBox.m_82338_(pos2), bufferBuilder);
                            tessellator.m_85914_();
                        }
                    }
                }
            }
            if (haveFullPreview) continue;
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableBlend();
            bufferBuilder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85814_);
            RendererUtils.setColor(color, 160);
            RendererUtils.drawCapsuleCube(dest, bufferBuilder);
            tessellator.m_85914_();
        }
        RendererUtils.setColor(0xFFFFFF, 255);
        RendererUtils.doWireEpilogue();
        RendererUtils.doPositionEpilogue(poseStack);
    }

    private static boolean isDeployable(ItemStack heldItemMainhand) {
        return CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.ACTIVATED) || CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.ONE_USE_ACTIVATED) || CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.BLUEPRINT) || CapsuleItem.getSize(heldItemMainhand) == 1 && !CapsuleItem.hasState(heldItemMainhand, CapsuleItem.CapsuleState.DEPLOYED);
    }

    private static void tryPreviewRecall(ItemStack heldItem, PoseStack poseStack) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.m_41720_()) instanceof CapsuleItem && (CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.DEPLOYED) || CapsuleItem.hasState(heldItem, CapsuleItem.CapsuleState.BLUEPRINT)) && heldItem.m_41782_() && heldItem.m_41783_().m_128441_("spawnPosition")) {
            CapsulePreviewHandler.previewRecall(heldItem, poseStack);
        }
    }

    private static void tryPreviewLinkedInventory(LocalPlayer player, ItemStack heldItem, PoseStack poseStack) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.m_41720_()) instanceof CapsuleItem && CapsuleItem.isBlueprint(heldItem) && CapsuleItem.hasSourceInventory(heldItem)) {
            BlockPos location = CapsuleItem.getSourceInventoryLocation(heldItem);
            ResourceKey<Level> dimension = CapsuleItem.getSourceInventoryDimension(heldItem);
            if (location != null && dimension != null && dimension.equals((Object)player.m_20193_().m_46472_()) && location.m_203198_(player.m_20185_(), player.m_20186_(), player.m_20189_()) < 3600.0) {
                CapsulePreviewHandler.previewLinkedInventory(location, poseStack);
            }
        }
    }

    private static void previewLinkedInventory(BlockPos location, PoseStack poseStack) {
        RendererUtils.doPositionPrologue(Minecraft.m_91087_().m_91290_().f_114358_, poseStack);
        RendererUtils.doOverlayPrologue();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.f_85814_);
        RendererUtils.setColor(6003967, 80);
        RendererUtils.drawCube(location, 0.0f, (VertexConsumer)bufferBuilder);
        tessellator.m_85914_();
        RendererUtils.doOverlayEpilogue();
        RendererUtils.doPositionEpilogue(poseStack);
    }

    private static void previewRecall(ItemStack capsule, PoseStack poseStack) {
        if (capsule.m_41783_() == null) {
            return;
        }
        CompoundTag linkPos = capsule.m_41783_().m_128469_("spawnPosition");
        int size = CapsuleItem.getSize(capsule);
        int extendSize = (size - 1) / 2;
        int color = CapsuleItem.getBaseColor(capsule);
        Camera renderInfo = Minecraft.m_91087_().m_91290_().f_114358_;
        AABB boundingBox = Spacial.getBB(linkPos.m_128451_("x") + extendSize, linkPos.m_128451_("y") - 1, linkPos.m_128451_("z") + extendSize, size, extendSize);
        MultiBufferSource.BufferSource impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer ivertexbuilder = impl.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-renderInfo.m_90583_().f_82479_, -renderInfo.m_90583_().f_82480_, -renderInfo.m_90583_().f_82481_);
        CapsulePreviewHandler.renderRecallBox(poseStack, color, boundingBox, ivertexbuilder, time);
        impl.m_109911_();
        poseStack.m_85836_();
    }

    private static void setCaptureTESizeColor(int size, int color, Level worldIn) {
        if (size == lastSize && color == lastColor) {
            return;
        }
        for (BlockEntityCapture te : new ArrayList<BlockEntityCapture>(BlockEntityCapture.instances)) {
            CompoundTag teData;
            if (te.m_58904_() != worldIn || (teData = te.getPersistentData()).m_128451_("size") == size && teData.m_128451_("color") == color) continue;
            te.getPersistentData().m_128405_("size", size);
            te.getPersistentData().m_128405_("color", color);
            if (!te.m_58900_().m_61138_((Property)BlockCapsuleMarker.f_52660_)) continue;
            worldIn.m_7731_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)BlockCapsuleMarker.f_52660_, (Comparable)Boolean.valueOf(size <= 0)), 2);
        }
        lastSize = size;
        lastColor = color;
    }

    public static void renderRecallBox(PoseStack poseStackIn, int color, AABB boundingBox, VertexConsumer ivertexbuilder, double time) {
        float af = 0.78431374f;
        float rf = (float)(color >> 16 & 0xFF) / 255.0f;
        float gf = (float)(color >> 8 & 0xFF) / 255.0f;
        float bf = (float)(color & 0xFF) / 255.0f;
        LevelRenderer.m_109621_((PoseStack)poseStackIn, (VertexConsumer)ivertexbuilder, (double)boundingBox.f_82288_, (double)boundingBox.f_82289_, (double)boundingBox.f_82290_, (double)boundingBox.f_82291_, (double)boundingBox.f_82292_, (double)boundingBox.f_82293_, (float)rf, (float)gf, (float)bf, (float)0.78431374f, (float)rf, (float)gf, (float)bf);
        for (int i = 0; i < 5; ++i) {
            double i1 = CapsulePreviewHandler.getMovingEffectPos(boundingBox, i, time, 0.0015f);
            double i2 = CapsulePreviewHandler.getMovingEffectPos(boundingBox, i, time, 0.0017f);
            double lowI = Math.min(i1, i2);
            double highI = Math.max(i1, i2);
            LevelRenderer.m_109621_((PoseStack)poseStackIn, (VertexConsumer)ivertexbuilder, (double)boundingBox.f_82288_, (double)lowI, (double)boundingBox.f_82290_, (double)boundingBox.f_82291_, (double)highI, (double)boundingBox.f_82293_, (float)rf, (float)gf, (float)bf, (float)(0.01f + (float)i * 0.05f), (float)rf, (float)gf, (float)bf);
        }
    }

    private static double getMovingEffectPos(AABB boundingBox, int t, double incTime, float offset) {
        return boundingBox.f_82289_ + (Math.cos((double)t * incTime * (double)offset) * 0.5 + 0.5) * (boundingBox.f_82292_ - boundingBox.f_82289_);
    }
}

