/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.events;

import com.mactso.harderspawners.events.SpawnerSpawnEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerTickHandler {
    public static List<workRecord> workList = new ArrayList<workRecord>();
    private static List<WeakReference<SpawnerBlockEntity>> sbelist = new ArrayList<WeakReference<SpawnerBlockEntity>>();
    private static int ticks = 0;
    private static long hasEntriesTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        long currentTime;
        if (event.phase == TickEvent.Phase.END && --ticks <= 0) {
            ticks = 20;
            List<WeakReference<SpawnerBlockEntity>> list = sbelist;
            synchronized (list) {
                Iterator<WeakReference<SpawnerBlockEntity>> it = sbelist.iterator();
                while (it.hasNext()) {
                    SpawnerBlockEntity sbe = (SpawnerBlockEntity)it.next().get();
                    if (sbe != null && !ServerTickHandler.sbeTest(sbe)) continue;
                    it.remove();
                }
            }
        }
        if (workList.isEmpty()) {
            return;
        }
        if (hasEntriesTime == 0L) {
            hasEntriesTime = event.getServer().m_129783_().m_46467_();
        }
        if ((currentTime = event.getServer().m_129783_().m_46467_()) > hasEntriesTime) {
            for (workRecord work : workList) {
                Packet pkt;
                BlockEntity blockEntity = work.level.m_7702_(work.pos);
                if (blockEntity == null || (pkt = blockEntity.m_58483_()) == null) continue;
                LevelChunk chunk = work.level.m_46745_(work.pos);
                PacketDistributor.TRACKING_CHUNK.with(() -> chunk).send(pkt);
            }
            workList.clear();
            hasEntriesTime = 0L;
        }
    }

    public static void addClientUpdate(ServerLevel level, BlockPos pos) {
        workList.add(new workRecord(level, pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSbeWorklistEntry(SpawnerBlockEntity sbe) {
        if (Thread.currentThread().getName().equals("Render thread")) {
            return;
        }
        List<WeakReference<SpawnerBlockEntity>> list = sbelist;
        synchronized (list) {
            sbelist.add(new WeakReference<SpawnerBlockEntity>(sbe));
        }
    }

    private static boolean sbeTest(SpawnerBlockEntity sbe) {
        if (sbe.m_58901_()) {
            return true;
        }
        if (sbe.m_58898_()) {
            SpawnerSpawnEvent.updateHostileSpawnerValues((BlockEntity)sbe, sbe.m_59801_(), false);
            return true;
        }
        return false;
    }

    public record workRecord(ServerLevel level, BlockPos pos) {
    }
}

