/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.config;

import com.mactso.harderspawners.config.MobSpawnerManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="harderspawners", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    private static int debugLevel;
    private static int spawnerTextOff;
    private static int spawnerMinutesStunned;
    private static int destroyLightPercentage;
    private static int destroyLightRange;
    private static int spawnerBreakSpeedMultiplier;
    private static int spawnerRevengeLevel;
    private static int maxNearbyEntities;
    private static int requiredPlayerRange;
    private static int spawnRange;
    private static int hostileSpawnerLightLevel;
    private static int hostileSpawnerResistDaylightDuration;
    private static double spawnersExplodePercentage;
    private static String[] defaultMobBreakPercentageValues;
    private static String defaultMobBreakPercentageValues6464;

    public static void bakeConfig() {
        debugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        MyConfig.setSpawnerTextOff((Integer)MyConfig.COMMON.spawnerTextOff.get());
        spawnerMinutesStunned = (Integer)MyConfig.COMMON.spawnerMinutesStunned.get();
        MyConfig.setSpawnerBreakSpeedMultiplier((Integer)MyConfig.COMMON.spawnerBreakSpeedMultiplier.get());
        destroyLightPercentage = (Integer)MyConfig.COMMON.destroyLightPercentage.get();
        destroyLightRange = (Integer)MyConfig.COMMON.destroyLightRange.get();
        MyConfig.setSpawnersExplodePercentage((Double)MyConfig.COMMON.spawnersExplodePercentage.get());
        MyConfig.setSpawnerRevengeLevel((Integer)MyConfig.COMMON.spawnerRevengeLevel.get());
        maxNearbyEntities = (Integer)MyConfig.COMMON.maxNearbyEntities.get();
        requiredPlayerRange = (Integer)MyConfig.COMMON.requiredPlayerRange.get();
        spawnRange = (Integer)MyConfig.COMMON.spawnRange.get();
        hostileSpawnerLightLevel = (Integer)MyConfig.COMMON.hostileSpawnerLightLevel.get();
        hostileSpawnerResistDaylightDuration = (Integer)MyConfig.COMMON.hostileSpawnerResistDaylightDuration.get();
        MyConfig.setDefaultMobBreakPercentageValues6464((String)MyConfig.COMMON.defaultNoBreakMobsActual.get());
        if (debugLevel > 0) {
            System.out.println("Harder Spawners Debug: " + debugLevel);
        }
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static int getDestroyLightPercentage() {
        return destroyLightPercentage;
    }

    public static int getDestroyLightRange() {
        return destroyLightRange;
    }

    public static int getHostileSpawnerLightLevel() {
        return hostileSpawnerLightLevel;
    }

    public static int getHostileSpawnerResistDaylightDuration() {
        return hostileSpawnerResistDaylightDuration;
    }

    public static int getMaxNearbyEntities() {
        return maxNearbyEntities;
    }

    public static int getRequiredPlayerRange() {
        return requiredPlayerRange;
    }

    public static int getSpawnerMinutesStunned() {
        return spawnerMinutesStunned;
    }

    public static int getSpawnRange() {
        return spawnRange;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
            MobSpawnerManager.mobBreakPercentageInit();
        }
    }

    public static void pushDebugValue() {
        if (debugLevel > 0) {
            System.out.println("harderspawners debugLevel:" + debugLevel);
        }
        MyConfig.COMMON.debugLevel.set((Object)debugLevel);
    }

    public static void pushSpawnerRevenge() {
        if (debugLevel > 0) {
            System.out.println("harderspawners: revengeLevel" + MyConfig.getSpawnerRevengeLevel());
        }
        MyConfig.COMMON.spawnerRevengeLevel.set((Object)MyConfig.getSpawnerRevengeLevel());
    }

    public static void pushSpawnersExplodePercentage() {
        if (debugLevel > 0) {
            System.out.println("harderspawners: explode% :" + MyConfig.getSpawnersExplodePercentage());
        }
        MyConfig.COMMON.spawnersExplodePercentage.set((Object)MyConfig.getSpawnersExplodePercentage());
    }

    public static void setDebugLevel(int debugLevel) {
        MyConfig.debugLevel = debugLevel;
    }

    public static int getSpawnerBreakSpeedMultiplier() {
        return spawnerBreakSpeedMultiplier;
    }

    public static void setSpawnerBreakSpeedMultiplier(int spawnerBreakSpeedMultiplier) {
        MyConfig.spawnerBreakSpeedMultiplier = spawnerBreakSpeedMultiplier;
    }

    public static int getSpawnerRevengeLevel() {
        return spawnerRevengeLevel;
    }

    public static void setSpawnerRevengeLevel(int spawnerRevengeLevel) {
        MyConfig.spawnerRevengeLevel = spawnerRevengeLevel;
    }

    public static int getSpawnerTextOff() {
        return spawnerTextOff;
    }

    public static void setSpawnerTextOff(int spawnerTextOff) {
        MyConfig.spawnerTextOff = spawnerTextOff;
    }

    public static String getDefaultMobBreakPercentageValues6464() {
        return defaultMobBreakPercentageValues6464;
    }

    public static void setDefaultMobBreakPercentageValues6464(String defaultMobBreakPercentageValues6464) {
        MyConfig.defaultMobBreakPercentageValues6464 = defaultMobBreakPercentageValues6464;
    }

    public static String[] getDefaultMobBreakPercentageValues() {
        return defaultMobBreakPercentageValues;
    }

    public static void setDefaultMobBreakPercentageValues(String[] defaultMobBreakPercentageValues) {
        MyConfig.defaultMobBreakPercentageValues = defaultMobBreakPercentageValues;
    }

    public static double getSpawnersExplodePercentage() {
        return spawnersExplodePercentage;
    }

    public static void setSpawnersExplodePercentage(double spawnersExplodePercentage) {
        MyConfig.spawnersExplodePercentage = spawnersExplodePercentage;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.IntValue spawnerTextOff;
        public final ForgeConfigSpec.IntValue spawnerMinutesStunned;
        public final ForgeConfigSpec.IntValue destroyLightPercentage;
        public final ForgeConfigSpec.IntValue destroyLightRange;
        public final ForgeConfigSpec.IntValue spawnerBreakSpeedMultiplier;
        public final ForgeConfigSpec.IntValue spawnerRevengeLevel;
        public final ForgeConfigSpec.IntValue requiredPlayerRange;
        public final ForgeConfigSpec.IntValue maxNearbyEntities;
        public final ForgeConfigSpec.IntValue spawnRange;
        public final ForgeConfigSpec.IntValue hostileSpawnerLightLevel;
        public final ForgeConfigSpec.IntValue hostileSpawnerResistDaylightDuration;
        public final ForgeConfigSpec.DoubleValue spawnersExplodePercentage;
        public final ForgeConfigSpec.ConfigValue<String> defaultNoBreakMobsActual;
        public final String defaultNoBreakMobs6464 = "harderspawners:default,0.2;minecraft:pig,0.0;minecraft:cow,0.0;minecraft:sheep,0.0;minecraft:parrot,0.0;minecraft:blaze,0.0;";

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Harder Spawners Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("harderspawners.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.spawnerTextOff = builder.comment("0 = chat messages on, 1 = chat messages off.").translation("harderspawners.config.spawnerTextOff").defineInRange("spawnerTextOff", () -> 1, 0, 1);
            this.destroyLightPercentage = builder.comment("Chance to destroy light sources in range (0-100%)").translation("harderspawners.config.destroyLightPercentage").defineInRange("destroyLightPercentage", () -> 100, 0, 100);
            this.destroyLightRange = builder.comment("Range of light source destruction in blocks (1-7)").translation("harderspawners.config.destroyLightRange").defineInRange("destroyLightRange", () -> 7, 1, 7);
            this.spawnerMinutesStunned = builder.comment("0- spawner breaks as normal.  Values over 0 minutes stun the spawner but don't break it.").translation("harderspawners.config.spawnerMinutesStunned").defineInRange("spawnerMinutesStunned", () -> 0, 0, 27);
            this.spawnerBreakSpeedMultiplier = builder.comment("Spawner Break Speed Modifier: 0 = Off, 1 = 50% slower, From 2 to 2.1 billion times slower").translation("harderspawners.config.spawnerBreakSpeedMultiplier").defineInRange("spawnerBreakSpeedMultiplier", () -> 4, 0, Integer.MAX_VALUE);
            this.spawnerRevengeLevel = builder.comment("Spawner Revenge Level: 0 = Off, Over 1 spawner takes revenge on player.").translation("harderspawners.config.spawnerRevengeLevel").defineInRange("spawnerRevengeLevel", () -> 1, 0, 11);
            this.spawnersExplodePercentage = builder.comment("Explode percentage when Spawners Break").translation("harderspawners.config.spawnersExplodePercentage").defineInRange("spawnersExplodePercentage", () -> 33.0, 0.0, 100.0);
            this.requiredPlayerRange = builder.comment("Hostile Spawners: Player Range when hostile mobs start spawning").translation("harderspawners.config.requiredPlayerRange").defineInRange("requiredPlayerRange", () -> 13, 7, 256);
            this.maxNearbyEntities = builder.comment("Hostile Spawners: Maximum Spawned Hostile Entities").translation("harderspawners.config.maxNearbyEntities").defineInRange("maxNearbyEntities", () -> 9, 3, 256);
            this.spawnRange = builder.comment("Hostile Spawners: How far from spawner hostile mobs can spawn").translation("harderspawners.config.spawnRange").defineInRange("spawnRange", () -> 9, 4, 256);
            this.hostileSpawnerLightLevel = builder.comment("hostileSpawnerLightLevel: Maximum Light Level for Hostile Spawners").translation("harderspawners.config.hostileSpawnerLightLevel").defineInRange("hostileSpawnerLightLevel", () -> 11, 0, 15);
            this.hostileSpawnerResistDaylightDuration = builder.comment("hostileSpawnerResistDaylightDuration: give undead fire resistance (true) ").translation("harderspawners.config.hostileSpawnerResistDaylightDuration").defineInRange("hostileSpawnerResistDaylightDuration", () -> 120, 0, 9999);
            builder.pop();
            builder.push("No Break Mobs Values 6464");
            this.defaultNoBreakMobsActual = builder.comment("Trail Block String 6464").translation("harderspawners.configdefaultNoBreakMobsActual").define("defaultNoBreakMobsActual", (Object)"harderspawners:default,0.2;minecraft:pig,0.0;minecraft:cow,0.0;minecraft:sheep,0.0;minecraft:parrot,0.0;minecraft:blaze,0.0;");
            builder.pop();
        }
    }
}

