/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.capabilities;

import com.mactso.harderspawners.capabilities.CapabilitySpawner;
import com.mactso.harderspawners.capabilities.ISpawnerStatsStorage;
import com.mactso.harderspawners.capabilities.SpawnerStatsStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnerStatsStorageProvider
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    ISpawnerStatsStorage storage = new SpawnerStatsStorage();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilitySpawner.SPAWNER_STORAGE) {
            return LazyOptional.of(() -> this.storage);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        ret.m_128405_("maxSpawnDelay", this.storage.getMaxSpawnDelay());
        ret.m_128405_("minSpawnDelay", this.storage.getMinSpawnDelay());
        ret.m_128379_("stunned", this.storage.isStunned());
        return ret;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int maxSpawnDelay = nbt.m_128451_("maxSpawnDelay");
        int minSpawnDelay = nbt.m_128451_("minSpawnDelay");
        boolean stunned = nbt.m_128471_("stunned");
        this.storage.setMaxSpawnDelay(maxSpawnDelay);
        this.storage.setMinSpawnDelay(minSpawnDelay);
        this.storage.setStunned(stunned);
    }
}

