/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium;

import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.scheduling.AbstractScheduler;
import se.mickelus.mutil.scheduling.ServerScheduler;
import se.mickelus.tetracelium.TetraceliumRegistries;
import se.mickelus.tetracelium.compat.apotheosis.ApotheosisCompat;
import se.mickelus.tetracelium.compat.botania.BotaniaCompat;
import se.mickelus.tetracelium.compat.farmersdelight.FarmersDelightCompat;
import se.mickelus.tetracelium.compat.farmersdelight.provider.FarmersDelightCuttingRecipeProvider;
import se.mickelus.tetracelium.compat.twilightforest.TwilightForestCompat;
import se.mickelus.tetracelium.compat.twilightforest.effects.SapParticlePacket;
import se.mickelus.tetracelium.compat.twilightforest.effects.TwilightBoltPacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="tetracelium")
@ParametersAreNonnullByDefault
public class TetraceliumMod {
    public static final String MOD_ID = "tetracelium";
    public static PacketHandler packetHandler;
    public static AbstractScheduler serverScheduler;

    public TetraceliumMod() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)serverScheduler);
        TetraceliumRegistries.init(FMLJavaModLoadingContext.get().getModEventBus());
        if (BotaniaCompat.isLoaded.booleanValue()) {
            BotaniaCompat.init();
        }
        if (FarmersDelightCompat.isLoaded.booleanValue()) {
            FarmersDelightCompat.init();
        }
        if (TwilightForestCompat.isLoaded.booleanValue()) {
            TwilightForestCompat.init();
        }
        packetHandler = new PacketHandler(MOD_ID, "main", "1");
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        if (ApotheosisCompat.isLoaded.booleanValue()) {
            ApotheosisCompat.setup();
        }
        packetHandler.registerPacket(TwilightBoltPacket.class, TwilightBoltPacket::new);
        packetHandler.registerPacket(SapParticlePacket.class, SapParticlePacket::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        if (BotaniaCompat.isLoaded.booleanValue()) {
            BotaniaCompat.clientSetup();
        }
        if (TwilightForestCompat.isLoaded.booleanValue()) {
            TwilightForestCompat.clientInit();
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            DataGenerator gen = event.getGenerator();
            PackOutput packOutput = gen.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            dataGenerator.addProvider(true, (DataProvider)new FarmersDelightCuttingRecipeProvider(packOutput));
        }
    }

    static {
        serverScheduler = new ServerScheduler();
    }
}

