/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import com.google.common.base.Objects;
import moe.plushie.armourers_workshop.api.common.ITextureOptions;

public class TextureOptions
implements ITextureOptions {
    private long value = 0L;
    private int rotation = 0;

    public TextureOptions() {
    }

    public TextureOptions(long value) {
        this.value = value;
        this.rotation = this.opt2rot((int)value & 0xF);
    }

    public void setRotation(int rotation) {
        this.value &= 0xFFFFFFFFFFFFFFF0L;
        this.value |= (long)this.rot2opt(rotation);
        this.rotation = rotation;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    public long asLong() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureOptions that = (TextureOptions)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public String toString() {
        return String.format("[rotation=%d]", this.rotation);
    }

    private int opt2rot(int opt) {
        switch (opt) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    private int rot2opt(int rot) {
        switch (rot) {
            case 90: {
                return 1;
            }
            case 180: {
                return 2;
            }
            case 270: {
                return 3;
            }
        }
        return 0;
    }
}

