/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import java.util.Objects;
import moe.plushie.armourers_workshop.api.math.IVector2f;

public class Vector2f
implements IVector2f {
    public static Vector2f ZERO = new Vector2f();
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(IVector2f value) {
        this(value.getX(), value.getY());
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(double x, double y) {
        this((float)x, (float)y);
    }

    public static Vector2f of(long value) {
        float p1 = Float.intBitsToFloat((int)value);
        float p2 = Float.intBitsToFloat((int)(value >> 32));
        return new Vector2f(p1, p2);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    @Override
    public float getX() {
        return this.x;
    }

    protected void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    protected void setY(float y) {
        this.y = y;
    }

    public long asLong() {
        int p1 = Float.floatToRawIntBits(this.x);
        int p2 = Float.floatToRawIntBits(this.y);
        return (long)p2 << 32 | (long)p1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector2f)) {
            return false;
        }
        Vector2f vector2f = (Vector2f)o;
        return Float.compare(vector2f.x, this.x) == 0 && Float.compare(vector2f.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return String.format("(%g %g)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

