/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.registry.IRegistry;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class TypedRegistry<T>
implements IRegistry<T> {
    private static final ArrayList<TypedRegistry<?>> INSTANCES = new ArrayList();
    private final Class<?> type;
    private final ArrayList<IRegistryKey<? extends T>> entries = new ArrayList();
    private final String typeName;
    private final KeyProvider<T> keyProvider;
    private final ValueProvider<T> valueProvider;
    private final RegisterProvider<T> registerProvider;

    public TypedRegistry(String name, Class<?> type, KeyProvider<T> keyProvider, ValueProvider<T> valueProvider, RegisterProvider<T> registerProvider) {
        this.type = type;
        this.typeName = name;
        this.keyProvider = keyProvider;
        this.valueProvider = valueProvider;
        this.registerProvider = registerProvider;
        INSTANCES.add(this);
    }

    public static <T> TypedRegistry<T> create(String name, Class<?> type, final Registry<T> registry) {
        return new TypedRegistry<T>(name, type, arg_0 -> registry.m_7981_(arg_0), arg_0 -> registry.m_7745_(arg_0), new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(ResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = provider.get();
                Registry.m_122965_((Registry)registry, (ResourceLocation)registryName, value);
                return () -> value;
            }
        });
    }

    public static <T> TypedRegistry<T> factory(String name, Class<? extends T> type, final Function<ResourceLocation, T> factory) {
        return new TypedRegistry<T>(name, type, null, null, new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(ResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = factory.apply(registryName);
                return () -> value;
            }
        });
    }

    public static <T> TypedRegistry<T> map(String name, Class<? extends T> type, final BiConsumer<ResourceLocation, T> consumer) {
        return new TypedRegistry<T>(name, type, null, null, new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(ResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = provider.get();
                consumer.accept(registryName, value);
                return () -> value;
            }
        });
    }

    public static <T> TypedRegistry<T> passthrough(String name, Class<?> type) {
        return new TypedRegistry<T>(name, type, null, null, new RegisterProvider<T>(){

            @Override
            public <I extends T> Supplier<I> register(ResourceLocation registryName, Supplier<? extends I> provider) {
                Object value = provider.get();
                return () -> value;
            }
        });
    }

    public static <T> ResourceLocation findKey(T value) {
        for (TypedRegistry<?> registry : INSTANCES) {
            if (!registry.getType().isInstance(value)) continue;
            TypedRegistry registry1 = (TypedRegistry)ObjectUtils.unsafeCast(registry);
            return registry1.getKey(value);
        }
        return new ResourceLocation("air");
    }

    public static <T> Collection<IRegistryKey<? extends T>> findEntries(Class<T> clazz) {
        for (TypedRegistry<?> registry : INSTANCES) {
            if (!clazz.isAssignableFrom(registry.getType())) continue;
            TypedRegistry registry1 = (TypedRegistry)ObjectUtils.unsafeCast(registry);
            return registry1.getEntries();
        }
        return Collections.emptyList();
    }

    @Override
    public <I extends T> IRegistryKey<I> register(String name, Supplier<? extends I> provider) {
        ResourceLocation registryName = ModConstants.key(name);
        Supplier<? extends I> object = this.registerProvider.register(registryName, provider);
        Entry<? extends I> entry = Entry.of(registryName, object);
        this.entries.add(entry);
        ModLog.debug("Registering {} '{}'", this.typeName, registryName);
        return entry;
    }

    @Override
    public T getValue(ResourceLocation registryName) {
        return (T)this.valueProvider.apply(registryName);
    }

    @Override
    public ResourceLocation getKey(T object) {
        return (ResourceLocation)this.keyProvider.apply(object);
    }

    @Override
    public ArrayList<IRegistryKey<? extends T>> getEntries() {
        return this.entries;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public static interface KeyProvider<T>
    extends Function<T, ResourceLocation> {
    }

    public static interface ValueProvider<T>
    extends Function<ResourceLocation, T> {
    }

    public static interface RegisterProvider<T> {
        public <I extends T> Supplier<I> register(ResourceLocation var1, Supplier<? extends I> var2);
    }

    public static class Entry<T>
    implements IRegistryKey<T> {
        private final Supplier<T> value;
        private final ResourceLocation registryName;

        public Entry(ResourceLocation registryName, Supplier<T> value) {
            this.value = value;
            this.registryName = registryName;
        }

        public static <T> Entry<T> of(ResourceLocation registryName, Supplier<T> value) {
            return new Entry<T>(registryName, value);
        }

        public static <T extends S, S> Entry<T> cast(ResourceLocation registryName, Supplier<S> value) {
            Supplier targetValue = (Supplier)ObjectUtils.unsafeCast(value);
            return new Entry<T>(registryName, targetValue);
        }

        public static <T> Entry<T> ofValue(ResourceLocation registryName, T value) {
            return Entry.of(registryName, () -> value);
        }

        public static <T extends S, S> Entry<T> castValue(ResourceLocation registryName, S value) {
            return Entry.cast(registryName, () -> value);
        }

        @Override
        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        @Override
        public T get() {
            return this.value.get();
        }
    }
}

