/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.TextFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class TranslateUtils {
    private static final TextFormatter FORMATTER = new TextFormatter();

    public static MutableComponent formatted(String content) {
        return Component.m_237113_((String)FORMATTER.getFormattedString(content));
    }

    public static MutableComponent title(String key, Object ... args) {
        return TranslatableProvider.translatable(Component.class, FORMATTER, key, args);
    }

    public static MutableComponent subtitle(String key, Object ... args) {
        return TranslateUtils.title(key, args).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    }

    public static ArrayList<Component> subtitles(String key) {
        ArrayList<Component> results = new ArrayList<Component>();
        MutableComponent value1 = TranslateUtils.subtitle(key, new Object[0]);
        String value = value1.getString();
        if (key.equals(value)) {
            return results;
        }
        Style style = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
        for (String line : FORMATTER.getFormattedString(value).split("(\\r?\\n)|(%n)")) {
            results.add((Component)Component.m_237113_((String)line).m_6270_(style));
        }
        return results;
    }

    public static class Name {
        public static MutableComponent of(ItemOverrideType overrideType) {
            return TranslateUtils.title("itemOverrideType.armourers_workshop." + overrideType.getName(), new Object[0]);
        }

        public static MutableComponent of(SkinDocumentType documentType) {
            MutableComponent lhs = TranslateUtils.title("documentType.armourers_workshop.category." + documentType.getCategory(), new Object[0]);
            MutableComponent rhs = Name.of(documentType.getSkinType());
            return TranslateUtils.title("documentType.armourers_workshop.category", lhs, rhs);
        }

        public static MutableComponent of(ISkinType skinType) {
            if (skinType == SkinTypes.UNKNOWN) {
                return TranslateUtils.title("skinType.armourers_workshop.all", new Object[0]);
            }
            String path = skinType.getRegistryName().m_135815_();
            return TranslateUtils.title("skinType.armourers_workshop." + path, new Object[0]);
        }

        public static MutableComponent of(ISkinPartType skinPartType) {
            String path = skinPartType.getRegistryName().m_135815_();
            String key = "skinPartType.armourers_workshop." + path;
            MutableComponent text = TranslateUtils.title(key, new Object[0]);
            if (!text.getString().equals(key)) {
                return text;
            }
            ModLog.debug("missing translation text for key {}", key);
            return TranslateUtils.title("skinPartType.armourers_workshop.all.base", new Object[0]);
        }

        public static MutableComponent of(ISkinPaintType paintType) {
            String path = paintType.getRegistryName().m_135815_();
            return TranslateUtils.title("paintType.armourers_workshop." + path, new Object[0]);
        }
    }
}

