/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SliceRandomlyAccessor<T> {
    private int selectedIndex;
    private int startIndex;
    private int endIndex;
    private Provider<? extends T> selected;
    private final int count;
    private final List<Provider<? extends T>> slices;

    public SliceRandomlyAccessor(List<Provider<? extends T>> slices) {
        this.slices = this.checkOrder(slices);
        this.count = slices.size();
        if (this.count != 0) {
            this.switchSlice(0);
        }
    }

    public T get(int index) {
        return this.getSlice(index).get(index - this.startIndex);
    }

    private Provider<? extends T> getSlice(int index) {
        int cursor = this.selectedIndex;
        while (true) {
            if (index < this.startIndex) {
                --cursor;
            } else if (index >= this.endIndex) {
                ++cursor;
            } else {
                return this.selected;
            }
            if (cursor < 0 || cursor >= this.count) break;
            this.switchSlice(cursor);
        }
        throw new IndexOutOfBoundsException("Index out of range: " + index);
    }

    private void switchSlice(int selectedIndex) {
        this.selected = this.slices.get(selectedIndex);
        this.selectedIndex = selectedIndex;
        this.startIndex = this.selected.getStartIndex();
        this.endIndex = this.selected.getEndIndex();
    }

    private List<Provider<? extends T>> checkOrder(List<Provider<? extends T>> slices) {
        ArrayList<Provider<T>> sortedSlices = new ArrayList<Provider<T>>(slices);
        sortedSlices.sort(Comparator.comparingInt(Provider::getStartIndex));
        return sortedSlices;
    }

    public static interface Provider<T> {
        public T get(int var1);

        public int getStartIndex();

        public int getEndIndex();
    }
}

