/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class DataAccessor<S, T> {
    protected final IEntitySerializer<T> serializer;
    protected final Function<S, T> getter;
    protected final BiConsumer<S, T> setter;

    public DataAccessor(IEntitySerializer<T> serializer, Function<S, T> getter, BiConsumer<S, T> setter) {
        this.serializer = serializer;
        this.setter = setter;
        this.getter = getter;
    }

    public static <S, T> DataAccessor<S, Object> erased(IEntitySerializer<T> serializer, Function<S, T> getter, BiConsumer<S, T> setter) {
        DataAccessor<S, T> accessor = new DataAccessor<S, T>(serializer, getter, setter);
        return (DataAccessor)ObjectUtils.unsafeCast(accessor);
    }

    public T read(IFriendlyByteBuf buf) {
        return this.serializer.read(buf);
    }

    public void write(IFriendlyByteBuf buf, T value) {
        this.serializer.write(buf, value);
    }

    public void set(S obj, T value) {
        if (this.setter != null) {
            this.setter.accept(obj, value);
        }
    }

    public T get(S obj) {
        if (this.getter != null) {
            return this.getter.apply(obj);
        }
        return null;
    }

    public T getOrDefault(S obj, T defaultValue) {
        T value = this.get(obj);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static interface Provider<S> {
        public DataAccessor<S, Object> getAccessor();

        default public <T> void set(S obj, T value) {
            this.getAccessor().set(obj, value);
        }

        default public <T> T get(S obj) {
            Object value = this.getAccessor().get(obj);
            if (value != null) {
                return ObjectUtils.unsafeCast(value);
            }
            return null;
        }

        default public <T> T getOrDefault(S obj, T defaultValue) {
            T value = this.get(obj);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
    }
}

