/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;
import moe.plushie.armourers_workshop.library.data.SkinLibraryLoader;
import moe.plushie.armourers_workshop.library.network.UpdateLibraryFilePacket;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SkinLibrary
implements ISkinLibrary {
    private static final Executor workThread = ThreadUtils.newFixedThreadPool(1, "AW-SKIN/L-LD");
    protected final File basePath;
    protected final DataDomain domain;
    protected final ArrayList<ISkinLibraryListener> listeners = new ArrayList();
    protected boolean isReady = false;
    protected boolean isLoading = false;
    protected String rootPath = "/";
    protected ArrayList<SkinLibraryFile> files = new ArrayList();

    public SkinLibrary(DataDomain domain, File path) {
        this.domain = domain;
        this.basePath = path;
    }

    public void addListener(ISkinLibraryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISkinLibraryListener listener) {
        this.listeners.remove(listener);
    }

    public void reload() {
        ModLog.debug("reload {} library", this.domain.namespace());
        if (this.basePath != null && !this.isLoading) {
            this.beginLoading();
            workThread.execute(new SkinLibraryLoader(this, this.basePath, null));
        }
    }

    public void reset() {
        ModLog.debug("clear {} library", this.domain.namespace());
        this.files = new ArrayList();
        this.isLoading = false;
        this.isReady = false;
    }

    public void beginLoading() {
        this.isLoading = true;
    }

    public void endLoading() {
        this.isLoading = false;
    }

    public SkinLibraryFile get(String rootPath) {
        for (SkinLibraryFile file : this.files) {
            if (!file.getPath().equals(rootPath)) continue;
            return file;
        }
        return null;
    }

    public void save(String path, Skin skin) {
        File file = new File(this.basePath, SkinFileUtils.normalize(path));
        if (file.exists() && !SkinFileUtils.deleteQuietly(file)) {
            ModLog.error("Can't remove file '{}'", file);
            return;
        }
        ModLog.debug("Save file '{}'", file);
        SkinFileStreamUtils.saveSkinToFile(file, skin);
        this.reload();
    }

    public void mkdir(String path) {
        if (this.basePath == null) {
            return;
        }
        File file = new File(this.basePath, SkinFileUtils.normalize(path));
        if (!file.mkdirs()) {
            ModLog.error("can't make new folder '{}'", file);
            return;
        }
        ModLog.debug("create '{}' folder", path);
        this.reload();
    }

    public void delete(SkinLibraryFile libraryFile) {
        if (this.basePath == null) {
            return;
        }
        File file = new File(this.basePath, SkinFileUtils.normalize(libraryFile.getPath()));
        if (!SkinFileUtils.deleteQuietly(file)) {
            ModLog.error("can't remove file '{}'", file);
            return;
        }
        if (libraryFile.isDirectory()) {
            ModLog.debug("remove '{}' folder and contents", libraryFile.getPath());
        } else {
            ModLog.debug("remove '{}' file", libraryFile.getPath());
        }
        this.reload();
    }

    public void rename(SkinLibraryFile libraryFile, String path) {
        if (this.basePath == null) {
            return;
        }
        File file = new File(this.basePath, SkinFileUtils.normalize(libraryFile.getPath()));
        File targetFile = new File(this.basePath, SkinFileUtils.normalize(path));
        if (targetFile.exists() && !SkinFileUtils.deleteQuietly(targetFile)) {
            ModLog.error("can't remove file '{}'", file);
            return;
        }
        if (!file.renameTo(targetFile)) {
            ModLog.error("can't rename file '{}'", file);
            return;
        }
        ModLog.debug("move '{}' to '{}'", libraryFile.getPath(), path);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadFiles(ArrayList<SkinLibraryFile> files) {
        ArrayList<ISkinLibraryListener> listeners;
        ArrayList<SkinLibraryFile> oldFiles = this.files;
        SkinLibrary skinLibrary = this;
        synchronized (skinLibrary) {
            this.files = files;
            this.isReady = true;
            listeners = new ArrayList<ISkinLibraryListener>(this.listeners);
        }
        Difference difference = new Difference();
        difference.added.addAll(files);
        difference.removed.addAll(oldFiles);
        block3: for (SkinLibraryFile newFile : files) {
            for (SkinLibraryFile oldFile : oldFiles) {
                if (!oldFile.isSameFile(newFile)) continue;
                difference.added.remove(newFile);
                difference.removed.remove(oldFile);
                if (oldFile.getLastModified() == newFile.getLastModified()) continue block3;
                difference.changed.add((Pair<ISkinLibrary.Entry, ISkinLibrary.Entry>)Pair.of((Object)oldFile, (Object)newFile));
                continue block3;
            }
        }
        listeners.forEach(listener -> listener.libraryDidReload(this));
        listeners.forEach(listener -> listener.libraryDidChanges(this, difference));
    }

    public ArrayList<SkinLibraryFile> search(String keyword, ISkinType skinType, String rootPath) {
        Object fixedRootPath = rootPath;
        ArrayList<SkinLibraryFile> files = new ArrayList<SkinLibraryFile>();
        if (keyword != null) {
            keyword = keyword.toLowerCase();
        }
        if (!rootPath.equals("/")) {
            fixedRootPath = rootPath + "/";
        }
        ArrayList<SkinLibraryFile> removedChildDirs = new ArrayList<SkinLibraryFile>();
        for (SkinLibraryFile file : this.getFiles()) {
            boolean isChild = file.isChildDirectory((String)fixedRootPath);
            boolean isMatches = file.matches(keyword, skinType);
            if (isMatches && isChild) {
                files.add(file);
                continue;
            }
            if (isMatches) {
                String path = file.getPath();
                removedChildDirs.removeIf(dir -> path.startsWith(dir.getPath()) && files.add((SkinLibraryFile)dir));
                continue;
            }
            if (!isChild || !file.isDirectory()) continue;
            removedChildDirs.add(file);
        }
        Collections.sort(files);
        if (!rootPath.equals(this.rootPath)) {
            files.add(0, new SkinLibraryFile(this.domain, "..", SkinFileUtils.normalizeNoEndSeparator(rootPath + "/..", true)));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SkinLibraryFile> getFiles() {
        SkinLibrary skinLibrary = this;
        synchronized (skinLibrary) {
            return this.files;
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public String getNamespace() {
        return this.domain.namespace();
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void markBaseDir() {
        if (this.basePath.exists()) {
            return;
        }
        try {
            SkinFileUtils.forceMkdir(this.basePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Difference
    implements ISkinLibrary.Difference {
        final ArrayList<ISkinLibrary.Entry> added = new ArrayList();
        final ArrayList<ISkinLibrary.Entry> removed = new ArrayList();
        final ArrayList<Pair<ISkinLibrary.Entry, ISkinLibrary.Entry>> changed = new ArrayList();

        @Override
        public Collection<ISkinLibrary.Entry> getAddedChanges() {
            return this.added;
        }

        @Override
        public Collection<ISkinLibrary.Entry> getRemovedChanges() {
            return this.removed;
        }

        @Override
        public Collection<Pair<ISkinLibrary.Entry, ISkinLibrary.Entry>> getUpdatedChanges() {
            return this.changed;
        }
    }

    public static class Proxy
    extends SkinLibrary {
        public Proxy(DataDomain domain) {
            super(domain, null);
        }

        @Override
        public void reload() {
            this.send(UpdateLibraryFilePacket.Mode.RELOAD, null, null);
        }

        @Override
        public void mkdir(String path) {
            this.send(UpdateLibraryFilePacket.Mode.MKDIR, null, path);
        }

        @Override
        public void rename(SkinLibraryFile file, String path) {
            this.send(UpdateLibraryFilePacket.Mode.RENAME, file.getPath(), path);
        }

        @Override
        public void delete(SkinLibraryFile file) {
            this.send(UpdateLibraryFilePacket.Mode.DELETE, null, file.getPath());
        }

        private void send(UpdateLibraryFilePacket.Mode mode, String source, String destination) {
            UpdateLibraryFilePacket packet = new UpdateLibraryFilePacket(mode, source, destination);
            NetworkManager.sendToServer(packet);
        }
    }
}

