/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.library.data.impl.MinecraftAuth;
import moe.plushie.armourers_workshop.library.data.impl.ReportFilter;
import moe.plushie.armourers_workshop.library.data.impl.ReportResult;
import moe.plushie.armourers_workshop.library.data.impl.SearchColumnType;
import moe.plushie.armourers_workshop.library.data.impl.SearchOrderType;
import moe.plushie.armourers_workshop.library.data.impl.SearchResult;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermission;
import moe.plushie.armourers_workshop.library.data.impl.ServerPermissions;
import moe.plushie.armourers_workshop.library.data.impl.ServerRequest;
import moe.plushie.armourers_workshop.library.data.impl.ServerSession;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.library.data.impl.ServerStatus;
import moe.plushie.armourers_workshop.library.data.impl.ServerToken;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GlobalSkinLibrary
extends ServerSession {
    private static final int TOKEN_UPDATE_TIME = 60000;
    private static final GlobalSkinLibrary INSTANCE = new GlobalSkinLibrary();
    private State state = new State(new ArrayList<String>());

    public static GlobalSkinLibrary getInstance() {
        return INSTANCE;
    }

    public void executor(Executor executor) {
        this.notifier = executor;
    }

    public void connect(GameProfile profile, Consumer<Exception> consumer) {
        this.resolveState();
        if (this.state.connecting || this.state.connected) {
            return;
        }
        this.state.currentUser = new ServerUser(profile.getId(), profile.getName());
        if (!this.isValidJavaVersion()) {
            this.state.connected = true;
            return;
        }
        this.state.connecting = true;
        this.request("/connect", this.a2m("uuid", profile.getId()), ServerUser::fromJSON, (result, exception) -> {
            this.state.connecting = false;
            this.state.connected = true;
            this.updateUser((ServerUser)result);
        });
    }

    public void disconnect() {
        this.state = new State(new ArrayList<String>());
    }

    public void auth() throws Exception {
        ServerUser user = this.getUser();
        if (user.isAuthenticated()) {
            return;
        }
        HashMap<String, Object> parameters = this.authenticationFromMinecraft();
        ServerToken accessToken = this.request("/user/auth", parameters, ServerToken::new);
        user.setAccessToken(accessToken);
    }

    public void auth2() {
        ServerToken accessToken = this.getUser().getAccessToken();
        if (accessToken == null || accessToken.getRemainingTime() < 0L || accessToken.getRemainingTime() > 60000L || this.state.updatingToken) {
            return;
        }
        ModLog.debug("Getting new token. Time left: {}", accessToken.getRemainingTime() / 1000L);
        this.state.updatingToken = true;
        this.request("/user/auth2", null, ServerToken::new, (result, exception) -> {
            this.state.updatingToken = false;
            if (result != null) {
                this.getUser().setAccessToken((ServerToken)result);
            }
        });
    }

    public void join(IResultHandler<Void> handlerIn) {
        this.submit(handlerIn, handlerOut -> {
            try {
                HashMap<String, Object> parameters = this.authenticationFromMinecraft();
                this.request("/user/join", parameters, o -> o);
                this.updateUser(this.request("/connect", this.a2m("uuid", parameters.get("uuid")), ServerUser::fromJSON));
                handlerOut.accept(null);
            }
            catch (Exception exception1) {
                handlerOut.throwing(exception1);
            }
        });
    }

    public void searchSkin(String keyword, int pageIndex, int pageSize, SearchColumnType searchOrderColumn, SearchOrderType searchOrder, ISkinType searchType, IResultHandler<SearchResult> handler) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("search", keyword);
        parameters.put("pageIndex", pageIndex);
        parameters.put("pageSize", pageSize);
        parameters.put("searchTypes", this.buildSearchTypes(searchType));
        if (searchOrderColumn != null) {
            parameters.put("searchOrderColumn", searchOrderColumn.toString().toLowerCase());
        }
        if (searchOrder != null) {
            parameters.put("searchOrder", searchOrder.toString());
        }
        this.request("/skin/search", parameters, SearchResult::fromJSON, handler);
    }

    public void getUserSkinList(String userId, int pageIndex, int pageSize, ISkinType searchType, IResultHandler<SearchResult> handler) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("userId", userId);
        parameters.put("pageIndex", pageIndex);
        parameters.put("pageSize", pageSize);
        parameters.put("searchTypes", this.buildSearchTypes(searchType));
        this.request("/skin/user", parameters, SearchResult::fromJSON, handler);
    }

    public void getSkin(String skinId, IResultHandler<ServerSkin> handler) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("skinid", skinId);
        parameters.put("searchTypes", this.buildSearchTypes(SkinTypes.UNKNOWN));
        this.request("/skin/info", parameters, SearchResult::fromJSON, (result, exception) -> {
            if (result != null) {
                if (!result.getSkins().isEmpty()) {
                    handler.accept(result.getSkins().get(0));
                } else {
                    handler.throwing(new RuntimeException("can't found the skin " + skinId));
                }
            } else {
                handler.throwing(exception);
            }
        });
    }

    public void uploadSkin(String name, String desc, Skin skin, IResultHandler<Void> handler) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", name);
        parameters.put("description", desc);
        parameters.put("fileToUpload", new ServerRequest.MultipartFormFile(name, () -> {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
            byte[] fileBytes = outputStream.toByteArray();
            StreamUtils.closeQuietly(outputStream);
            return Unpooled.wrappedBuffer((byte[])fileBytes);
        }));
        this.request("/skin/upload", parameters, null, handler);
    }

    public InputStream downloadPreviewSkin(String skinId) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("skinid", skinId);
        parameters.put("skinFileName", "");
        return this.buildTask("/skin/preview", parameters).call();
    }

    public InputStream downloadSkin(String skinId) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("skinid", skinId);
        parameters.put("skinFileName", "");
        return this.buildTask("/skin/download", parameters).call();
    }

    public void downloadSkin(String skinId, File target, IResultHandler<File> handlerIn) {
        this.submit(handlerIn, handlerOut -> {
            try {
                InputStream inputStream = this.downloadSkin(skinId);
                SkinFileUtils.copyInputStreamToFile(inputStream, target);
                handlerOut.accept(target);
            }
            catch (Exception exception) {
                handlerOut.throwing(exception);
            }
        });
    }

    public void getUser(String userId, IResultHandler<ServerUser> handler) {
        this.request("/user/info", this.a2m("userId", userId), ServerUser::fromJSON, handler);
    }

    public void getReportList(int pageIndex, int pageSize, ReportFilter filter, IResultHandler<ReportResult> handler) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("page", pageIndex);
        parameters.put("size", pageSize);
        parameters.put("filter", filter.toString().toLowerCase());
        this.request("/skin/reports", parameters, ReportResult::fromJSON, handler);
    }

    public void getServerStatus(IResultHandler<ServerStatus> handler) {
        this.request("/stats", null, ServerStatus::new, handler);
    }

    @Override
    protected void checkRequest(ServerRequest request, @Nullable Map<String, ?> parameters) throws Exception {
        ServerUser user = this.getUser();
        ServerPermission permission = this.resolvePermission(request, parameters);
        if (permission != null && !user.hasPermission(permission)) {
            throw new RuntimeException("insufficient permissions");
        }
        if (request.has("accessToken")) {
            this.auth();
        }
    }

    @Override
    protected HashMap<String, Object> defaultParameters() {
        HashMap<String, Object> parameters = super.defaultParameters();
        ServerUser user = this.getUser();
        ServerToken accessToken = user.getAccessToken();
        parameters.put("maxFileVersion", 13);
        if (user.getId() != null) {
            parameters.put("userId", user.getId());
        }
        if (accessToken != null && accessToken.getValue() != null) {
            parameters.put("accessToken", accessToken.getValue());
        }
        return parameters;
    }

    @Override
    protected ArrayList<String> getBaseURLs() {
        ArrayList<String> customURLs = ModConfig.Common.customSkinServerURLs;
        if (!customURLs.isEmpty()) {
            return customURLs;
        }
        return super.getBaseURLs();
    }

    public ServerUser getUser() {
        return this.state.currentUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ServerUser getUserById(String userId) {
        HashMap<String, ServerUser> hashMap = this.state.users;
        synchronized (hashMap) {
            ServerUser user = this.state.users.get(userId);
            if (user != null) {
                return user;
            }
        }
        ServerUser user = new ServerUser(userId, UUID.randomUUID(), "", ServerPermissions.NO_LOGIN);
        this.state.users.put(userId, user);
        if (!this.state.downloaded.contains(userId)) {
            this.state.downloaded.add(userId);
            this.getUser(userId, (realUser, exception) -> {
                HashMap<String, ServerUser> hashMap = this.state.users;
                synchronized (hashMap) {
                    this.state.users.put(userId, (ServerUser)realUser);
                }
            });
        }
        return user;
    }

    public boolean isConnected() {
        return this.state.connected;
    }

    public boolean isValidJavaVersion() {
        String[] javaVersion = this.getJavaVersion();
        int[] targetVersion = new int[]{8, 0, 101};
        for (int i = 0; i < javaVersion.length || i < targetVersion.length; ++i) {
            int sv = 0;
            int dv = 0;
            if (i < javaVersion.length) {
                try {
                    sv = Integer.parseInt(javaVersion[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i < targetVersion.length) {
                dv = targetVersion[i];
            }
            if (sv < dv) {
                return false;
            }
            if (sv <= dv) continue;
            return true;
        }
        return true;
    }

    public String[] getJavaVersion() {
        try {
            String[] version = System.getProperty("java.version").split("[._]");
            if (Objects.equals(version[0], "1")) {
                return Arrays.copyOfRange(version, 1, version.length);
            }
            return version;
        }
        catch (Exception exception) {
            return new String[]{"6", "0"};
        }
    }

    private String buildSearchTypes(ISkinType skinType) {
        if (skinType != null && skinType != SkinTypes.UNKNOWN) {
            return skinType.getRegistryName().toString();
        }
        StringBuilder searchTypesBuilder = new StringBuilder();
        for (ISkinType skinType1 : SkinTypes.values()) {
            ResourceLocation registryName = skinType1.getRegistryName();
            if (skinType1 == SkinTypes.UNKNOWN || registryName == null) continue;
            if (searchTypesBuilder.length() != 0) {
                searchTypesBuilder.append(";");
            }
            searchTypesBuilder.append(registryName);
        }
        return searchTypesBuilder.toString();
    }

    private HashMap<String, Object> authenticationFromMinecraft() {
        ServerUser user = this.getUser();
        String serverId = String.valueOf(this.defaultBaseURL().hashCode());
        if (!MinecraftAuth.checkAndRefeshAuth(serverId)) {
            Exception error = MinecraftAuth.getLastError();
            ModLog.debug("MC Auth Failed", new Object[0]);
            error.printStackTrace();
            throw new RuntimeException(error.getMessage());
        }
        ModLog.debug("MC Auth Done", new Object[0]);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", user.getName());
        parameters.put("uuid", user.getUUID());
        parameters.put("serverId", serverId);
        return parameters;
    }

    private Map<String, Object> a2m(String m, Object o) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(m, o);
        return map;
    }

    private void updateUser(ServerUser user) {
        if (user != null) {
            this.state.currentUser = user;
            this.state.users.put(user.getId(), user);
        }
    }

    private ServerPermission resolvePermission(ServerRequest request, @Nullable Map<String, ?> parameters) {
        ServerUser user = this.getUser();
        ServerPermission permission = request.getPermission();
        Object value = null;
        if (parameters != null) {
            value = parameters.get("skinOwner");
        }
        if (value == null || user.getId().equals(value)) {
            return permission;
        }
        switch (permission) {
            case SKIN_OWNER_DELETE: {
                return ServerPermission.SKIN_MOD_DELETE;
            }
            case SKIN_OWNER_EDIT: {
                return ServerPermission.SKIN_MOD_EDIT;
            }
        }
        return permission;
    }

    private void resolveState() {
        ArrayList<String> customURLs = ModConfig.Common.customSkinServerURLs;
        if (!customURLs.equals(this.state.hosts)) {
            this.state = new State(customURLs);
        }
    }

    private static class State {
        ServerUser currentUser = new ServerUser(UUID.randomUUID(), "");
        boolean updatingToken = false;
        boolean connecting = false;
        boolean connected = false;
        final HashMap<String, ServerUser> users = new HashMap();
        final HashSet<String> downloaded = new HashSet();
        final ArrayList<String> hosts;

        private State(ArrayList<String> hosts) {
            this.hosts = hosts;
        }
    }
}

