/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge;

import java.io.File;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeEnvironment;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.forge.builder.ConfigBuilderImpl;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class EnvironmentManagerImpl {
    private static MinecraftServer CURRENT_SERVER;

    public static String getVersion() {
        IModFileInfo fileInfo = AbstractForgeEnvironment.getModFileById("armourers_workshop");
        if (fileInfo != null && fileInfo.getMods().size() != 0) {
            ArtifactVersion version = ((IModInfo)fileInfo.getMods().get(0)).getVersion();
            return version.toString();
        }
        return "Unknown";
    }

    public static EnvironmentType getEnvironmentType() {
        if (AbstractForgeEnvironment.dist.isDedicatedServer()) {
            return EnvironmentType.SERVER;
        }
        return EnvironmentType.CLIENT;
    }

    public static MinecraftServer getServer() {
        return CURRENT_SERVER;
    }

    public static File getRootDirectory() {
        return new File(AbstractForgeEnvironment.GAMEDIR.get().toFile(), "armourers_workshop");
    }

    public static boolean isDevelopment() {
        return !AbstractForgeEnvironment.production;
    }

    public static IConfigSpec getClientConfigSpec() {
        return ConfigBuilderImpl.createClientSpec();
    }

    public static IConfigSpec getCommonConfigSpec() {
        return ConfigBuilderImpl.createCommonSpec();
    }

    public static void attach(MinecraftServer server) {
        CURRENT_SERVER = server;
    }

    public static void detach(MinecraftServer server) {
        CURRENT_SERVER = null;
    }

    public static boolean isInstalled(String modId) {
        return AbstractForgeEnvironment.getModFileById(modId) != null;
    }
}

