/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGRect;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.skin.ISkinEquipmentType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.event.client.ItemTooltipEvent;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.Strings;

@OnlyIn(value=Dist.CLIENT)
public class ItemTooltipManager {
    public static ArrayList<Component> createSkinInfo(BakedSkin bakedSkin) {
        Skin skin = bakedSkin.getSkin();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (Strings.isNotBlank((String)skin.getCustomName().trim())) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinName", skin.getCustomName().trim()));
        }
        if (Strings.isNotBlank((String)skin.getAuthorName())) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinAuthor", skin.getAuthorName().trim()));
        }
        tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinType", TranslateUtils.Name.of(skin.getType())));
        return tooltip;
    }

    public static ArrayList<Component> createSkinTooltip(ItemStack itemStack) {
        boolean isItemOwner = itemStack.m_150930_((Item)ModItems.SKIN.get());
        ArrayList<Component> tooltip = new ArrayList<Component>();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            if (isItemOwner) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinInvalidItem", new Object[0]));
            }
            return tooltip;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.TOOLTIP);
        if (bakedSkin == null) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skindownloading", descriptor.getIdentifier()));
            return tooltip;
        }
        Skin skin = bakedSkin.getSkin();
        SkinOptions options = descriptor.getOptions();
        SkinUsedCounter counter = bakedSkin.getUsedCounter();
        if (!isItemOwner) {
            if (options.contains(SkinOptions.TooltipFlags.HAS_SKIN)) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.hasSkin", new Object[0]));
            }
            if (options.contains(SkinOptions.TooltipFlags.NAME) && Strings.isNotBlank((String)skin.getCustomName())) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinName", skin.getCustomName().trim()));
            }
        }
        if (isItemOwner && options.contains(SkinOptions.TooltipFlags.FLAVOUR) && Strings.isNotBlank((String)skin.getFlavourText())) {
            tooltip.add((Component)TranslateUtils.title("item.armourers_workshop.rollover.flavour", skin.getFlavourText().trim()));
        }
        if (options.contains(SkinOptions.TooltipFlags.AUTHOR) && Strings.isNotBlank((String)skin.getAuthorName())) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinAuthor", skin.getAuthorName().trim()));
        }
        if (options.contains(SkinOptions.TooltipFlags.TYPE)) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinType", TranslateUtils.Name.of(skin.getType())));
        }
        if (!isItemOwner && options.contains(SkinOptions.TooltipFlags.FLAVOUR) && Strings.isNotBlank((String)skin.getFlavourText())) {
            tooltip.add((Component)TranslateUtils.title("item.armourers_workshop.rollover.flavour", skin.getFlavourText().trim()));
        }
        if (ModDebugger.tooltip && !Screen.m_96638_()) {
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinHoldShiftForInfo", new Object[0]));
        }
        if (ModDebugger.tooltip && Screen.m_96638_()) {
            String totals = String.format("%d/%d/%d/%d", counter.getCubeTotal(SkinCubeTypes.SOLID), counter.getCubeTotal(SkinCubeTypes.GLOWING), counter.getCubeTotal(SkinCubeTypes.GLASS), counter.getCubeTotal(SkinCubeTypes.GLASS_GLOWING));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinIdentifier", descriptor.getIdentifier()));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinTotalCubes", totals));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinDyeCount", counter.getDyeTotal()));
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinMarkerCount", counter.getMarkerTotal()));
            if (skin.getPaintData() != null) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinPaintData", "64x32"));
            }
            if (ModDebugger.properties && !skin.getProperties().isEmpty()) {
                tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinProperties", new Object[0]));
                for (String prop : skin.getProperties().getPropertiesList()) {
                    tooltip.add((Component)Component.m_237113_((String)(" " + prop)));
                }
            }
        }
        if (options.contains(SkinOptions.TooltipFlags.OPEN_WARDROBE) && isItemOwner && skin.getType() instanceof ISkinEquipmentType) {
            Component keyName = ModKeyBindings.OPEN_WARDROBE_KEY.getKeyName();
            tooltip.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.skinOpenWardrobe", keyName));
        }
        return tooltip;
    }

    public static void gatherSkinTooltip(ItemTooltipEvent.Gather event) {
        ItemStack itemStack = event.getItemStack();
        ArrayList<Component> newTooltips = ItemTooltipManager.createSkinTooltip(itemStack);
        if (newTooltips.isEmpty()) {
            return;
        }
        List<Component> tooltips = event.getTooltips();
        if (event.getContext().getFlags().m_7050_()) {
            String registryName = TypedRegistry.findKey(itemStack.m_41720_()).toString();
            for (int index = tooltips.size(); index > 0; --index) {
                Component text = tooltips.get(index - 1);
                if (!registryName.equals(text.getString())) continue;
                tooltips.addAll(index - 1, newTooltips);
                return;
            }
        }
        tooltips.addAll(newTooltips);
    }

    public static void renderSkinTooltip(ItemTooltipEvent.Render event) {
        float dy;
        float dx;
        if (!ModConfig.Client.skinPreEnabled) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinOptions options = descriptor.getOptions();
        if (!options.contains(SkinOptions.TooltipFlags.PREVIEW)) {
            return;
        }
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.TOOLTIP);
        if (bakedSkin == null) {
            return;
        }
        CGRect frame = event.getFrame();
        CGGraphicsContext context = event.getContext();
        float screenHeight = event.getScreenHeight();
        float screenWidth = event.getScreenWidth();
        float size = ModConfig.Client.skinPreSize;
        if (ModConfig.Client.skinPreLocFollowMouse) {
            dx = frame.getX() - 28.0f - size;
            dy = frame.getY() - 4.0f;
            if (frame.getX() < context.state().mousePos().getX()) {
                dx = frame.getX() + frame.getWidth() + 28.0f;
            }
            dy = MathUtils.clamp(dy, 0.0f, screenHeight - size);
        } else {
            dx = MathUtils.ceil((double)(screenWidth - size) * ModConfig.Client.skinPreLocHorizontal);
            dy = MathUtils.ceil((double)(screenHeight - size) * ModConfig.Client.skinPreLocVertical);
        }
        if (ModConfig.Client.skinPreDrawBackground) {
            context.drawTilableImage(ModTextures.GUI_PREVIEW, dx, dy, size, size, 0.0f, 0.0f, 62.0f, 62.0f, 4.0f, 4.0f, 4.0f, 4.0f, 400.0f);
        }
        ColorScheme colorScheme = descriptor.getColorScheme();
        IBufferSource buffers = AbstractBufferSource.defaultBufferSource();
        ExtendedItemRenderer.renderSkinInTooltip(bakedSkin, colorScheme, itemStack, dx, dy, 500.0f, size, size, 30.0f, 45.0f, 0.0f, 0.0f, 0xF000F0, context.state().ctm(), buffers);
        buffers.endBatch();
    }
}

