/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Converter;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.init.platform.event.common.RegisterDataPackEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class DataPackManager {
    private static final ImmutableMap<DataPackType, DataPackLoader> INSTANCES = ImmutableMap.builder().put((Object)DataPackType.SERVER_DATA, (Object)new Data()).put((Object)DataPackType.CLIENT_RESOURCES, (Object)new Resources()).put((Object)DataPackType.BUNDLED_DATA, (Object)new Bundle()).build();

    public static DataPackLoader byType(DataPackType packType) {
        return (DataPackLoader)INSTANCES.get((Object)packType);
    }

    public static void register(DataPackType packType, String path, Function<ResourceLocation, IDataPackBuilder> provider, Runnable willLoadHandler, Runnable didLoadHandler, int order) {
        DataPackLoader loader = DataPackManager.byType(packType);
        if (loader != null) {
            loader.add(new DataPackLoader.Entry(path, provider, willLoadHandler, didLoadHandler, order));
        }
    }

    public static void init(RegisterDataPackEvent event) {
        event.register(DataPackManager.byType(DataPackType.SERVER_DATA));
    }

    protected static class Data
    extends DataPackLoader {
        protected Data() {
        }

        @Override
        public void build(DataPackLoader.TaskQueue taskQueue, ResourceManager resourceManager) {
            DataPackLoader loader = DataPackManager.byType(DataPackType.BUNDLED_DATA);
            if (loader != null && !loader.isEmpty()) {
                loader.build(taskQueue, resourceManager);
            }
            super.build(taskQueue, resourceManager);
        }
    }

    protected static class Resources
    extends DataPackLoader {
        protected Resources() {
        }

        @Override
        public void build(DataPackLoader.TaskQueue taskQueue, ResourceManager resourceManager) {
            DataPackLoader loader = DataPackManager.byType(DataPackType.BUNDLED_DATA);
            if (loader != null && !loader.isEmpty()) {
                loader.build(taskQueue, Converter.asBundleManager(resourceManager));
            }
            super.build(taskQueue, resourceManager);
        }
    }

    protected static class Bundle
    extends DataPackLoader {
        protected Bundle() {
        }

        @Override
        public void build(DataPackLoader.TaskQueue taskQueue, ResourceManager resourceManager) {
            super.build(taskQueue, resourceManager);
            this.entries.clear();
        }
    }
}

