/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.world.entity.player.Player;

public class UpdateContextPacket
extends CustomPacket {
    private UUID token = null;
    private ByteBuf buffer = null;

    public UpdateContextPacket() {
    }

    public UpdateContextPacket(Player player) {
        this.token = player.m_20148_();
    }

    public UpdateContextPacket(IFriendlyByteBuf buffer) {
        this.buffer = buffer.asByteBuf();
        this.buffer.retain();
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        if (this.token != null) {
            buffer.writeBoolean(true);
            buffer.writeUUID(ModContext.t2(this.token));
            buffer.writeUUID(ModContext.t3(this.token));
            buffer.writeUtf("j");
        } else {
            buffer.writeBoolean(false);
        }
        this.writeConfigSpec(buffer);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        if (this.buffer != null) {
            IFriendlyByteBuf reader = IFriendlyByteBuf.wrap(this.buffer);
            if (this.buffer.readBoolean()) {
                ModContext.init(reader.readUUID(), reader.readUUID());
                this.checkNetworkVersion(reader.readUtf());
            }
            this.readConfigSpec(reader);
            this.buffer.release();
        }
    }

    private void writeConfigSpec(IFriendlyByteBuf buffer) {
        try {
            Map<Object, Object> fields = new HashMap();
            if (EnvironmentManager.isDedicatedServer()) {
                fields = ModConfigSpec.COMMON.snapshot();
            }
            buffer.writeInt(fields.size());
            if (fields.size() == 0) {
                return;
            }
            ByteBufOutputStream bo = new ByteBufOutputStream(buffer.asByteBuf());
            ObjectOutputStream oo = new ObjectOutputStream((OutputStream)bo);
            for (Map.Entry<Object, Object> entry : fields.entrySet()) {
                oo.writeUTF((String)entry.getKey());
                oo.writeObject(entry.getValue());
            }
            oo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readConfigSpec(IFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        if (size == 0) {
            return;
        }
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            ByteBufInputStream bi = new ByteBufInputStream(buffer.asByteBuf());
            ObjectInputStream oi = new ObjectInputStream((InputStream)bi);
            for (int i = 0; i < size; ++i) {
                String name = oi.readUTF();
                Object value = oi.readObject();
                fields.put(name, value);
            }
            oi.close();
            ModConfigSpec.COMMON.apply(fields);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkNetworkVersion(String version) {
        if (!version.equals("j")) {
            ModLog.warn("network protocol conflict, server: {}, client: {}", version, "j");
        }
    }
}

