/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExecuteCommandPacket
extends CustomPacket {
    private final Class<?> object;
    private final Mode mode;
    private final String key;
    private final Object value;

    public ExecuteCommandPacket(Class<?> object, String key, Object value, Mode mode) {
        this.object = object;
        this.mode = mode;
        this.key = key;
        this.value = value;
    }

    public ExecuteCommandPacket(IFriendlyByteBuf buffer) {
        this.object = this.readClass(buffer);
        this.mode = buffer.readEnum(Mode.class);
        this.key = buffer.readUtf();
        this.value = this.readObject(buffer);
    }

    public static ExecuteCommandPacket set(Class<?> obj, String key, Object value) {
        return new ExecuteCommandPacket(obj, key, value, Mode.SET);
    }

    public static ExecuteCommandPacket get(Class<?> obj, String key) {
        return new ExecuteCommandPacket(obj, key, null, Mode.GET);
    }

    public static ExecuteCommandPacket invoke(Class<?> obj, String key) {
        return new ExecuteCommandPacket(obj, key, null, Mode.INVOKE);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeUtf(this.object.getName());
        buffer.writeEnum(this.mode);
        buffer.writeUtf(this.key);
        this.writeObject(buffer, this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        try {
            Object data = this.value;
            switch (this.mode.ordinal()) {
                case 1: {
                    Field field = this.object.getField(this.key);
                    data = field.get(this.object);
                    break;
                }
                case 0: {
                    Field field = this.object.getField(this.key);
                    field.set(this.object, data);
                    break;
                }
            }
            player.m_213846_((Component)Component.m_237113_((String)(this.key + " = " + String.valueOf(data))));
            if (ModConfig.Client.class == this.object) {
                ModConfigSpec.CLIENT.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(IFriendlyByteBuf buffer) {
        Object object;
        if (this.mode != Mode.SET) {
            return null;
        }
        ByteBufInputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = new ByteBufInputStream(buffer.asByteBuf());
            objectInputStream = new ObjectInputStream((InputStream)inputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
                throw throwable;
            }
            StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
            return exception2;
        }
        StreamUtils.closeQuietly(new Closeable[]{objectInputStream, inputStream});
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(IFriendlyByteBuf buffer, Object object) {
        if (this.mode != Mode.SET) {
            return;
        }
        ByteBufOutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new ByteBufOutputStream(buffer.asByteBuf());
            objectOutputStream = new ObjectOutputStream((OutputStream)outputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Exception exception1) {
            try {
                exception1.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
                throw throwable;
            }
            StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
        }
        StreamUtils.closeQuietly(new Closeable[]{objectOutputStream, outputStream});
    }

    private Class<?> readClass(IFriendlyByteBuf buffer) {
        try {
            return Class.forName(buffer.readUtf());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static enum Mode {
        SET,
        GET,
        INVOKE;

    }
}

