/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.model.BakedModel.ABI;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedFirstPersonArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.FallbackEntityRenderPatch;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.LivingEntityRenderPatch;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.EmbeddedSkinStack;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientWardrobeHandler {
    private static Runnable INVENTORY_RENDER_POST_EVENT = null;
    public static ItemStack RENDERING_GUI_ITEM = null;
    public static final float SCALE = 0.0625f;

    public static void init() {
    }

    public static void startRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = itemStack;
    }

    public static void endRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = null;
    }

    public static void onRenderSpecificHand(LivingEntity entity, float partialTicks, int packedLight, AbstractItemTransformType transformType, PoseStack poseStackIn, MultiBufferSource buffersIn, Runnable cancelHandler) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        IBufferSource buffers = AbstractBufferSource.wrap(buffersIn);
        BakedFirstPersonArmature armature = BakedFirstPersonArmature.defaultBy(transformType);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, partialTicks, transformType, poseStack, buffers);
        poseStack.pushPose();
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        int count = ClientWardrobeHandler.render((Entity)entity, armature, context, renderData::getArmorSkins);
        if (count != 0 && !ModDebugger.handOverride) {
            cancelHandler.run();
        }
        context.release();
        poseStack.popPose();
    }

    public static void onRenderEntityPre(Entity entity, float partialTicks, PoseStack poseStackIn, MultiBufferSource buffersIn, int packedLight) {
        FallbackEntityRenderPatch.activate(entity, partialTicks, packedLight, poseStackIn, buffersIn, null);
    }

    public static void onRenderEntity(Entity entity, float partialTicks, PoseStack poseStackIn, MultiBufferSource buffersIn, int packedLight) {
        FallbackEntityRenderPatch.apply(entity, null);
    }

    public static void onRenderEntityPost(Entity entity, float partialTicks, PoseStack poseStackIn, MultiBufferSource buffersIn, int packedLight) {
        FallbackEntityRenderPatch.deactivate(entity, null);
    }

    public static void onRenderLivingEntityPre(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, LivingEntityRenderer<?, ?> entityRenderer) {
        LivingEntityRenderPatch.activate(entity, partialTicks, packedLight, poseStackIn, buffersIn, entityRenderer, null);
    }

    public static void onRenderLivingEntity(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, LivingEntityRenderer<?, ?> entityRenderer) {
        LivingEntityRenderPatch.apply(entity, null);
    }

    public static void onRenderLivingEntityPost(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStackIn, MultiBufferSource buffersIn, LivingEntityRenderer<?, ?> entityRenderer) {
        LivingEntityRenderPatch.deactivate(entity, null);
    }

    @Nullable
    public static EmbeddedSkinStack getEmbeddedSkinStack(@Nullable LivingEntity entity, @Nullable Level level, ItemStack itemStack, AbstractItemTransformType transformType) {
        Iterator<SkinRenderData.Entry> iterator;
        SkinRenderData renderData;
        if (RENDERING_GUI_ITEM != itemStack && (renderData = SkinRenderData.of((Entity)entity)) != null && (iterator = renderData.getItemSkins(itemStack, entity instanceof MannequinEntity).iterator()).hasNext()) {
            SkinRenderData.Entry entry = iterator.next();
            return new EmbeddedSkinStack(0, entry);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return null;
        }
        if (itemStack.m_150930_((Item)ModItems.SKIN.get())) {
            return new EmbeddedSkinStack(2, descriptor, itemStack);
        }
        if (descriptor.getOptions().getEmbeddedItemRenderer() != 0) {
            if (descriptor.getOptions().getEmbeddedItemRenderer() == 2) {
                return new EmbeddedSkinStack(1, descriptor, itemStack);
            }
            return null;
        }
        if (ModConfig.enableEmbeddedSkinRenderer() || descriptor.getType() == SkinTypes.ITEM) {
            return new EmbeddedSkinStack(1, descriptor, itemStack);
        }
        return null;
    }

    public static void renderEmbeddedSkin(@Nullable LivingEntity entity, @Nullable Level level, ItemStack itemStack, EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, PoseStack poseStackIn, MultiBufferSource buffersIn, BakedModel bakedModel, int packedLight, int overlay, CallbackInfo callback) {
        int counter = 0;
        switch (transformType) {
            case GUI: 
            case GROUND: 
            case FIXED: {
                counter = ClientWardrobeHandler._renderEmbeddedSkinInBox(embeddedStack, transformType, leftHandHackery, poseStackIn, buffersIn, packedLight, overlay);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                if (embeddedStack.getEntry() == null) {
                    if (ClientWardrobeHandler.shouldRenderInBox(embeddedStack)) {
                        counter = ClientWardrobeHandler._renderEmbeddedSkinInBox(embeddedStack, transformType, leftHandHackery, poseStackIn, buffersIn, packedLight, overlay);
                        break;
                    }
                    counter = ClientWardrobeHandler._renderEmbeddedSkin(embeddedStack, transformType, leftHandHackery, poseStackIn, buffersIn, packedLight, overlay);
                    break;
                }
                SkinRenderData renderData = SkinRenderData.of((Entity)entity);
                if (renderData == null) break;
                IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
                IBufferSource buffers = AbstractBufferSource.wrap(buffersIn);
                BakedArmature armature = BakedArmature.defaultBy(Armatures.ANY);
                SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, 0.0f, transformType, poseStack, buffers);
                poseStack.pushPose();
                poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
                context.setReferenced(SkinItemSource.create(800.0f, itemStack, transformType));
                counter = ClientWardrobeHandler.render((Entity)entity, armature, context, () -> Collections.singleton(embeddedStack.getEntry()));
                context.release();
                poseStack.popPose();
                break;
            }
        }
        if (counter != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
    }

    private static int _renderEmbeddedSkinInBox(EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, PoseStack poseStackIn, MultiBufferSource buffersIn, int packedLight, int overlay) {
        int count = 0;
        SkinDescriptor descriptor = embeddedStack.getDescriptor();
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
        if (bakedSkin == null) {
            return count;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        IBufferSource buffers = AbstractBufferSource.wrap(buffersIn);
        Vector3f rotation = Vector3f.ZERO;
        Vector3f scale = Vector3f.ONE;
        poseStack.pushPose();
        if (bakedSkin.getItemModel() == null) {
            BakedItemModel itemModel = BakedItemModel.DEFAULT;
            ItemTransform transform = ABI.getTransform((BakedModel)itemModel, transformType);
            ABI.applyTransform((BakedModel)itemModel, poseStack, leftHandHackery, transformType);
            rotation = new Vector3f(-transform.f_111755_.x(), -transform.f_111755_.y(), transform.f_111755_.z());
            scale = new Vector3f(transform.f_111757_.x(), transform.f_111757_.y(), transform.f_111757_.z());
        }
        SkinItemSource itemSource = SkinItemSource.create(descriptor.sharedItemStack());
        itemSource.setScale(scale);
        itemSource.setRotation(rotation);
        itemSource.setTransformType(transformType);
        ColorScheme scheme = descriptor.getColorScheme();
        count = ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, scale, 0.0f, packedLight, itemSource, poseStack, buffers);
        poseStack.popPose();
        return count;
    }

    private static int _renderEmbeddedSkin(EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, PoseStack poseStackIn, MultiBufferSource buffersIn, int packedLight, int overlay) {
        int count = 0;
        SkinDescriptor descriptor = embeddedStack.getDescriptor();
        SkinRenderTesselator context = SkinRenderTesselator.create(descriptor, Tickets.INVENTORY);
        if (context == null) {
            return count;
        }
        IPoseStack poseStack = AbstractPoseStack.wrap(poseStackIn);
        IBufferSource buffers = AbstractBufferSource.wrap(buffersIn);
        poseStack.pushPose();
        poseStack.scale(-16.0f, -16.0f, 16.0f);
        context.setRenderData(SkinRenderData.of((Entity)context.getMannequin()));
        context.setLightmap(packedLight);
        context.setPartialTicks(0.0f);
        context.setReferenced(SkinItemSource.create(800.0f, embeddedStack.getItemStack(), transformType));
        context.setColorScheme(descriptor.getColorScheme());
        count = context.draw(poseStack, buffers);
        poseStack.popPose();
        return count;
    }

    public static void onRenderInventoryEntityPre(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY) {
        int top;
        int left;
        int height;
        int width;
        if (!ModConfig.Client.enableEntityInInventoryClip) {
            return;
        }
        switch (scale) {
            case 20: {
                width = 32;
                height = 43;
                left = x - width / 2 + 1;
                top = y - height + 4;
                break;
            }
            case 30: {
                width = 49;
                height = 70;
                left = x - width / 2 - 1;
                top = y - height + 3;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.addClipRect(left, top, width, height);
        INVENTORY_RENDER_POST_EVENT = RenderSystem::removeClipRect;
    }

    public static void onRenderInventoryEntityPost(LivingEntity entity) {
        if (INVENTORY_RENDER_POST_EVENT != null) {
            INVENTORY_RENDER_POST_EVENT.run();
            INVENTORY_RENDER_POST_EVENT = null;
        }
    }

    public static int render(Entity entity, BakedArmature bakedArmature, SkinRenderContext context, Supplier<Iterable<SkinRenderData.Entry>> provider) {
        int r = 0;
        for (SkinRenderData.Entry entry : provider.get()) {
            BakedSkin bakedSkin = entry.getBakedSkin();
            SkinItemSource itemSource = context.getReferenced();
            ItemStack itemStack = itemSource.getItem();
            if (itemStack.m_41619_()) {
                itemStack = entry.getItemStack();
            }
            if (itemSource == SkinItemSource.EMPTY) {
                itemSource = SkinItemSource.create(itemStack);
            }
            itemSource.setItem(itemStack);
            itemSource.setRenderPriority(entry.getRenderPriority());
            context.setReferenced(itemSource);
            bakedSkin.setupAnim(entity, context.getAnimationTicks(), itemSource);
            r += SkinRenderer.render(entity, bakedArmature, bakedSkin, entry.getBakedScheme(), context);
        }
        return r;
    }

    private static boolean shouldRenderInBox(EmbeddedSkinStack embeddedStack) {
        if (embeddedStack.getMode() == 2) {
            return true;
        }
        ISkinType skinType = embeddedStack.getDescriptor().getType();
        if (skinType == SkinTypes.ITEM_BOAT || skinType == SkinTypes.ITEM_FISHING || skinType == SkinTypes.HORSE) {
            return true;
        }
        if (skinType instanceof ISkinToolType) {
            return false;
        }
        return skinType != SkinTypes.ITEM;
    }
}

