/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.StreamUtils;

public class ModMenuOptions {
    private static final ModMenuOptions INSTANCE = new ModMenuOptions();
    private final File contentPath;
    private final LinkedHashMap<String, IDataPackObject> values = new LinkedHashMap();

    private ModMenuOptions() {
        this.contentPath = new File(EnvironmentManager.getRootDirectory(), "options.json");
        try {
            if (this.contentPath.exists()) {
                this.load();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static ModMenuOptions getInstance() {
        return INSTANCE;
    }

    public void putString(String key, String value) {
        this.values.put(key, IDataPackObject.of((JsonElement)new JsonPrimitive(value)));
        this.setChanged();
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        IDataPackObject obj = this.values.get(key);
        if (obj != null) {
            return obj.stringValue();
        }
        return defaultValue;
    }

    public void putInt(String key, int value) {
        this.values.put(key, IDataPackObject.of((JsonElement)new JsonPrimitive((Number)value)));
        this.setChanged();
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        IDataPackObject obj = this.values.get(key);
        if (obj != null) {
            return obj.intValue();
        }
        return defaultValue;
    }

    public void putBoolean(String key, boolean value) {
        this.values.put(key, IDataPackObject.of((JsonElement)new JsonPrimitive(Boolean.valueOf(value))));
        this.setChanged();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        IDataPackObject obj = this.values.get(key);
        if (obj != null) {
            return obj.boolValue();
        }
        return defaultValue;
    }

    private void load() throws IOException {
        IDataPackObject object = StreamUtils.fromPackObject(new FileInputStream(this.contentPath));
        if (object == null) {
            return;
        }
        object.entrySet().forEach(it -> this.values.put((String)it.getKey(), (IDataPackObject)it.getValue()));
    }

    private void save() {
        try {
            IDataPackObject packObject = IDataPackObject.of((JsonElement)new JsonObject());
            this.values.forEach(packObject::set);
            StreamUtils.writePackObject(packObject, new FileOutputStream(this.contentPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setChanged() {
        EnvironmentExecutor.runOnBackground(() -> this::save);
    }
}

