/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.utils.ItemMatcher;
import net.minecraft.world.item.ItemStack;

public class ModItemMatchers {
    public static final ItemMatcher SWORDS = ModItemMatchers.builder().match("sword").match("machete").match("gladius").match("falchion").match("saber").match("dagger").match("cullass").match("rapier").match("claymore").match("flamberge").match("zweihander").match("dao").match("jian").match("odachi").match("tachi").match("wakizashi").match("katana").match("chokuto").match("ninjato").match("scimitar").match("shamshir").build();
    public static final ItemMatcher TRIDENTS = ModItemMatchers.builder().match("trident").match("lance").match("halbred").match("spear").build();
    public static final ItemMatcher SHIELDS = ModItemMatchers.simple("shield");
    public static final ItemMatcher BOWS = ModItemMatchers.simple("bow");
    public static final ItemMatcher PICKAXES = ModItemMatchers.simple("pickaxe");
    public static final ItemMatcher AXES = ModItemMatchers.simple("(?<!pick)axe");
    public static final ItemMatcher SHOVELS = ModItemMatchers.simple("shovel");
    public static final ItemMatcher HOES = ModItemMatchers.simple("hoe");

    private static ItemMatcher simple(String name) {
        return ModItemMatchers.builder().match(name).build();
    }

    private static MatcherBuilder builder() {
        return new MatcherBuilder();
    }

    private static class MatcherBuilder {
        private final StringBuffer buffer;
        private final ArrayList<String> whitelist = new ArrayList();
        private final ArrayList<String> blacklist = new ArrayList();
        private Predicate<ItemStack> requirements;

        private MatcherBuilder() {
            this.buffer = new StringBuffer();
        }

        private MatcherBuilder match(String tag) {
            if (this.buffer.length() != 0) {
                this.buffer.append("|");
            }
            this.buffer.append(tag);
            return this;
        }

        private MatcherBuilder add(String tag) {
            this.whitelist.add(tag);
            return this;
        }

        private MatcherBuilder remove(String tag) {
            this.blacklist.add(tag);
            return this;
        }

        private ItemMatcher build() {
            return new ItemMatcher(this.buffer.toString(), this.whitelist, this.blacklist, this.requirements);
        }
    }
}

