/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.data.IDataPackBuilder;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class ModEntityProfiles {
    private static final ArrayList<BiConsumer<IEntityTypeProvider<?>, EntityProfile>> INSERT_HANDLERS = new ArrayList();
    private static final ArrayList<BiConsumer<IEntityTypeProvider<?>, EntityProfile>> REMOVE_HANDLERS = new ArrayList();
    private static final HashMap<ResourceLocation, EntityProfile> PENDING_ENTITY_PROFILES = new HashMap();
    private static final HashMap<IEntityTypeProvider<?>, EntityProfile> PENDING_ENTITIES = new HashMap();
    private static final HashMap<ResourceLocation, EntityProfile> ALL_ENTITY_PROFILES = new HashMap();
    private static final HashMap<IEntityTypeProvider<?>, EntityProfile> ALL_ENTITIES = new HashMap();

    private static BiConsumer<IEntityTypeProvider<?>, EntityProfile> dispatch(ArrayList<BiConsumer<IEntityTypeProvider<?>, EntityProfile>> consumers) {
        return (entityType, entityProfile) -> consumers.forEach(consumer -> consumer.accept(entityType, entityProfile));
    }

    public static void init() {
        DataPackManager.register(DataPackType.BUNDLED_DATA, "skin/profiles", SimpleLoader::new, SimpleLoader::clean, SimpleLoader::freeze, 1);
    }

    public static void forEach(BiConsumer<IEntityTypeProvider<?>, EntityProfile> consumer) {
        ALL_ENTITIES.forEach(consumer);
    }

    public static void addListener(BiConsumer<IEntityTypeProvider<?>, EntityProfile> removeHandler, BiConsumer<IEntityTypeProvider<?>, EntityProfile> insertHandler) {
        REMOVE_HANDLERS.add(removeHandler);
        INSERT_HANDLERS.add(insertHandler);
        ALL_ENTITIES.forEach(insertHandler);
    }

    @Nullable
    public static <T extends Entity> EntityProfile getProfile(T entity) {
        return ModEntityProfiles.getProfile(entity.m_6095_());
    }

    @Nullable
    public static <T extends Entity> EntityProfile getProfile(EntityType<T> entityType) {
        return ObjectUtils.find(ALL_ENTITIES, entityType, Supplier::get);
    }

    @Nullable
    public static EntityProfile getProfile(ResourceLocation registryName) {
        return ALL_ENTITY_PROFILES.get(registryName);
    }

    public static class SimpleLoader
    implements IDataPackBuilder {
        private boolean locked = false;
        private final ResourceLocation registryName;
        private final ArrayList<IEntityTypeProvider<?>> entities = new ArrayList();
        private final LinkedHashMap<SkinSlotType, Function<SkinSlotType, Integer>> supports = new LinkedHashMap();

        public SimpleLoader(ResourceLocation registryName) {
            this.registryName = ModConstants.key(SkinFileUtils.getBaseName(registryName.m_135815_()));
        }

        @Override
        public void append(IDataPackObject object, ResourceLocation location) {
            if (object.get("replace").boolValue()) {
                this.locked = false;
                this.supports.clear();
                this.entities.clear();
            }
            object.get("locked").ifPresent(o -> {
                this.locked = o.boolValue();
            });
            object.get("slots").entrySet().forEach(it -> {
                SkinSlotType type = SkinSlotType.byName((String)it.getKey());
                String name = ((IDataPackObject)it.getValue()).stringValue();
                if (type == null) {
                    return;
                }
                if (name.equals("default_mob_slots")) {
                    this.supports.put(type, type1 -> ModConfig.Common.prefersWardrobeMobSlots);
                } else if (name.equals("default_player_slots")) {
                    this.supports.put(type, type1 -> ModConfig.Common.prefersWardrobePlayerSlots);
                } else {
                    int count = ((IDataPackObject)it.getValue()).intValue();
                    this.supports.put(type, type1 -> count);
                }
            });
            object.get("entities").allValues().forEach(o -> this.entities.add(IEntityTypeProvider.of(o.stringValue())));
        }

        @Override
        public void build() {
            EntityProfile profile = new EntityProfile(this.registryName, this.supports, this.entities, this.locked);
            this.entities.forEach((Consumer<IEntityTypeProvider<?>>)((Consumer<IEntityTypeProvider>)entityType -> PENDING_ENTITIES.put((IEntityTypeProvider<?>)entityType, profile)));
            PENDING_ENTITY_PROFILES.put(this.registryName, profile);
        }

        private static void clean() {
        }

        private static void freeze() {
            ObjectUtils.difference(ALL_ENTITY_PROFILES, PENDING_ENTITY_PROFILES, (registryName, entityProfile) -> ModLog.debug("Unregistering Entity Profile '{}'", registryName), (registryName, entityProfile) -> ModLog.debug("Registering Entity Profile '{}'", registryName));
            ObjectUtils.difference(ALL_ENTITIES, PENDING_ENTITIES, ModEntityProfiles.dispatch(REMOVE_HANDLERS), ModEntityProfiles.dispatch(INSERT_HANDLERS));
            ALL_ENTITIES.clear();
            ALL_ENTITY_PROFILES.clear();
            ALL_ENTITIES.putAll(PENDING_ENTITIES);
            ALL_ENTITY_PROFILES.putAll(PENDING_ENTITY_PROFILES);
            PENDING_ENTITIES.clear();
            PENDING_ENTITY_PROFILES.clear();
        }
    }
}

